/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.component.buttons;

import java.util.function.Consumer;
import journeymap.client.ui.component.TextBox;
import journeymap.client.ui.component.buttons.Button;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;

public class TextBoxButton
extends Button {
    protected TextBox textBox;

    public TextBoxButton(String text) {
        super(text);
    }

    public TextBoxButton(Object text, Font fontRenderer, int width, int height) {
        this(text, fontRenderer, width, height, false, false);
    }

    public TextBoxButton(Object text, Font fontRenderer, int width, int height, boolean isNumeric, boolean negative) {
        super(text.toString());
        this.textBox = new TextBox(text, fontRenderer, width, height - 4, isNumeric, negative);
        this.textBox.setMinLength(1);
    }

    public String getText() {
        return this.textBox.getValue();
    }

    public String getSelectedText() {
        return this.textBox.getHighlighted();
    }

    public void setResponder(Consumer<String> responder) {
        this.textBox.setResponder(responder);
    }

    public void setMinLength(int minLength) {
        this.textBox.setMinLength(minLength);
    }

    @Override
    public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.textBox.setX(this.getX());
        this.textBox.setY(this.getY());
        this.textBox.render(graphics, mouseX, mouseY, partialTicks);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int mouseButton) {
        this.textBox.mouseReleased(mouseX, mouseY, mouseButton);
        return super.mouseReleased(mouseX, mouseY, mouseButton);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double mouseDX, double mouseDY) {
        this.textBox.mouseDragged(mouseX, mouseY, button, mouseDX, mouseDY);
        return super.mouseDragged(mouseX, mouseY, button, mouseDX, mouseDY);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        return this.textBox.mouseClicked(mouseX, mouseY, 0);
    }

    public boolean charTyped(char typedChar, int keyCode) {
        return this.textBox.charTyped(typedChar, keyCode);
    }

    public boolean keyPressed(int key, int value, int modifier) {
        return this.textBox.keyPressed(key, value, modifier);
    }

    public boolean isFocused() {
        return this.textBox.isFocused();
    }

    @Override
    public boolean isActive() {
        return this.textBox.isActive();
    }

    public void setFocused(boolean focused) {
        this.textBox.setFocused(focused);
    }

    public boolean isHoveredOrFocused() {
        return this.textBox.isHovered() || this.textBox.isFocused();
    }

    @Override
    public void setVisible(boolean visible) {
        this.textBox.setVisible(visible);
        super.setVisible(visible);
    }

    @Override
    public int getCenterX() {
        return this.textBox.getCenterX();
    }

    @Override
    public int getRightX() {
        return this.textBox.getRightX();
    }

    @Override
    public int getBottomY() {
        return this.textBox.getBottomY();
    }

    @Override
    public int getMiddleY() {
        return this.textBox.getMiddleY();
    }

    public int getWidth() {
        if (this.textBox != null) {
            return this.textBox.getWidth();
        }
        return this.width;
    }

    @Override
    public void setWidth(int width) {
        if (this.textBox != null) {
            this.textBox.setWidth(width);
        }
        this.width = width;
    }

    public int getHeight() {
        if (this.textBox != null) {
            return this.textBox.getHeight();
        }
        return this.height;
    }

    public void setText(String text) {
        this.textBox.setValue(text);
    }
}

