/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.component.buttons;

import java.util.Objects;
import journeymap.client.Constants;
import journeymap.client.render.draw.DrawUtil;
import journeymap.client.ui.component.DropDownItem;
import journeymap.client.ui.component.buttons.PropertyDropdownButton;
import journeymap.common.properties.config.StringField;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;

public class FullscreenThemeDropdownButton
extends PropertyDropdownButton<String> {
    private String editSymbol = " \u270e";
    private boolean needReopen;

    public FullscreenThemeDropdownButton(Font fr, StringField field, boolean needReopen, Button.OnPress pressable) {
        super(field.getValidValues(), Constants.getString(field.getKey()), field, pressable);
        this.setTextOnly(fr);
        this.paneWidth -= this.buttonBuffer;
        this.paneScreen.setPaneWidth(this.paneWidth);
        this.width -= this.buttonBuffer;
        this.buttonBuffer = 0;
        this.needReopen = needReopen;
    }

    @Override
    public String getFormattedLabel(String value) {
        return value;
    }

    @Override
    public void setTextOnly(Font fr) {
        Objects.requireNonNull(fr);
        this.setHeight(9 * 2 + 2);
        this.fitWidth(fr);
        this.setDrawBackground(false);
        this.setDrawFrame(false);
    }

    @Override
    protected int getPaneHeight() {
        return this.items.size() * (((DropDownItem)((Object)this.items.get(0))).getHeight() + 3);
    }

    @Override
    public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        if (this.needReopen) {
            this.needReopen = false;
            this.openDropDown();
        }
        if (this.isEnabled() && this.isHovered()) {
            DrawUtil.drawRectangle(graphics, super.getX() + 1, super.getY() - 2, this.width - 2, this.height + 3, this.customBgHoverColor2, 0.5f);
        }
        this.varLabelColor = this.labelColor;
        if (!this.isEnabled()) {
            this.varLabelColor = this.disabledLabelColor;
        } else if (this.isHovered()) {
            this.varLabelColor = this.hoverLabelColor;
        } else if (this.labelColor != null) {
            this.varLabelColor = this.labelColor;
        } else if (this.getActiveColor() != 0) {
            this.varLabelColor = this.getActiveColor();
        }
        int textX = this.getCenterX();
        DrawUtil.drawLabel(graphics, this.baseLabel + this.editSymbol, textX, this.getMiddleY() - 5, DrawUtil.HAlign.Center, DrawUtil.VAlign.Middle, null, 0.0f, this.varLabelColor, 1.0f, 1.0, this.drawLabelShadow, 0.0);
        DrawUtil.drawLabel(graphics, this.getMessage().getString(), textX, this.getMiddleY() + 5, DrawUtil.HAlign.Center, DrawUtil.VAlign.Middle, null, 0.0f, this.varLabelColor, 1.0f, 1.0, this.drawLabelShadow, 0.0);
    }
}

