/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.component.buttons;

import com.mojang.blaze3d.platform.Window;
import java.util.List;
import journeymap.client.render.draw.DrawUtil;
import journeymap.client.ui.component.DropDownItem;
import journeymap.client.ui.component.Removable;
import journeymap.client.ui.component.SelectableParent;
import journeymap.client.ui.component.buttons.Button;
import journeymap.client.ui.component.screens.ScrollPaneScreen;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;

public class DropDownButton
extends Button
implements Removable,
SelectableParent {
    private static final int MAX_DISPLAY_SIZE = 6;
    protected boolean visible = false;
    protected DropDownItem selected;
    protected List<DropDownItem> items;
    protected int paneWidth;
    protected Button.OnPress onPress;
    protected Glyph activeGlyph = Glyph.DOWN;
    protected int panelMargin = 2;
    protected ScrollPaneScreen paneScreen;
    protected int buttonBuffer = 50;
    protected boolean scaleButtonWidth = true;

    public DropDownButton(String label, Button.OnPress onPress) {
        super(label, DropDownButton.emptyPressable());
        this.onPress = onPress;
    }

    public void setItems(List<DropDownItem> items) {
        this.items = items;
        this.paneWidth = this.getWidth();
        this.paneScreen = new ScrollPaneScreen(this, items, this.paneWidth, this.getPaneHeight(), this.getX(), this.getPanelLocation());
    }

    public void setRenderSolidBackground(boolean value) {
        this.paneScreen.setRenderSolidBackground(value);
    }

    public void setRenderDecorations(boolean value) {
        this.paneScreen.setRenderDecorations(value);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        boolean buttonClicked = super.mouseClicked(mouseX, mouseY, button);
        if (buttonClicked && !this.visible) {
            this.openDropDown();
            return true;
        }
        return buttonClicked;
    }

    protected void openDropDown() {
        if (!this.visible) {
            this.visible = true;
            this.setEnabled(false);
            this.paneScreen.setPaneX(this.getX());
            this.paneScreen.setPaneY(this.getPanelLocation());
            this.paneScreen.display();
        }
    }

    @Override
    public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.renderWidget(graphics, mouseX, mouseY, partialTicks);
        DrawUtil.drawLabel(graphics, this.visible ? this.activeGlyph.getCode() : Glyph.CLOSED.getCode(), this.getX() + 16, this.getMiddleY() - 1, DrawUtil.HAlign.Left, DrawUtil.VAlign.Middle, 0, 0.0f, this.visible ? this.disabledLabelColor : this.getLabelColor(), this.visible ? 0.25f : 1.0f, 1.5, false);
    }

    protected int getPanelLocation() {
        Window window = Minecraft.getInstance().getWindow();
        int panelHeight = this.getPaneHeight();
        int windowBottom = window.getGuiScaledHeight();
        if (super.getY() - (this.panelMargin + panelHeight) <= 0) {
            this.activeGlyph = Glyph.DOWN;
            return super.getY() + this.panelMargin + this.height;
        }
        if (super.getY() + (this.panelMargin + panelHeight) > windowBottom) {
            this.activeGlyph = Glyph.UP;
            return super.getY() - panelHeight - this.panelMargin;
        }
        this.activeGlyph = Glyph.DOWN;
        return super.getY() + this.panelMargin + this.height;
    }

    protected int getPaneHeight() {
        int size = Math.min(this.items.size(), 6);
        return size * (this.items.get(0).getHeight() + 5);
    }

    @Override
    public void onRemove() {
        this.visible = false;
        this.setEnabled(true);
    }

    public int getWidth() {
        int width = 0;
        if (this.items != null) {
            Font fontRenderer = Minecraft.getInstance().font;
            for (DropDownItem item : this.items) {
                width = Math.max(width, fontRenderer.width(this.getLabel(item)));
            }
            if (!this.scaleButtonWidth) {
                return width + this.buttonBuffer;
            }
            this.width = width + this.buttonBuffer;
        }
        return this.width;
    }

    protected String getLabel(DropDownItem item) {
        return item.getLabel();
    }

    @Override
    public void setSelected(DropDownItem selected) {
        this.selected = selected;
        this.onPress.onPress((net.minecraft.client.gui.components.Button)selected);
        this.setMessage((Component)Component.literal((String)selected.getLabel()));
    }

    protected DropDownItem getSelected() {
        return this.selected;
    }

    protected String getSelectedLabel() {
        return this.getLabel(this.selected);
    }

    public static enum Glyph {
        CLOSED("\u25b6"),
        UP("\u25b2"),
        DOWN("\u25bc");

        String code;

        private Glyph(String code) {
            this.code = code;
        }

        String getCode() {
            return this.code;
        }

        public String toString() {
            return this.code;
        }
    }
}

