/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.component;

import java.util.function.DoubleSupplier;
import journeymap.client.texture.TextureCache;
import net.minecraft.client.gui.ComponentPath;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.navigation.FocusNavigationEvent;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.network.chat.CommonComponents;

public class LogoWidget
extends AbstractWidget {
    private static final int TEX_WIDTH = 60;
    private static final int PADDING = 3;
    private final DoubleSupplier scaleFactorSupplier;

    public LogoWidget(DoubleSupplier scaleFactorSupplier) {
        super(0, 0, LogoWidget.calculateWidth(scaleFactorSupplier) + 6, LogoWidget.calculateWidth(scaleFactorSupplier) + 6, CommonComponents.EMPTY);
        this.scaleFactorSupplier = scaleFactorSupplier;
    }

    protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
    }

    public void playDownSound(SoundManager soundHandler) {
    }

    public boolean isActive() {
        return false;
    }

    public ComponentPath nextFocusPath(FocusNavigationEvent focusNavigationEvent) {
        return null;
    }

    public int getWidth() {
        return LogoWidget.calculateWidth(this.scaleFactorSupplier) + 6;
    }

    public int getHeight() {
        return LogoWidget.calculateWidth(this.scaleFactorSupplier) + 6;
    }

    protected void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        int texWidth = LogoWidget.calculateWidth(this.scaleFactorSupplier);
        graphics.blit(TextureCache.Logo, this.getX() + 3, this.getY() + 3, texWidth, texWidth, 0.0f, 0.0f, 60, 60, 60, 60);
    }

    private static int calculateWidth(DoubleSupplier scaleFactorSupplier) {
        return (int)(60.0 / scaleFactorSupplier.getAsDouble() / 2.0);
    }
}

