/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.colorpalette;

import java.util.ArrayList;
import java.util.Locale;
import java.util.Objects;
import java.util.stream.IntStream;
import journeymap.client.Constants;
import journeymap.client.JourneymapClient;
import journeymap.client.cartography.color.ColorManager;
import journeymap.client.cartography.color.ColorPalette;
import journeymap.client.model.BlockMD;
import journeymap.client.properties.CoreProperties;
import journeymap.client.ui.UIManager;
import journeymap.client.ui.colorpalette.ColorPaletteItem;
import journeymap.client.ui.colorpalette.DomainDropDownButton;
import journeymap.client.ui.colorpalette.PaletteDropDownButton;
import journeymap.client.ui.colorpalette.SortButton;
import journeymap.client.ui.component.ScrollListPane;
import journeymap.client.ui.component.SearchTextBox;
import journeymap.client.ui.component.buttons.Button;
import journeymap.client.ui.component.screens.JmUI;
import net.minecraft.client.gui.ComponentPath;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.layouts.LinearLayout;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;

public class ColorPaletteScreen
extends JmUI {
    private final Component labelClose = Component.translatable((String)"jm.common.close");
    private final Component labelManagePalettes = Component.translatable((String)"jm.colorpalette.manage_palettes");
    private final Component labelModsAndPlayers = Component.translatable((String)"jm.colorpalette.mobs_and_players");
    static final String ASCEND = "\u25b2";
    static final String DESCEND = "\u25bc";
    private static ColorPaletteItem.Sort currentSort;
    private static String searchString;
    protected ScrollListPane itemScrollPane;
    protected int rowHeight = 36;
    private SortButton buttonSortName;
    private SortButton buttonSortId;
    private DomainDropDownButton buttonDomains;
    private PaletteDropDownButton buttonPalettes;
    private SearchTextBox searchText;
    private ArrayList<ColorPaletteItem> items = new ArrayList();
    private boolean remapNeeded = false;

    public ColorPaletteScreen(Screen returnDisplay) {
        super(Constants.getString("jm.colorpalette.manage_colors_title"), true, returnDisplay);
    }

    @Override
    public void init() {
        super.init();
        LinearLayout leftHeaderButtons = LinearLayout.horizontal();
        leftHeaderButtons.spacing(4).defaultCellSetting();
        this.buttonDomains = (DomainDropDownButton)leftHeaderButtons.addChild((LayoutElement)new DomainDropDownButton(ColorManager.INSTANCE.getDefaultPalette(), b -> this.updateItems()));
        boolean hasGlobal = !ColorManager.INSTANCE.getGlobalPalette().isEmpty();
        boolean hasWorld = !ColorManager.INSTANCE.getWorldPalette().isEmpty();
        this.buttonPalettes = (PaletteDropDownButton)leftHeaderButtons.addChild((LayoutElement)new PaletteDropDownButton(hasGlobal, hasWorld, b -> this.updateItems()));
        this.buttonPalettes.setVisible(hasGlobal || hasWorld);
        this.topLeftHeader.addChild((LayoutElement)leftHeaderButtons);
        LinearLayout bottomHeaderButtons = LinearLayout.horizontal();
        bottomHeaderButtons.spacing(4).defaultCellSetting();
        ColorPaletteItem.NameComparator nameSort = new ColorPaletteItem.NameComparator(true);
        this.buttonSortName = (SortButton)bottomHeaderButtons.addChild((LayoutElement)new SortButton(Constants.getString("jm.colorpalette.name"), nameSort, this::sortButtonPressed));
        this.buttonSortName.setTextOnly(this.getFontRenderer());
        this.buttonSortName.drawUnderline(true);
        ColorPaletteItem.IdComparator idSort = new ColorPaletteItem.IdComparator(true);
        this.buttonSortId = (SortButton)bottomHeaderButtons.addChild((LayoutElement)new SortButton(Constants.getString("jm.colorpalette.id"), idSort, this::sortButtonPressed));
        this.buttonSortId.setTextOnly(this.getFontRenderer());
        this.buttonSortId.drawUnderline(true);
        this.bottomHeader.addChild((LayoutElement)bottomHeaderButtons);
        this.searchText = (SearchTextBox)this.topRightHeader.addChild((LayoutElement)new SearchTextBox(searchString, this.font, 100, 20, false, false));
        this.searchText.setResponder(t -> this.updateItems());
        this.searchText.setMinLength(0);
        this.footerLayout.addChild((LayoutElement)Button.builder((Component)this.labelModsAndPlayers, b -> UIManager.INSTANCE.openMobsAndPlayersColorEditor(this)).width(this.font.width((FormattedText)this.labelModsAndPlayers) + 10).build());
        this.footerLayout.addChild((LayoutElement)Button.builder((Component)this.labelManagePalettes, b -> UIManager.INSTANCE.openColorPaletteManager(this)).width(this.font.width((FormattedText)this.labelManagePalettes) + 10).build());
        this.footerLayout.addChild((LayoutElement)Button.builder((Component)this.labelClose, b -> this.refreshAndClose()).width(this.font.width((FormattedText)this.labelClose) + 10).build());
        Objects.requireNonNull(this);
        Objects.requireNonNull(this);
        Objects.requireNonNull(this);
        this.itemScrollPane = (ScrollListPane)this.contentLayout.addChild(new ScrollListPane(this.minecraft, 0, 36, this.width, this.height - 36 - 30, this.rowHeight));
        SortButton sortButton = this.getInitialSort();
        currentSort = sortButton.sort;
        this.updateSort(sortButton);
        this.repositionElements();
    }

    @Override
    protected void repositionElements() {
        this.updateItems();
        Objects.requireNonNull(this);
        Objects.requireNonNull(this);
        Objects.requireNonNull(this);
        this.itemScrollPane.updateSize(this.width, this.height - 36 - 30, 0, 36);
        this.itemScrollPane.setListWidth(this.panelWidth());
        this.itemScrollPane.setScrollAmount(this.itemScrollPane.getScrollAmount());
        super.repositionElements();
    }

    @Override
    public void render(GuiGraphics graphics, int x, int y, float partialTicks) {
        this.buttonSortName.setEnabled(!this.items.isEmpty());
        this.buttonSortId.setEnabled(!this.items.isEmpty());
        super.render(graphics, x, y, partialTicks);
    }

    @Override
    public void renderBackground(GuiGraphics graphics, int x, int y, float partialTicks) {
    }

    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        if (this.searchText.mouseOver(mouseX, mouseY)) {
            this.searchText.mouseClicked(mouseX, mouseY, mouseButton);
            super.setFocused((GuiEventListener)this.searchText);
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, mouseButton);
    }

    public boolean charTyped(char typedChar, int keyCode) {
        if (this.searchText.isHoveredOrFocused()) {
            return this.searchText.charTyped(typedChar, keyCode);
        }
        return super.charTyped(typedChar, keyCode);
    }

    public void changeFocus(ComponentPath path) {
        super.changeFocus(path);
    }

    public void copyBlock(String blockID, boolean globalToWorld) {
        ColorPalette worldPalette = ColorManager.INSTANCE.getWorldPalette();
        ColorPalette globalPalette = ColorManager.INSTANCE.getGlobalPalette();
        if (globalToWorld) {
            worldPalette.copyFromPalette(globalPalette, blockID);
        } else {
            globalPalette.copyFromPalette(worldPalette, blockID);
        }
        ColorPaletteItem selected = (ColorPaletteItem)this.itemScrollPane.getSelected();
        this.updateItems();
        if (selected != null) {
            this.selectItem(selected.blockID, selected.palette);
        }
        this.setRemapNeeded();
    }

    public void removeFromPalette(String blockID, ColorPalette.Type type) {
        ColorPalette palette = type == ColorPalette.Type.Global ? ColorManager.INSTANCE.getGlobalPalette() : ColorManager.INSTANCE.getWorldPalette();
        palette.remove(blockID);
        this.updateItems();
        this.selectItem(blockID, ColorManager.INSTANCE.getDefaultPalette());
        this.setRemapNeeded();
    }

    public void setRemapNeeded() {
        this.remapNeeded = true;
    }

    protected void selectItem(String blockID, ColorPalette palette) {
        if (this.items.isEmpty()) {
            return;
        }
        int index = IntStream.range(0, this.items.size()).filter(i -> blockID.equals(this.items.get((int)i).blockID) && palette == this.items.get((int)i).palette).findFirst().orElse(0);
        ColorPaletteItem toSelect = (ColorPaletteItem)this.itemScrollPane.getSlot(index);
        this.itemScrollPane.setFocused((GuiEventListener)toSelect);
        toSelect.focusEditButton();
    }

    protected void updateItems() {
        ColorPaletteItem item;
        if (this.searchText == null) {
            return;
        }
        boolean hasGlobal = !ColorManager.INSTANCE.getGlobalPalette().isEmpty();
        boolean hasWorld = !ColorManager.INSTANCE.getWorldPalette().isEmpty();
        this.buttonPalettes.setValidPalettes(hasGlobal, hasWorld);
        this.buttonPalettes.setVisible(hasGlobal || hasWorld);
        this.items.clear();
        String domain = DomainDropDownButton.currentDomain;
        searchString = this.searchText.getText();
        boolean all = PaletteDropDownButton.currentPalette.equals("all");
        ColorPalette defaultPalette = ColorManager.INSTANCE.getDefaultPalette();
        if (all) {
            for (String blockID : defaultPalette.getAllBlocks()) {
                if (!this.filterDomain(domain, blockID) || !this.filterSearch(searchString, blockID)) continue;
                ColorPaletteItem item2 = new ColorPaletteItem(defaultPalette, blockID, false, this.getFontRenderer(), this);
                this.items.add(item2);
            }
        }
        boolean global = PaletteDropDownButton.currentPalette.equals("global");
        boolean world = PaletteDropDownButton.currentPalette.equals("world");
        if (all || global) {
            ColorPalette globalPalette = ColorManager.INSTANCE.getGlobalPalette();
            for (String blockID : globalPalette.getAllBlocks()) {
                if (!this.filterDomain(domain, blockID) || !this.filterSearch(searchString, blockID) || !defaultPalette.hasBlockID(blockID)) continue;
                item = new ColorPaletteItem(globalPalette, blockID, all, this.getFontRenderer(), this);
                this.items.add(item);
            }
        }
        if (all || world) {
            ColorPalette worldPalette = ColorManager.INSTANCE.getWorldPalette();
            for (String blockID : worldPalette.getAllBlocks()) {
                if (!this.filterDomain(domain, blockID) || !this.filterSearch(searchString, blockID) || !defaultPalette.hasBlockID(blockID)) continue;
                item = new ColorPaletteItem(worldPalette, blockID, all, this.getFontRenderer(), this);
                this.items.add(item);
            }
        }
        this.items.sort(currentSort);
        this.itemScrollPane.setSlots(this.items);
        this.itemScrollPane.setScrollAmount(this.itemScrollPane.getScrollAmount());
    }

    private int panelWidth() {
        return (int)Math.min((double)this.width, 960.0 * ColorPaletteScreen.calculateScaleFactor());
    }

    private boolean filterDomain(String domain, String blockID) {
        return domain == null || domain.isEmpty() || ResourceLocation.parse((String)blockID).getNamespace().equals(domain);
    }

    private boolean filterSearch(String search, String blockID) {
        if (search == null || search.isEmpty()) {
            return true;
        }
        search = search.toLowerCase(Locale.ROOT);
        String blockName = BlockMD.getBlockName((Block)BuiltInRegistries.BLOCK.get(ResourceLocation.parse((String)blockID))).toLowerCase(Locale.ROOT);
        return blockID.toLowerCase(Locale.ROOT).contains(search) || blockName.contains(search);
    }

    private void sortButtonPressed(net.minecraft.client.gui.components.Button button) {
        SortButton sortButton = (SortButton)button;
        sortButton.toggle();
        if (!sortButton.sort.equals(currentSort) && sortButton.sort.ascending != ColorPaletteScreen.currentSort.ascending) {
            sortButton.toggle();
        }
        this.updateSort(sortButton);
        this.items.sort(currentSort);
        this.itemScrollPane.setSlots(this.items);
    }

    private void updateSort(SortButton sortButton) {
        for (Renderable button : this.getRenderables()) {
            if (!(button instanceof SortButton)) continue;
            if (button == sortButton) {
                if (!sortButton.sort.equals(currentSort)) {
                    sortButton.setActive(true);
                }
                this.updateSortProperty(sortButton);
                currentSort = sortButton.sort;
                continue;
            }
            ((SortButton)button).setActive(false);
        }
    }

    protected void refreshAndClose() {
        this.closeAndReturn();
    }

    @Override
    protected void closeAndReturn() {
        if (this.remapNeeded) {
            ColorManager.INSTANCE.applyColors();
            ColorManager.INSTANCE.savePalettes();
        }
        if (returnDisplayStack == null || returnDisplayStack.peek() == null) {
            UIManager.INSTANCE.closeAll();
        } else {
            UIManager.INSTANCE.open((Screen)returnDisplayStack.pop());
        }
    }

    private SortButton getInitialSort() {
        CoreProperties prop = JourneymapClient.getInstance().getCoreProperties();
        boolean ascending = prop.sortAscending.get();
        SortButton button = switch ((ColorPaletteItem.SortType)((Object)prop.initialSortOrder.get())) {
            default -> throw new MatchException(null, null);
            case ColorPaletteItem.SortType.Id -> this.buttonSortId;
            case ColorPaletteItem.SortType.Name -> this.buttonSortName;
        };
        button.sort.ascending = ascending;
        button.setToggled(ascending);
        return button;
    }

    private void updateSortProperty(SortButton sortButton) {
        CoreProperties prop = JourneymapClient.getInstance().getCoreProperties();
        if (sortButton == this.buttonSortName) {
            prop.initialSortOrder.set(ColorPaletteItem.SortType.Name);
        } else {
            prop.initialSortOrder.set(ColorPaletteItem.SortType.Id);
        }
        prop.sortAscending.set(sortButton.sort.ascending);
    }

    static {
        searchString = "";
    }
}

