/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.colorpalette;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import journeymap.client.Constants;
import journeymap.client.cartography.color.BlockStateColor;
import journeymap.client.cartography.color.ColorManager;
import journeymap.client.cartography.color.ColorPalette;
import journeymap.client.cartography.color.RGB;
import journeymap.client.model.BlockFlag;
import journeymap.client.model.BlockMD;
import journeymap.client.render.draw.DrawUtil;
import journeymap.client.ui.UIManager;
import journeymap.client.ui.colorpalette.ColorPaletteScreen;
import journeymap.client.ui.component.MultiSelectableScrollListPane;
import journeymap.client.ui.component.Slot;
import journeymap.client.ui.component.buttons.Button;
import journeymap.client.ui.component.popupscreenbutton.blockflags.BlockFlagsButton;
import journeymap.client.ui.component.popupscreenbutton.blockflags.BlockFlagsScreen;
import journeymap.client.ui.component.popupscreenbutton.colorpicker.ColorPickerButton;
import journeymap.client.ui.component.popupscreenbutton.colorpicker.ColorPickerScreen;
import journeymap.client.ui.component.screens.JmUI;
import journeymap.client.ui.option.SlotMetadata;
import journeymap.common.Journeymap;
import journeymap.common.log.LogFormatter;
import net.minecraft.Util;
import net.minecraft.client.gui.ComponentPath;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.ContainerEventHandler;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.layouts.LinearLayout;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;

public class ColorPaletteItemEditor
extends JmUI {
    private final String labelSelectAll = Constants.getString("jm.colorpalette.select_all");
    private final String labelSelectSameColor = Constants.getString("jm.colorpalette.select_same_color");
    private final String labelSaveToGlobal = Constants.getString("jm.colorpalette.save_to_global");
    private final String labelSaveToWorld = Constants.getString("jm.colorpalette.save_to_world");
    private final Component labelClose = Component.translatable((String)"jm.common.close");
    private Button buttonSaveToGlobal;
    private Button buttonSaveToWorld;
    private Button buttonSelectAll;
    private Button buttonSelectSameColor;
    private final String blockId;
    private final Map<String, BlockStateColor> originalColors;
    private MultiSelectableScrollListPane<ColorStateItem> statesScrollPane;
    private final boolean saveToGlobal;
    private final boolean saveToWorld;

    public ColorPaletteItemEditor(String blockID, Map<String, BlockStateColor> blockStatesToColor, boolean saveToGlobal, boolean saveToWorld, Screen returnDisplay) {
        super(Constants.getString("jm.colorpalette.edit_title") + " (" + BlockMD.getBlockName((Block)BuiltInRegistries.BLOCK.get(ResourceLocation.parse((String)blockID))) + ")", true, returnDisplay);
        this.blockId = blockID;
        this.originalColors = blockStatesToColor;
        this.saveToGlobal = saveToGlobal;
        this.saveToWorld = saveToWorld;
    }

    @Override
    public void init() {
        super.init();
        boolean isVanilla = this.blockId.startsWith("minecraft:");
        ArrayList<ColorStateItem> statesItemList = new ArrayList<ColorStateItem>();
        for (Map.Entry<String, BlockStateColor> state : this.originalColors.entrySet()) {
            statesItemList.add(new ColorStateItem(this.font, this.blockId, state.getKey(), state.getValue(), isVanilla, this));
        }
        Objects.requireNonNull(this);
        Objects.requireNonNull(this);
        Objects.requireNonNull(this);
        this.statesScrollPane = (MultiSelectableScrollListPane)this.contentLayout.addChild(new MultiSelectableScrollListPane(this.minecraft, 0, 36, this.width, this.height - 36 - 30, 30));
        this.statesScrollPane.setSlots(statesItemList);
        LinearLayout headerButtons = LinearLayout.horizontal();
        headerButtons.spacing(4).defaultCellSetting();
        this.buttonSelectAll = (Button)headerButtons.addChild((LayoutElement)new Button(this.labelSelectAll, b -> this.statesScrollPane.selectAll()));
        this.buttonSelectAll.setTextOnly(this.getFontRenderer());
        this.buttonSelectAll.drawUnderline(true);
        this.buttonSelectAll.setEnabled(this.statesScrollPane.getRootSlots().size() > 1);
        this.buttonSelectSameColor = (Button)headerButtons.addChild((LayoutElement)new Button(this.labelSelectSameColor, b -> {
            ColorStateItem selected = (ColorStateItem)this.statesScrollPane.getSelected();
            if (selected != null) {
                for (ColorStateItem item : this.statesScrollPane.getRootSlots()) {
                    if (item.color != selected.color) continue;
                    this.statesScrollPane.setSelectedAndKeepCurrent(item);
                }
            }
        }));
        this.buttonSelectSameColor.setTextOnly(this.getFontRenderer());
        this.buttonSelectSameColor.drawUnderline(true);
        this.buttonSelectSameColor.setEnabled(this.statesScrollPane.getRootSlots().size() > 1);
        this.bottomHeader.addChild((LayoutElement)headerButtons);
        if (this.saveToGlobal) {
            this.buttonSaveToGlobal = (Button)this.footerLayout.addChild((LayoutElement)new Button(this.labelSaveToGlobal, b -> this.save(ColorPalette.Type.Global)));
            this.buttonSaveToGlobal.setWidth(this.font.width(this.labelSaveToGlobal) + 10);
        }
        if (this.saveToWorld) {
            this.buttonSaveToWorld = (Button)this.footerLayout.addChild((LayoutElement)new Button(this.labelSaveToWorld, b -> this.save(ColorPalette.Type.World)));
            this.buttonSaveToWorld.setWidth(this.font.width(this.labelSaveToWorld) + 10);
        }
        this.footerLayout.addChild((LayoutElement)Button.builder((Component)this.labelClose, b -> this.refreshAndClose()).width(this.font.width((FormattedText)this.labelClose) + 10).build());
        this.validate();
    }

    @Override
    protected void repositionElements() {
        Objects.requireNonNull(this);
        Objects.requireNonNull(this);
        Objects.requireNonNull(this);
        this.statesScrollPane.updateSize(this.width, this.height - 36 - 30, 0, 36);
        this.statesScrollPane.setListWidth(this.panelWidth());
        this.statesScrollPane.setScrollAmount(this.statesScrollPane.getScrollAmount());
        super.repositionElements();
    }

    @Override
    public void render(GuiGraphics graphics, int x, int y, float partialTicks) {
        try {
            this.buttonSelectSameColor.setEnabled(this.statesScrollPane.getRootSlots().size() > 1 && this.statesScrollPane.getSelectedCount() == 1);
            super.render(graphics, x, y, partialTicks);
        }
        catch (Throwable t) {
            Journeymap.getLogger().error("Error during ColorPaletteItemEditor render: {}", (Object)LogFormatter.toPartialString(t));
            UIManager.INSTANCE.closeAll();
        }
    }

    private int panelWidth() {
        return (int)Math.min((double)this.width, 960.0 * ColorPaletteItemEditor.calculateScaleFactor());
    }

    protected boolean validate() {
        boolean valid = false;
        for (ColorStateItem state : this.statesScrollPane.getRootSlots()) {
            if (!state.isEdited()) continue;
            valid = true;
            break;
        }
        if (this.buttonSaveToGlobal != null) {
            this.buttonSaveToGlobal.setEnabled(valid);
        }
        if (this.buttonSaveToWorld != null) {
            this.buttonSaveToWorld.setEnabled(valid);
        }
        return valid;
    }

    protected void save(ColorPalette.Type type) {
        if (!this.validate()) {
            return;
        }
        ColorPalette palette = type == ColorPalette.Type.Global ? ColorManager.INSTANCE.getGlobalPalette() : ColorManager.INSTANCE.getWorldPalette();
        for (ColorStateItem state : this.statesScrollPane.getRootSlots()) {
            int color = state.color & 0xFFFFFF;
            float alpha = (float)(state.color >> 24 & 0xFF) / 255.0f;
            palette.setBlockStateColor(this.blockId, state.state, color, alpha, (EnumSet<BlockFlag>)state.flags.clone());
        }
        this.refreshAndClose();
    }

    private void popupButtonPressed(ColorStateItem item) {
        if (!this.statesScrollPane.isSelectedItem(item)) {
            this.statesScrollPane.setSelected(item);
        }
    }

    private void selectOnly(ColorStateItem item) {
        this.statesScrollPane.setSelected((Slot)null);
        this.statesScrollPane.setSelected(item);
    }

    private void editFlagsOfSelected(EnumSet<BlockFlag> flags) {
        for (Slot slot : this.statesScrollPane.getAllSelected()) {
            ColorStateItem state = (ColorStateItem)slot;
            state.setFlags(flags);
        }
        this.validate();
    }

    private void editColorsOfSelected(int color) {
        for (Slot slot : this.statesScrollPane.getAllSelected()) {
            ColorStateItem state = (ColorStateItem)slot;
            state.setColor(color);
        }
        this.validate();
    }

    protected void refreshAndClose() {
        Object object;
        if (returnDisplayStack != null && returnDisplayStack.peek() != null && (object = returnDisplayStack.peek()) instanceof ColorPaletteScreen) {
            ColorPaletteScreen colorPaletteScreen = (ColorPaletteScreen)((Object)object);
            for (ColorStateItem item : this.statesScrollPane.getRootSlots()) {
                if (!item.isEdited()) continue;
                colorPaletteScreen.setRemapNeeded();
                break;
            }
        }
        this.closeAndReturn();
    }

    static class ColorStateItem
    extends Slot {
        private final Font fontRenderer;
        private final String blockId;
        private final String state;
        private EnumSet<BlockFlag> flags;
        private String flagsString;
        private int color;
        private final EnumSet<BlockFlag> originalFlags;
        private final int originalColor;
        private final ColorPaletteItemEditor editor;
        private final Button buttonDefault;
        private final Button buttonUndo;
        private BlockFlagsButton buttonBlockFlags;
        private ColorPickerButton buttonColorPicker;
        private final List<GuiEventListener> children = new ArrayList<GuiEventListener>();
        private long lastClick = 0L;

        ColorStateItem(Font fontRenderer, String blockId, String state, BlockStateColor blockState, boolean isVanilla, ColorPaletteItemEditor editor) {
            this.fontRenderer = fontRenderer;
            this.blockId = blockId;
            this.state = state;
            this.originalFlags = blockState.flags == null ? EnumSet.noneOf(BlockFlag.class) : blockState.flags;
            this.originalColor = RGB.hexToInt(blockState.color) & 0xFFFFFF | (int)(blockState.alpha.floatValue() * 255.0f) << 24;
            this.flags = this.originalFlags.clone();
            this.flagsString = this.flags.toString();
            this.color = this.originalColor;
            this.editor = editor;
            this.buttonDefault = new Button(Constants.getString("jm.colorpalette.default"), b -> this.resetItemToDefault());
            this.buttonDefault.fitWidth(fontRenderer);
            this.buttonUndo = new Button(Constants.getString("jm.colorpalette.undo"), b -> this.undoItem());
            this.buttonUndo.fitWidth(fontRenderer);
            if (!isVanilla) {
                this.buttonBlockFlags = new BlockFlagsButton(24, 24, () -> this.flags, this::flagsChanged);
            }
            this.buttonColorPicker = new ColorPickerButton(24, 24, () -> this.color, () -> this.flags.contains((Object)BlockFlag.Transparency), this::colorPicked);
            this.children.add((GuiEventListener)this.buttonColorPicker);
            this.children.add((GuiEventListener)this.buttonUndo);
            this.children.add((GuiEventListener)this.buttonDefault);
            if (!isVanilla) {
                this.children.add((GuiEventListener)this.buttonBlockFlags);
            }
        }

        private void flagsChanged(BlockFlagsScreen.BlockFlagsResponse response) {
            if (response.canceled()) {
                return;
            }
            this.editor.editFlagsOfSelected(response.flags());
        }

        private void colorPicked(ColorPickerScreen.ColorPickerResponse response) {
            if (response.canceled()) {
                return;
            }
            this.editor.editColorsOfSelected(response.color());
        }

        public void setFlags(EnumSet<BlockFlag> flags) {
            this.flags = flags.clone();
            this.flagsString = flags.toString();
        }

        public void setColor(int color) {
            this.color = color;
        }

        public void resetItemToDefault() {
            ColorPalette defaultPalette = ColorManager.INSTANCE.getDefaultPalette();
            BlockStateColor defaultBSC = defaultPalette.getBlockStateColor(this.blockId, this.state);
            EnumSet<BlockFlag> flags = defaultBSC.flags == null ? EnumSet.noneOf(BlockFlag.class) : defaultBSC.flags;
            int color = RGB.hexToInt(defaultBSC.color) & 0xFFFFFF | (int)(defaultBSC.alpha.floatValue() * 255.0f) << 24;
            this.setColor(color);
            this.setFlags(flags);
            this.editor.validate();
        }

        public void undoItem() {
            this.setColor(this.originalColor);
            this.setFlags(this.originalFlags);
            this.editor.validate();
        }

        public boolean isEdited() {
            return this.color != this.originalColor || !this.flags.equals(this.originalFlags);
        }

        @Override
        public Collection<SlotMetadata> getMetadata() {
            return null;
        }

        public boolean mouseClicked(double mouseX, double mouseY, int mouseEvent) {
            try {
                if (this.buttonDefault.mouseClicked(mouseX, mouseY, mouseEvent)) {
                    return true;
                }
                if (this.buttonUndo.mouseClicked(mouseX, mouseY, mouseEvent)) {
                    return true;
                }
                if (this.buttonBlockFlags != null && this.buttonBlockFlags.mouseClicked(mouseX, mouseY, mouseEvent)) {
                    this.editor.popupButtonPressed(this);
                    return false;
                }
                if (this.buttonColorPicker.mouseClicked(mouseX, mouseY, mouseEvent)) {
                    this.editor.popupButtonPressed(this);
                    this.editor.changeFocus(ComponentPath.path((ContainerEventHandler)this, (ComponentPath)ComponentPath.leaf((GuiEventListener)this.buttonColorPicker)));
                    return false;
                }
                if (mouseEvent == 0) {
                    long sysTime = Util.getMillis();
                    boolean doubleClick = sysTime - this.lastClick < 200L;
                    this.lastClick = sysTime;
                    if (doubleClick) {
                        this.buttonColorPicker.onPress();
                        this.editor.selectOnly(this);
                        return false;
                    }
                }
                this.editor.changeFocus(ComponentPath.path((ContainerEventHandler)this, (ComponentPath)ComponentPath.leaf((GuiEventListener)this.buttonColorPicker)));
                return true;
            }
            catch (Exception e) {
                Journeymap.getLogger().error("WARNING: Problem with mouseClicked.");
                throw new RuntimeException("mouseClicked", e);
            }
        }

        @Override
        public List<? extends Slot> getChildSlots(int listWidth, int columnWidth) {
            return null;
        }

        @Override
        public SlotMetadata getLastPressed() {
            return null;
        }

        @Override
        public SlotMetadata getCurrentTooltip() {
            return null;
        }

        @Override
        public void setEnabled(boolean enabled) {
        }

        @Override
        public int getColumnWidth() {
            return 0;
        }

        @Override
        public boolean contains(SlotMetadata slotMetadata) {
            return false;
        }

        public void render(GuiGraphics graphics, int slotIndex, int y, int x, int rowWidth, int itemHeight, int mouseX, int mouseY, boolean isMouseOver, float partialTicks) {
            DrawUtil.drawRectangle(graphics, x, y, rowWidth - 4, itemHeight, this.color, 1.0f);
            Objects.requireNonNull(this.fontRenderer);
            graphics.drawString(this.fontRenderer, this.state, x + 5, y + (itemHeight - 9) / 2 - 3, -1, true);
            if (!this.flags.isEmpty()) {
                Objects.requireNonNull(this.fontRenderer);
                graphics.drawString(this.fontRenderer, this.flagsString, x + 5, y + (itemHeight + 9) / 2 - 2, 0xC0C0C0, true);
            }
            this.buttonDefault.leftOf(x + rowWidth - 57);
            this.buttonDefault.below(y + 3);
            this.buttonDefault.render(graphics, mouseX, mouseY, partialTicks);
            this.buttonUndo.setVisible(this.isEdited());
            this.buttonUndo.leftOf(x + rowWidth - 59 - this.buttonDefault.getWidth());
            this.buttonUndo.below(y + 3);
            this.buttonUndo.render(graphics, mouseX, mouseY, partialTicks);
            if (isMouseOver || this.isFocused()) {
                if (this.buttonBlockFlags != null) {
                    this.buttonBlockFlags.leftOf(x + rowWidth - 30);
                    this.buttonBlockFlags.below(y + 1);
                    this.buttonBlockFlags.render(graphics, mouseX, mouseY, partialTicks);
                }
                this.buttonColorPicker.leftOf(x + rowWidth - 5);
                this.buttonColorPicker.below(y + 1);
                this.buttonColorPicker.render(graphics, mouseX, mouseY, partialTicks);
            }
        }

        @Override
        public List<? extends GuiEventListener> children() {
            return this.children;
        }
    }
}

