/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.colorpalette;

import java.awt.Color;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import journeymap.api.v2.client.option.KeyedEnum;
import journeymap.client.Constants;
import journeymap.client.cartography.color.BlockStateColor;
import journeymap.client.cartography.color.ColorPalette;
import journeymap.client.model.BlockMD;
import journeymap.client.render.draw.DrawUtil;
import journeymap.client.ui.UIManager;
import journeymap.client.ui.colorpalette.ColorPaletteScreen;
import journeymap.client.ui.component.ButtonList;
import journeymap.client.ui.component.Slot;
import journeymap.client.ui.component.buttons.Button;
import journeymap.client.ui.option.SlotMetadata;
import journeymap.common.Journeymap;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ComponentPath;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.ContainerEventHandler;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;

public class ColorPaletteItem
extends Slot {
    private final Font fontRenderer;
    private final ColorPaletteScreen screen;
    public int x;
    public int y;
    private int width;
    public ColorPalette palette;
    private String blockName;
    public String blockID;
    private Map<String, BlockStateColor> blockStatesToColor;
    private boolean underDefault;
    private Button buttonEdit;
    private Button buttonCopy;
    private Button buttonDelete;
    private int hgap = 4;
    private final ButtonList buttonList;
    private long lastClick = 0L;
    private boolean displayHover = true;

    public ColorPaletteItem(ColorPalette palette, String blockID, boolean underDefault, Font fontRenderer, ColorPaletteScreen screen) {
        this.palette = palette;
        this.blockName = BlockMD.getBlockName((Block)BuiltInRegistries.BLOCK.get(ResourceLocation.parse((String)blockID)));
        this.blockID = blockID;
        this.blockStatesToColor = palette.getAllStates(blockID);
        this.underDefault = underDefault;
        this.fontRenderer = fontRenderer;
        this.screen = screen;
        this.buttonEdit = new Button(Constants.getString("jm.waypoint.edit"), b -> this.openColorPaletteItemEditor());
        this.buttonList = new ButtonList(this.buttonEdit);
        if (palette.getType() != ColorPalette.Type.Default) {
            String copyLabel = Constants.getString(palette.getType() == ColorPalette.Type.Global ? "jm.colorpalette.copy_to_world" : "jm.colorpalette.copy_to_global");
            this.buttonCopy = new Button(copyLabel, b -> this.copyBlock());
            this.buttonList.add(this.buttonCopy);
            this.buttonDelete = new Button(Constants.getString("jm.colorpalette.delete"), b -> this.removeFromPalette());
            this.buttonList.add(this.buttonDelete);
        }
        this.buttonList.setHeights(screen.rowHeight / 2);
        this.buttonList.fitWidths(fontRenderer);
        this.buttonList.setDefaultStyle(true);
    }

    private void copyBlock() {
        this.screen.copyBlock(this.blockID, this.palette.getType() == ColorPalette.Type.Global);
    }

    private void removeFromPalette() {
        this.screen.removeFromPalette(this.blockID, this.palette.getType());
    }

    private void openColorPaletteItemEditor() {
        boolean saveToGlobal = this.palette.getType() == ColorPalette.Type.Default || this.palette.getType() == ColorPalette.Type.Global;
        boolean saveToWorld = this.palette.getType() == ColorPalette.Type.Default || this.palette.getType() == ColorPalette.Type.World;
        UIManager.INSTANCE.openColorPaletteItemEditor(this.blockID, this.blockStatesToColor, saveToGlobal, saveToWorld, this.screen);
    }

    protected void drawLabels(GuiGraphics graphics, Minecraft mc, int x, int y) {
        int height = this.screen.rowHeight - 4;
        if (this.underDefault) {
            int n = height / 2;
            Objects.requireNonNull(this.fontRenderer);
            int yOffset = n - 9 / 2;
            String label = this.palette.getType() == ColorPalette.Type.Global ? "jm.colorpalette.global" : "jm.colorpalette.world";
            graphics.drawString(this.fontRenderer, Constants.getString(label), x + 28, y + yOffset, -1862270977, true);
        } else {
            int n = height / 3;
            Objects.requireNonNull(this.fontRenderer);
            int yOffset = n - 9 / 2;
            graphics.drawString(this.fontRenderer, this.blockName, x + 20, y + yOffset, -1, true);
            int n2 = height / 3 * 2;
            Objects.requireNonNull(this.fontRenderer);
            yOffset = n2 - 9 / 2;
            graphics.drawString(this.fontRenderer, this.blockID, x + 20, y + yOffset, -1862270977, true);
        }
    }

    @Override
    public Collection<SlotMetadata> getMetadata() {
        return null;
    }

    public void render(GuiGraphics graphics, int slotIndex, int y, int x, int rowWidth, int itemHeight, int mouseX, int mouseY, boolean isMouseOver, float partialTicks) {
        Minecraft mc = this.screen.getMinecraft();
        this.width = rowWidth;
        this.x = x;
        this.y = y;
        int counter = 0;
        int xPadding = 8;
        double stateWidth = (double)(this.width - xPadding) / (double)this.blockStatesToColor.size();
        for (BlockStateColor blockStateColor : this.blockStatesToColor.values()) {
            int color = Color.decode(blockStateColor.color).getRGB();
            DrawUtil.drawRectangle(graphics, (double)(this.x + xPadding) + stateWidth * (double)counter, this.y, stateWidth, this.screen.rowHeight - 4, color, 1.0f);
            ++counter;
        }
        if (this.underDefault) {
            int halfRowHeight = this.screen.rowHeight / 2;
            DrawUtil.drawRectangle(graphics, this.x - 2, this.y - this.screen.rowHeight, 1.0, halfRowHeight * 3, -10461088, 1.0f);
            DrawUtil.drawRectangle(graphics, this.x - 2, this.y + halfRowHeight, xPadding + 2, 1.0, -10461088, 1.0f);
        } else {
            int color = Color.decode(this.blockStatesToColor.values().iterator().next().color).getRGB();
            DrawUtil.drawRectangle(graphics, this.x, this.y, xPadding, this.screen.rowHeight - 4, color, 1.0f);
        }
        this.drawLabels(graphics, mc, this.x, this.y);
        boolean drawHovered = isMouseOver && this.displayHover || this.isFocused();
        this.buttonList.setOptions(true, drawHovered, true);
        this.buttonEdit.drawHovered(drawHovered);
        if (this.buttonCopy != null) {
            this.buttonCopy.drawHovered(drawHovered);
        }
        if (this.buttonDelete != null) {
            this.buttonDelete.drawHovered(drawHovered);
        }
        if (drawHovered) {
            int margin = (itemHeight - this.buttonList.getHeight()) / 2;
            this.buttonList.layoutHorizontal(this.x + this.width - margin, this.y + margin, false, this.hgap).draw(graphics, mouseX, mouseY);
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int mouseEvent) {
        try {
            if (this.buttonEdit.mouseClicked(mouseX, mouseY, mouseEvent)) {
                return true;
            }
            if (this.buttonCopy != null && this.buttonCopy.mouseClicked(mouseX, mouseY, mouseEvent)) {
                return true;
            }
            if (this.buttonDelete != null && this.buttonDelete.mouseClicked(mouseX, mouseY, mouseEvent)) {
                return true;
            }
            if (mouseEvent == 0) {
                long sysTime = Util.getMillis();
                boolean doubleClick = sysTime - this.lastClick < 200L;
                this.lastClick = sysTime;
                if (doubleClick) {
                    this.openColorPaletteItemEditor();
                    return true;
                }
            }
            this.focusEditButton();
            return true;
        }
        catch (Exception e) {
            Journeymap.getLogger().error("WARNING: Problem with mouseClicked.");
            throw new RuntimeException("mouseClicked", e);
        }
    }

    public void focusEditButton() {
        this.screen.changeFocus(ComponentPath.path((ContainerEventHandler)this.screen, (ComponentPath)ComponentPath.path((ContainerEventHandler)this.screen.itemScrollPane, (ComponentPath)ComponentPath.path((ContainerEventHandler)this, (ComponentPath)ComponentPath.leaf((GuiEventListener)this.buttonEdit)))));
    }

    public List<Slot> getChildSlots(int listWidth, int columnWidth) {
        return null;
    }

    @Override
    public SlotMetadata getLastPressed() {
        return null;
    }

    @Override
    public SlotMetadata getCurrentTooltip() {
        return null;
    }

    @Override
    public void setEnabled(boolean enabled) {
    }

    @Override
    public int getColumnWidth() {
        return this.width;
    }

    @Override
    public boolean contains(SlotMetadata slotMetadata) {
        return false;
    }

    @Override
    public void displayHover(boolean enabled) {
        this.displayHover = enabled;
    }

    @Override
    public List<? extends GuiEventListener> children() {
        return this.buttonList;
    }

    public static enum SortType implements KeyedEnum
    {
        Id("jm.colorpalette.id"),
        Name("jm.colorpalette.name");

        final String key;

        private SortType(String key) {
            this.key = key;
        }

        public String getKey() {
            return this.key;
        }
    }

    static class IdComparator
    extends Sort {
        public IdComparator(boolean ascending) {
            super(ascending);
        }

        @Override
        public int compare(ColorPaletteItem o1, ColorPaletteItem o2) {
            int c = this.ascending ? o1.blockID.compareToIgnoreCase(o2.blockID) : o2.blockID.compareToIgnoreCase(o1.blockID);
            if (c == 0) {
                c = o1.palette.getType().compareTo(o2.palette.getType());
            }
            return c;
        }
    }

    static class NameComparator
    extends Sort {
        public NameComparator(boolean ascending) {
            super(ascending);
        }

        @Override
        public int compare(ColorPaletteItem o1, ColorPaletteItem o2) {
            int c = this.ascending ? o1.blockName.compareToIgnoreCase(o2.blockName) : o2.blockName.compareToIgnoreCase(o1.blockName);
            if (c == 0) {
                c = o1.palette.getType().compareTo(o2.palette.getType());
            }
            return c;
        }
    }

    static abstract class Sort
    implements Comparator<ColorPaletteItem> {
        boolean ascending;

        Sort(boolean ascending) {
            this.ascending = ascending;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            return o != null && this.getClass() == o.getClass();
        }

        public int hashCode() {
            return this.ascending ? 1 : 0;
        }
    }
}

