/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.texture;

import com.mojang.authlib.GameProfile;
import com.mojang.blaze3d.platform.NativeImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import journeymap.client.io.FileHandler;
import journeymap.client.io.IconSetFileHandler;
import journeymap.client.io.ThemeLoader;
import journeymap.client.task.main.ExpireTextureTask;
import journeymap.client.texture.DynamicTextureImpl;
import journeymap.client.texture.IgnSkin;
import journeymap.client.texture.ImageUtil;
import journeymap.client.texture.SimpleTextureImpl;
import journeymap.client.texture.Texture;
import journeymap.client.ui.theme.Theme;
import journeymap.client.waypoint.ClientWaypointImpl;
import journeymap.common.Journeymap;
import journeymap.common.thread.JMThreadFactory;
import journeymap.common.waypoint.WaypointStore;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.SimpleTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;

public class TextureCache {
    public static final ResourceLocation TOGGLE_ON = TextureCache.uiImage("toggle-button-on.png");
    public static final ResourceLocation TOGGLE_OFF = TextureCache.uiImage("toggle-button-off.png");
    public static final ResourceLocation GridSquares = TextureCache.uiImage("grid.png");
    public static final ResourceLocation GridRegionSquares = TextureCache.uiImage("grid-region.png");
    public static final ResourceLocation GridRegion = TextureCache.uiImage("region.png");
    public static final ResourceLocation ColorPicker = TextureCache.uiImage("colorpick.png");
    public static final ResourceLocation ColorPicker2 = TextureCache.uiImage("colorpick2.png");
    public static final ResourceLocation TileSampleDay = TextureCache.uiImage("tile-sample-day.png");
    public static final ResourceLocation TileSampleNight = TextureCache.uiImage("tile-sample-night.png");
    public static final ResourceLocation TileSampleUnderground = TextureCache.uiImage("tile-sample-underground.png");
    public static final ResourceLocation UnknownEntity = TextureCache.uiImage("unknown.png");
    public static final ResourceLocation Deathpoint = TextureCache.uiImage("waypoint-death-icon.png");
    public static final ResourceLocation MobDot = TextureCache.uiImage("marker-dot-160.png");
    public static final ResourceLocation MobDotArrow = TextureCache.uiImage("marker-dot-arrow-160.png");
    public static final ResourceLocation MobDotChevron = TextureCache.uiImage("marker-chevron-160.png");
    public static final ResourceLocation MobIconArrow = TextureCache.uiImage("marker-icon-arrow-160.png");
    public static final ResourceLocation MobIconArrowBG = TextureCache.uiImage("marker-icon-arrow-bg-160.png");
    public static final ResourceLocation MobIcon = TextureCache.uiImage("marker-icon-160.png");
    public static final ResourceLocation MobIconBG = TextureCache.uiImage("marker-icon-bg-160.png");
    public static final ResourceLocation MobIconMask = TextureCache.uiImage("marker-icon-mask.png");
    public static final ResourceLocation PlayerArrow = TextureCache.uiImage("marker-player-160.png");
    public static final ResourceLocation PlayerArrowBG = TextureCache.uiImage("marker-player-bg-160.png");
    public static final ResourceLocation PlayerOutline = TextureCache.uiImage("marker-player-outline.png");
    public static final ResourceLocation Logo = TextureCache.uiImage("ico/journeymap.png");
    public static final ResourceLocation MinimapSquare128 = TextureCache.uiImage("minimap/minimap-square-128.png");
    public static final ResourceLocation MinimapSquare256 = TextureCache.uiImage("minimap/minimap-square-256.png");
    public static final ResourceLocation MinimapSquare512 = TextureCache.uiImage("minimap/minimap-square-512.png");
    public static final ResourceLocation Discord = TextureCache.uiImage("discord.png");
    public static final ResourceLocation CurseForge = TextureCache.uiImage("curseforge.png");
    public static final ResourceLocation Modrinth = TextureCache.uiImage("modrinth.png");
    public static final ResourceLocation ColorWheel = TextureCache.uiImage("colorwheel.png");
    public static final ResourceLocation ColorWheelHandler = TextureCache.uiImage("colorwheel-handler.png");
    public static final ResourceLocation ColorBox = TextureCache.uiImage("color-box.png");
    public static final ResourceLocation ColorVSlider = TextureCache.uiImage("color-v-slider.png");
    public static final ResourceLocation ColorVSliderHandler = TextureCache.uiImage("color-v-slider-handler.png");
    public static final ResourceLocation ColorHistoryButton = TextureCache.uiImage("color-history-button.png");
    public static final ResourceLocation Flag = TextureCache.uiImage("flag.png");
    public static final ResourceLocation Waypoint = TextureCache.uiImage("waypoint-icon.png");
    public static final ResourceLocation WaypointEdit = TextureCache.uiImage("waypoint-edit.png");
    public static final ResourceLocation WaypointOffscreen = TextureCache.uiImage("waypoint-offscreen.png");
    private static final Map<String, ResourceLocation> dynamicTextureMap = Collections.synchronizedMap(new HashMap());
    public static final Map<String, Texture> colorizedWPIconMap = Collections.synchronizedMap(new HashMap());
    public static final Map<ResourceLocation, ResourceLocation> modTextureMap = Collections.synchronizedMap(new HashMap());
    public static final Map<String, Texture> playerSkins = Collections.synchronizedMap(new HashMap());
    public static final Map<String, Texture> themeImages = Collections.synchronizedMap(new HashMap());
    private static ThreadPoolExecutor texExec = new ThreadPoolExecutor(2, 4, 15L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(8), new JMThreadFactory("texture"), new ThreadPoolExecutor.CallerRunsPolicy());
    public static final Map<String, ResourceLocation> waypointIconCache = Collections.synchronizedMap(new HashMap<String, ResourceLocation>(){
        {
            this.put(Waypoint.toString(), Waypoint);
            this.put(Deathpoint.toString(), Deathpoint);
        }
    });

    public static ResourceLocation getTexture(String texturePath) {
        ResourceLocation tex = dynamicTextureMap.get(texturePath);
        if (tex == null) {
            tex = TextureCache.uiImage(texturePath);
            dynamicTextureMap.put(texturePath, tex);
        }
        return tex;
    }

    public static ResourceLocation uiImage(String fileName) {
        return ResourceLocation.fromNamespaceAndPath((String)"journeymap", (String)("ui/img/" + fileName));
    }

    public static Texture getTexture(ResourceLocation location) {
        if (location == null) {
            return null;
        }
        TextureManager textureManager = Minecraft.getInstance().getTextureManager();
        Object textureObject = textureManager.getTexture(location, null);
        if (TextureCache.needsNewTexture(textureObject)) {
            textureObject = new SimpleTextureImpl(location);
            textureManager.register(location, textureObject);
        }
        try {
            Texture tex = (Texture)textureObject;
            return tex;
        }
        catch (Exception e) {
            Journeymap.getLogger().error("Not a proper texture for Journeymap:{}", (Object)location);
            return (Texture)textureObject;
        }
    }

    public static Texture getWaypointIcon(ResourceLocation location) {
        if (!"journeymap".equals(location.getNamespace())) {
            TextureManager manager = Minecraft.getInstance().getTextureManager();
            ResourceLocation fakeResource = modTextureMap.get(location);
            if (fakeResource == null || manager.getTexture(fakeResource, null) == null) {
                fakeResource = ResourceLocation.fromNamespaceAndPath((String)"fake", (String)location.getPath());
                modTextureMap.put(location, fakeResource);
                try (SimpleTextureImpl simpleTexture = new SimpleTextureImpl(location);){
                    NativeImage img = ImageUtil.getScaledImage(4.0f, simpleTexture.getNativeImage(), false);
                    DynamicTextureImpl scaledTexture = new DynamicTextureImpl(img, fakeResource);
                    manager.register(fakeResource, (AbstractTexture)scaledTexture);
                    scaledTexture.setDisplayHeight(simpleTexture.getHeight());
                    scaledTexture.setDisplayWidth(simpleTexture.getHeight());
                }
            }
            return (Texture)manager.getTexture(fakeResource, null);
        }
        return TextureCache.getTexture(location);
    }

    private static boolean needsNewTexture(AbstractTexture textureObject) {
        if (textureObject == null) {
            return true;
        }
        if (textureObject instanceof Texture) {
            return !((Texture)textureObject).hasImage();
        }
        return textureObject instanceof SimpleTexture;
    }

    public static <T extends Texture> Future<T> scheduleTextureTask(Callable<T> textureTask) {
        return texExec.submit(textureTask);
    }

    public static void reset() {
        playerSkins.clear();
        Arrays.asList(ColorPicker, ColorPicker2, Deathpoint, GridSquares, GridRegionSquares, GridRegion, Logo, MinimapSquare128, MinimapSquare256, MinimapSquare512, MobDot, MobDotArrow, MobDotChevron, PlayerArrow, PlayerArrowBG, PlayerArrowBG, TileSampleDay, TileSampleNight, TileSampleUnderground, UnknownEntity, Waypoint, WaypointEdit, WaypointOffscreen).stream().map(TextureCache::getTexture);
        Arrays.asList(ColorPicker, ColorPicker2, GridSquares, GridRegion, GridRegionSquares, TileSampleDay, TileSampleNight, TileSampleUnderground, UnknownEntity).stream().map(TextureCache::getTexture);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void purgeThemeImages(Map<String, Texture> themeImages) {
        Map<String, Texture> map = themeImages;
        synchronized (map) {
            ExpireTextureTask.queue(themeImages.values());
            themeImages.clear();
        }
    }

    public static NativeImage resolveImage(ResourceLocation location) {
        if (location.getNamespace().equals("fake")) {
            return null;
        }
        ResourceManager resourceManager = Minecraft.getInstance().getResourceManager();
        try {
            Resource resource = resourceManager.getResource(location).orElse(null);
            InputStream is = resource.open();
            return NativeImage.read((InputStream)is);
        }
        catch (FileNotFoundException e) {
            try {
                Resource imgFile;
                if ("journeymap".equals(location.getNamespace()) && (imgFile = (Resource)Minecraft.getInstance().getResourceManager().getResource(ResourceLocation.parse((String)("../src/main/resources/assets/journeymap/" + location.getPath()))).orElse(null)) != null) {
                    return NativeImage.read((InputStream)imgFile.open());
                }
            }
            catch (IOException ioe) {
                Journeymap.getLogger().warn("Image not found: " + ioe.getMessage());
            }
            return null;
        }
        catch (Exception e) {
            Journeymap.getLogger().warn("Resource not readable: {}", (Object)location);
            return null;
        }
    }

    public static Texture getThemeTexture(Theme theme, String iconPath) {
        return TextureCache.getSizedThemeTexture(theme, iconPath, 0, 0, false, 1.0f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Texture getThemeTextureFromResource(ResourceLocation icon) {
        Map<String, Texture> map = themeImages;
        synchronized (map) {
            Texture tex = themeImages.get(icon.toString());
            if (tex == null || !tex.hasImage()) {
                NativeImage nativeImage;
                if (tex != null) {
                    tex.remove();
                }
                if ((nativeImage = TextureCache.resolveImage(icon)) != null && nativeImage.pixels > 0L) {
                    tex = new DynamicTextureImpl(nativeImage);
                    tex.setAlpha(1.0f);
                    themeImages.put(icon.toString(), tex);
                } else {
                    Journeymap.getLogger().error("Unknown theme image: {}", (Object)icon);
                    IconSetFileHandler.ensureEntityIconSet("Default");
                    return TextureCache.getTexture(UnknownEntity);
                }
            }
            return tex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Texture getSizedThemeTexture(Theme theme, String iconPath, int width, int height, boolean resize, float alpha) {
        String texName = String.format("%s/%s", theme.directory, iconPath);
        Map<String, Texture> map = themeImages;
        synchronized (map) {
            Texture tex = themeImages.get(texName);
            if (tex == null || !tex.hasImage() || resize && (width != tex.getWidth() || height != tex.getHeight()) || tex.getAlpha() != alpha) {
                File parentDir;
                NativeImage nativeImage;
                if (tex != null) {
                    tex.remove();
                }
                if ((nativeImage = FileHandler.getIconFromFile(parentDir = ThemeLoader.getThemeIconDir(), theme.directory, iconPath)) == null) {
                    String resourcePath = String.format("theme/%s/%s", theme.directory, iconPath);
                    nativeImage = TextureCache.resolveImage(ResourceLocation.fromNamespaceAndPath((String)"journeymap", (String)resourcePath));
                }
                if (nativeImage != null && nativeImage.pixels > 0L) {
                    if ((resize || alpha < 1.0f) && (alpha < 1.0f || nativeImage.getWidth() != width || nativeImage.getHeight() != height)) {
                        NativeImage tmp = ImageUtil.getSizedImage(width, height, nativeImage, false);
                        nativeImage.close();
                        nativeImage = tmp;
                    }
                    tex = new DynamicTextureImpl(nativeImage);
                    tex.setAlpha(alpha);
                    themeImages.put(texName, tex);
                } else {
                    Journeymap.getLogger().error("Unknown theme image: " + texName);
                    IconSetFileHandler.ensureEntityIconSet("Default");
                    return TextureCache.getTexture(UnknownEntity);
                }
            }
            return tex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Texture getScaledCopy(String texName, Texture original, int width, int height, float alpha) {
        Map<String, Texture> map = themeImages;
        synchronized (map) {
            Texture tex = themeImages.get(texName);
            if (tex == null || !tex.hasImage() || width != tex.getWidth() || height != tex.getHeight() || tex.getAlpha() != alpha) {
                if (original == null) {
                    Journeymap.getLogger().error("Unable to get scaled image: " + texName);
                    return TextureCache.getTexture(UnknownEntity);
                }
                if (!(alpha < 1.0f) && original.getWidth() == width && original.getHeight() == height) {
                    return original;
                }
                tex = new DynamicTextureImpl(ImageUtil.getSizedImage(width, height, original.getNativeImage(), true));
                tex.setAlpha(alpha);
                themeImages.put(texName, tex);
            }
            return tex;
        }
    }

    public static Texture getColorizedWaypointIcon(String id) {
        ClientWaypointImpl holder = WaypointStore.getInstance().get(id);
        if (holder != null) {
            ResourceLocation location = holder.getTextureResource();
            int color = holder.getIconColor();
            TextureManager textureManager = Minecraft.getInstance().getTextureManager();
            if (holder.hasCustomIconColor() || "journeymap".equals(location.getNamespace())) {
                SimpleTextureImpl image = new SimpleTextureImpl(location);
                if (colorizedWPIconMap.get(id) == null && image.hasImage()) {
                    NativeImage coloredImage = ImageUtil.recolorImage(image.getNativeImage(), color);
                    DynamicTextureImpl texture = new DynamicTextureImpl(coloredImage);
                    colorizedWPIconMap.put(id, texture);
                    image.close();
                    return texture;
                }
                return colorizedWPIconMap.get(id);
            }
            return (Texture)textureManager.getTexture(location, null);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Texture getPlayerSkin(GameProfile profile) {
        Texture tex = null;
        Map<String, Texture> map = playerSkins;
        synchronized (map) {
            tex = playerSkins.get(profile.getName());
            if (tex != null) {
                return tex;
            }
            NativeImage blank = new NativeImage(24, 24, false);
            tex = new DynamicTextureImpl(blank);
            playerSkins.put(profile.getName(), tex);
        }
        Texture playerSkinTex = tex;
        NativeImage img = IgnSkin.getFaceImage(profile);
        if (img != null) {
            playerSkins.put(profile.getName(), new DynamicTextureImpl(img));
        } else {
            playerSkins.remove(profile.getName());
        }
        return playerSkinTex;
    }
}

