/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.render.draw;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import journeymap.client.JourneymapClient;
import journeymap.client.data.DataCache;
import journeymap.client.render.draw.DrawWayPointStep;
import journeymap.client.render.map.Renderer;
import journeymap.client.waypoint.ClientWaypointImpl;
import journeymap.common.Journeymap;
import journeymap.common.log.LogFormatter;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.phys.Vec3;

public class WaypointDrawStepFactory {
    final List<DrawWayPointStep> drawStepList = new ArrayList<DrawWayPointStep>();

    public List<DrawWayPointStep> prepareSteps(Collection<ClientWaypointImpl> waypoints, Renderer renderer, boolean checkDistance, boolean showLabel) {
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = mc.player;
        int maxDistance = JourneymapClient.getInstance().getWaypointProperties().maxDistance.get();
        float waypointLabelScale = JourneymapClient.getInstance().getFullMapProperties().waypointLabelScale.get().floatValue();
        float waypointIconScale = JourneymapClient.getInstance().getFullMapProperties().waypointIconScale.get().floatValue();
        checkDistance = checkDistance && maxDistance > 0;
        Vec3 playerVec = checkDistance ? player.position() : null;
        this.drawStepList.clear();
        try {
            for (ClientWaypointImpl waypoint : waypoints) {
                DrawWayPointStep wayPointStep;
                double actualDistance;
                if (!waypoint.isEnabled() || !waypoint.isInPlayerDimension() || checkDistance && (actualDistance = playerVec.distanceTo(waypoint.getPosition())) > (double)maxDistance || (wayPointStep = DataCache.INSTANCE.getDrawWayPointStep(waypoint)) == null) continue;
                this.drawStepList.add(wayPointStep);
                wayPointStep.setShowLabel(showLabel);
                wayPointStep.setLabelScale(waypointLabelScale);
                wayPointStep.setIconScale(waypointIconScale);
            }
        }
        catch (Throwable t) {
            Journeymap.getLogger().error("Error during prepareSteps: " + LogFormatter.toString(t));
        }
        return this.drawStepList;
    }
}

