/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.render.draw;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.List;
import journeymap.client.data.DataCache;
import journeymap.client.model.EntityDTO;
import journeymap.client.properties.InGameMapProperties;
import journeymap.client.render.draw.DrawEntityStep;
import journeymap.client.render.draw.DrawStep;
import journeymap.client.render.map.Renderer;
import journeymap.client.texture.Texture;
import journeymap.client.ui.minimap.EntityDisplay;
import journeymap.common.Journeymap;
import journeymap.common.log.LogFormatter;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.player.Player;

public class RadarDrawStepFactory {
    public List<DrawStep> prepareSteps(List<EntityDTO> entityDTOs, Renderer renderer, InGameMapProperties mapProperties) {
        boolean showAnimals = mapProperties.showAnimals.get();
        boolean showAmbient = mapProperties.showAmbientCreatures.get();
        boolean showPets = mapProperties.showPets.get();
        boolean showVillagers = mapProperties.showVillagers.get();
        EntityDisplay mobDisplay = (EntityDisplay)((Object)mapProperties.mobDisplay.get());
        EntityDisplay playerDisplay = (EntityDisplay)((Object)mapProperties.playerDisplay.get());
        boolean showMobHeading = mapProperties.showMobHeading.get();
        boolean showPlayerHeading = mapProperties.showPlayerHeading.get();
        boolean showTeamNames = mapProperties.showTeamNames.get();
        boolean showPlayerNames = mapProperties.showPlayerNames.get();
        float mobDisplayDrawScale = mapProperties.mobDisplayScale.get().floatValue();
        float playerDisplayDrawScale = mapProperties.playerDisplayScale.get().floatValue();
        ArrayList<DrawStep> drawStepList = new ArrayList<DrawStep>();
        try {
            for (EntityDTO dto : entityDTOs) {
                try {
                    AbstractHorse horse;
                    boolean isPet;
                    Texture entityIcon = null;
                    Texture locatorImg = null;
                    Texture locatorBGImg = null;
                    Entity entityLiving = (Entity)dto.entityRef.get();
                    boolean isPlayer = entityLiving instanceof Player;
                    if (entityLiving == null || renderer.getPixel(dto.posX, dto.posZ) == null) continue;
                    boolean bl = isPet = dto.owner != null && !Strings.isNullOrEmpty((String)dto.owner) || entityLiving instanceof AbstractHorse && (horse = (AbstractHorse)entityLiving).isTamed();
                    if (!showPets && isPet || !showAmbient && dto.ambientCreature && !isPlayer && (!isPet || !showPets) || !showAnimals && dto.passiveAnimal && !isPlayer && (!isPet || !showPets) || !showVillagers && (dto.profession != null || dto.npc)) continue;
                    DrawEntityStep drawStep = DataCache.INSTANCE.getDrawEntityStep(entityLiving);
                    if (isPlayer) {
                        locatorImg = EntityDisplay.getLocatorTexture(playerDisplay, showPlayerHeading);
                        locatorBGImg = EntityDisplay.getLocatorBGTexture(playerDisplay, showPlayerHeading);
                        Player entity = (Player)entityLiving;
                        entityIcon = EntityDisplay.getEntityTexture(playerDisplay, entity.getGameProfile());
                        boolean outlined = playerDisplay.isOutlined();
                        drawStep.update(playerDisplay, locatorImg, locatorBGImg, entityIcon, dto.color, dto.labelColor, showPlayerHeading, showTeamNames, showPlayerNames, outlined, playerDisplayDrawScale);
                        drawStepList.add(drawStep);
                        continue;
                    }
                    EntityDisplay actualDisplay = mobDisplay;
                    if (!EntityDisplay.hasEntityIcon(actualDisplay, dto)) {
                        actualDisplay = mobDisplay.getDot();
                    }
                    locatorImg = EntityDisplay.getLocatorTexture(actualDisplay, showMobHeading);
                    locatorBGImg = EntityDisplay.getLocatorBGTexture(actualDisplay, showMobHeading);
                    entityIcon = EntityDisplay.getEntityTexture(actualDisplay, dto);
                    drawStep.update(actualDisplay, locatorImg, locatorBGImg, entityIcon, dto.color, dto.labelColor, showMobHeading, false, false, false, mobDisplayDrawScale);
                    drawStepList.add(drawStep);
                }
                catch (Exception e) {
                    Journeymap.getLogger().error("Exception during prepareSteps: " + LogFormatter.toString(e));
                }
            }
        }
        catch (Throwable t) {
            Journeymap.getLogger().error("Throwable during prepareSteps: " + LogFormatter.toString(t));
        }
        return drawStepList;
    }
}

