/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.render.draw;

import com.google.common.cache.CacheLoader;
import earcut4j.Earcut;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import journeymap.api.v2.client.display.Context;
import journeymap.api.v2.client.display.PolygonOverlay;
import journeymap.api.v2.client.model.MapPolygon;
import journeymap.api.v2.client.model.TextProperties;
import journeymap.client.data.DataCache;
import journeymap.client.render.draw.BaseOverlayDrawStep;
import journeymap.client.render.draw.DrawStep;
import journeymap.client.render.draw.DrawUtil;
import journeymap.client.render.map.Renderer;
import journeymap.client.texture.Texture;
import journeymap.client.texture.TextureCache;
import journeymap.client.ui.UIManager;
import journeymap.client.ui.minimap.DisplayVars;
import journeymap.client.ui.minimap.Shape;
import journeymap.common.Journeymap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class DrawPolygonStep
extends BaseOverlayDrawStep<PolygonOverlay> {
    protected List<Point2D.Double> fillPoints = new ArrayList<Point2D.Double>();
    protected List<List<Point2D.Double>> strokePoints = new ArrayList<List<Point2D.Double>>();
    protected List<Point2D.Double> texturePoints = new ArrayList<Point2D.Double>();
    private ResourceLocation textureResource;
    private volatile Future<Texture> textureFuture;
    private Texture texture;
    boolean doRender = true;
    boolean onScreen;

    public DrawPolygonStep(PolygonOverlay polygon) {
        super(polygon);
    }

    @Override
    public void draw(GuiGraphics graphics, MultiBufferSource buffers, DrawStep.Pass pass, double xOffset, double yOffset, Renderer renderer, double fontScale, double rotation) {
        if (pass == DrawStep.Pass.Object) {
            if (((PolygonOverlay)this.overlay).getOuterArea().getPoints().isEmpty()) {
                this.onScreen = false;
                return;
            }
            this.onScreen = this.isOnScreen(xOffset, yOffset, renderer, rotation);
            if (this.onScreen && this.doRender) {
                this.ensureTexture();
                DrawUtil.drawPolygon(graphics, buffers, xOffset, yOffset, this.fillPoints, this.strokePoints, this.texturePoints, this.texture, ((PolygonOverlay)this.overlay).getShapeProperties());
            }
        } else if (pass == DrawStep.Pass.Text && this.onScreen && this.doRender && this.isTextInMinimap(renderer)) {
            super.drawText(graphics, pass, xOffset, yOffset, renderer, fontScale, rotation);
        }
    }

    public void setTextureResource(ResourceLocation textureResource) {
        this.textureResource = textureResource;
        this.texture = null;
    }

    public ResourceLocation getTextureResource() {
        return this.textureResource;
    }

    protected void ensureTexture() {
        if (this.textureResource == null || this.texture != null) {
            return;
        }
        try {
            if (this.textureFuture == null || this.textureFuture.isCancelled()) {
                this.textureFuture = TextureCache.scheduleTextureTask(() -> TextureCache.getTexture(this.textureResource));
            } else if (this.textureFuture.isDone()) {
                this.texture = this.textureFuture.get();
                if (this.texture != null) {
                    ((AbstractTexture)this.texture).bind();
                    this.textureFuture = null;
                }
            }
        }
        catch (Exception e) {
            Journeymap.getLogger().error("Error getting PolygonOverlay texture: " + String.valueOf(e), (Throwable)e);
        }
    }

    private boolean isTextInMinimap(Renderer renderer) {
        if (renderer.getUIState().ui == Context.UI.Minimap) {
            Minecraft mc = Minecraft.getInstance();
            DisplayVars dv = UIManager.INSTANCE.getMiniMap().getDisplayVars();
            Point2D.Double centerPoint = renderer.getPixel(mc.player.getX(), mc.player.getZ());
            Rectangle2D.Double centerRect = new Rectangle2D.Double(((Point2D)centerPoint).getX() - (double)(dv.minimapWidth / 2), ((Point2D)centerPoint).getY() - (double)(dv.minimapHeight / 2), dv.minimapWidth, dv.minimapHeight);
            if (dv.getShape() == Shape.Circle) {
                return centerPoint.distance(this.labelPosition) < (double)(dv.minimapWidth / 2);
            }
            return centerRect.contains(renderer.getWindowPosition(this.labelPosition));
        }
        return true;
    }

    @Override
    protected void updatePositions(Renderer renderer, double rotation) {
        if (((PolygonOverlay)this.overlay).getOuterArea().getPoints().isEmpty()) {
            return;
        }
        if (Context.UI.Minimap == renderer.getUIState().ui) {
            Vec3 playerPos = Minecraft.getInstance().player.position();
            int limit = renderer.getZoom() * renderer.getGridSize() / 2;
            if (!((BlockPos)((PolygonOverlay)this.overlay).getOuterArea().getPoints().get(0)).closerThan(new Vec3i(Mth.floor((double)playerPos.x()), Mth.floor((double)playerPos.y()), Mth.floor((double)playerPos.z())), (double)limit)) {
                this.doRender = false;
                return;
            }
        }
        this.doRender = true;
        List<BlockPos> points = DataCache.INSTANCE.getTriangulation((PolygonOverlay)this.overlay);
        this.fillPoints.clear();
        this.texturePoints.clear();
        for (BlockPos pos : points) {
            Point2D.Double pixel = renderer.getBlockPixelInGrid(pos);
            if (this.fillPoints.isEmpty()) {
                this.screenBounds.setRect(pixel.x, pixel.y, 1.0, 1.0);
            } else {
                this.screenBounds.add(pixel);
            }
            this.fillPoints.add(pixel);
            this.texturePoints.add(new Point2D.Double(pos.getX(), pos.getZ()));
        }
        this.strokePoints.clear();
        this.strokePoints.add(DrawPolygonStep.toScreen(renderer, ((PolygonOverlay)this.overlay).getOuterArea()));
        if (((PolygonOverlay)this.overlay).getHoles() != null) {
            for (MapPolygon hole : ((PolygonOverlay)this.overlay).getHoles()) {
                this.strokePoints.add(DrawPolygonStep.toScreen(renderer, hole));
            }
        }
        TextProperties textProperties = ((PolygonOverlay)this.overlay).getTextProperties();
        this.labelPosition.setLocation(this.screenBounds.getCenterX() + (double)textProperties.getOffsetX(), this.screenBounds.getCenterY() + (double)textProperties.getOffsetY());
    }

    private static List<Point2D.Double> toScreen(@NotNull Renderer renderer, @NotNull MapPolygon polygon) {
        ArrayList<Point2D.Double> points = new ArrayList<Point2D.Double>();
        for (BlockPos pos : polygon.getPoints()) {
            points.add(renderer.getBlockPixelInGrid(pos));
        }
        return points;
    }

    public static List<MapPolygon> triangulate(@NotNull PolygonOverlay overlay) {
        List holesList = Optional.ofNullable(overlay.getHoles()).orElse(new ArrayList());
        List blockPoints = Stream.concat(overlay.getOuterArea().getPoints().stream(), holesList.stream().flatMap(hole -> hole.getPoints().stream())).collect(Collectors.toList());
        double[] points = new double[blockPoints.size() * 2];
        for (int index = 0; index < blockPoints.size(); ++index) {
            points[index * 2] = ((BlockPos)blockPoints.get(index)).getX();
            points[index * 2 + 1] = ((BlockPos)blockPoints.get(index)).getZ();
        }
        int[] holes = new int[holesList.size()];
        int holeIndex = overlay.getOuterArea().getPoints().size();
        for (int index = 0; index < holesList.size(); ++index) {
            holes[index] = holeIndex;
            holeIndex += ((MapPolygon)holesList.get(index)).getPoints().size();
        }
        List<Integer> triangles = Earcut.earcut(points, holes, 2);
        ArrayList<MapPolygon> trianglePolys = new ArrayList<MapPolygon>();
        for (int index = 0; index < triangles.size(); index += 3) {
            ArrayList<BlockPos> trianglePoints = new ArrayList<BlockPos>();
            trianglePoints.add((BlockPos)blockPoints.get(triangles.get(index + 2)));
            trianglePoints.add((BlockPos)blockPoints.get(triangles.get(index + 1)));
            trianglePoints.add((BlockPos)blockPoints.get(triangles.get(index)));
            trianglePolys.add(new MapPolygon(trianglePoints));
        }
        return trianglePolys;
    }

    public static class SimpleCacheLoader
    extends CacheLoader<PolygonOverlay, DrawPolygonStep> {
        public DrawPolygonStep load(PolygonOverlay overlay) throws Exception {
            return new DrawPolygonStep(overlay);
        }
    }

    public static class TriangulationCacheLoader
    extends CacheLoader<PolygonOverlay, List<BlockPos>> {
        public List<BlockPos> load(PolygonOverlay overlay) throws Exception {
            return DrawPolygonStep.triangulate(overlay).stream().flatMap(poly -> poly.getPoints().stream()).collect(Collectors.toList());
        }
    }
}

