/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.render;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexFormat;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.OptionalDouble;
import journeymap.client.JourneymapClient;
import journeymap.client.render.RenderWrapper;
import journeymap.client.texture.RegionTexture;
import journeymap.client.texture.Texture;
import net.minecraft.Util;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.resources.ResourceLocation;

public class JMRenderTypes
extends RenderType {
    static final ResourceLocation WAYPOINT_DEFAULT_BEAM = ResourceLocation.parse((String)"textures/entity/beacon_beam.png");
    static final Object2ObjectOpenHashMap<ResourceLocation, RenderType> GRID_LINES_RENDER_TYPE_MAP = new Object2ObjectOpenHashMap();
    static final Object2ObjectOpenHashMap<String, RenderType> REGION_TILE_RENDER_TYPE_MAP = new Object2ObjectOpenHashMap();
    static final Int2ObjectOpenHashMap<RenderType> ICON_RENDER_TYPE_MAP = new Int2ObjectOpenHashMap();
    static final Int2ObjectOpenHashMap<RenderType> ICON_UNMASKED_RENDER_TYPE_MAP = new Int2ObjectOpenHashMap();
    static final Int2ObjectOpenHashMap<RenderType> POLYGON_WITH_TEXTURE_RENDER_TYPE_MAP = new Int2ObjectOpenHashMap();
    public static RenderStateShard.ShaderStateShard POSITION_TEX_COLOR_SHADER;
    static final Object2ObjectOpenHashMap<String, RenderStateShard.ShaderStateShard> REGION_SHADERS_MAP;
    protected static final RenderStateShard.TransparencyStateShard GRID_LINES_TRANSPARENCY;
    protected static final RenderStateShard.TexturingStateShard MINIMAP_MASK_TRANSPARENCY;
    protected static final RenderStateShard.TransparencyStateShard ICON_TRANSPARENCY;
    protected static final RenderStateShard.TransparencyStateShard POLYGON_TRANSPARENCY;
    public static final RenderType MINIMAP_RECTANGLE_MASK_RENDER_TYPE;
    public static final RenderType BEAM_RENDER_TYPE;
    public static final RenderType RECTANGLE_RENDER_TYPE;
    public static final RenderType GRID_LINES_RENDER_TYPE;
    public static final RenderType POLYGON_WITHOUT_TEXTURE_RENDER_TYPE;
    public static final RenderType POLYGON_STROKE_RENDER_TYPE;

    public static void registerMapShader(String key, ShaderInstance shader) {
        REGION_SHADERS_MAP.put((Object)key, (Object)new RenderStateShard.ShaderStateShard(() -> shader));
        REGION_TILE_RENDER_TYPE_MAP.clear();
    }

    public static void registerPosTexColorShader(ShaderInstance shader) {
        POLYGON_WITH_TEXTURE_RENDER_TYPE_MAP.clear();
        ICON_UNMASKED_RENDER_TYPE_MAP.clear();
        ICON_RENDER_TYPE_MAP.clear();
        REGION_TILE_RENDER_TYPE_MAP.clear();
        GRID_LINES_RENDER_TYPE_MAP.clear();
        POSITION_TEX_COLOR_SHADER = new RenderStateShard.ShaderStateShard(() -> shader);
    }

    public JMRenderTypes(String name, VertexFormat vertexFormat, VertexFormat.Mode drawMode, int bufferSize, boolean useDelegate, boolean needsSorting, Runnable pre, Runnable post) {
        super(name, vertexFormat, drawMode, bufferSize, useDelegate, needsSorting, pre, post);
    }

    public static RenderType getGridLines(ResourceLocation resourceLocation) {
        RenderType type = (RenderType)GRID_LINES_RENDER_TYPE_MAP.get((Object)resourceLocation);
        if (type == null) {
            type = JMRenderTypes.create((String)("grid_lines" + resourceLocation.toDebugFileName()), (VertexFormat)DefaultVertexFormat.POSITION_TEX_COLOR, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)false, (boolean)true, (RenderType.CompositeState)RenderType.CompositeState.builder().setTextureState((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(resourceLocation, false, false)).setDepthTestState(LEQUAL_DEPTH_TEST).setLineState(new RenderStateShard.LineStateShard(OptionalDouble.empty())).setLayeringState(NO_LAYERING).setTransparencyState(GRID_LINES_TRANSPARENCY).setLightmapState(NO_LIGHTMAP).setCullState(NO_CULL).setWriteMaskState(COLOR_WRITE).setShaderState(POSITION_TEX_COLOR_SHADER).createCompositeState(false));
            GRID_LINES_RENDER_TYPE_MAP.put((Object)resourceLocation, (Object)type);
        }
        return type;
    }

    public static RenderType getRegionTile(RegionTexture texture, String shader) {
        int id = texture.getTextureId();
        String key = id + "_" + shader;
        RenderType type = (RenderType)REGION_TILE_RENDER_TYPE_MAP.get((Object)key);
        if (type == null) {
            RenderStateShard.ShaderStateShard shaderState = REGION_SHADERS_MAP.get((Object)shader) == null ? POSITION_TEX_COLOR_SHADER : (RenderStateShard.ShaderStateShard)REGION_SHADERS_MAP.get((Object)shader);
            type = JMRenderTypes.create((String)("region_tile" + id), (VertexFormat)DefaultVertexFormat.POSITION_TEX_COLOR, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)false, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.builder().setTextureState((RenderStateShard.EmptyTextureStateShard)new RegionTileStateShard(id)).setDepthTestState(LEQUAL_DEPTH_TEST).setLineState(new RenderStateShard.LineStateShard(OptionalDouble.empty())).setLayeringState(NO_LAYERING).setTransparencyState(TRANSLUCENT_TRANSPARENCY).setLightmapState(NO_LIGHTMAP).setCullState(NO_CULL).setWriteMaskState(COLOR_WRITE).setShaderState(shaderState).createCompositeState(false));
            REGION_TILE_RENDER_TYPE_MAP.put((Object)key, (Object)type);
        }
        return type;
    }

    public static RenderType getMinimapCircleMask(Texture texture) {
        return JMRenderTypes.create((String)"minimap_circle_mask", (VertexFormat)DefaultVertexFormat.POSITION_TEX, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)false, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.builder().setTextureState(new RenderStateShard.EmptyTextureStateShard(() -> {
            RenderWrapper.bindTexture(texture.getTextureId());
            RenderWrapper.setShaderTexture(0, texture.getTextureId());
        }, () -> {})).setDepthTestState(LEQUAL_DEPTH_TEST).setLineState(new RenderStateShard.LineStateShard(OptionalDouble.empty())).setLayeringState(NO_LAYERING).setTransparencyState(NO_TRANSPARENCY).setLightmapState(NO_LIGHTMAP).setCullState(NO_CULL).setTexturingState(MINIMAP_MASK_TRANSPARENCY).setWriteMaskState(DEPTH_WRITE).setShaderState(POSITION_TEX_SHADER).createCompositeState(false));
    }

    public static RenderType getIcon(Texture texture) {
        int id = texture.getTextureId();
        RenderType type = (RenderType)ICON_RENDER_TYPE_MAP.get(id);
        if (type == null) {
            type = JMRenderTypes.create((String)("icon" + id), (VertexFormat)DefaultVertexFormat.POSITION_TEX_COLOR, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)false, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.builder().setTextureState((RenderStateShard.EmptyTextureStateShard)new IconStateShard(id)).setDepthTestState(LEQUAL_DEPTH_TEST).setLineState(new RenderStateShard.LineStateShard(OptionalDouble.empty())).setLayeringState(NO_LAYERING).setTransparencyState(ICON_TRANSPARENCY).setLightmapState(NO_LIGHTMAP).setCullState(NO_CULL).setWriteMaskState(COLOR_DEPTH_WRITE).setShaderState(POSITION_TEX_COLOR_SHADER).createCompositeState(false));
            ICON_RENDER_TYPE_MAP.put(id, (Object)type);
        }
        return type;
    }

    public static RenderType getIconUnmasked(Texture texture) {
        int id = texture.getTextureId();
        RenderType type = (RenderType)ICON_UNMASKED_RENDER_TYPE_MAP.get(id);
        if (type == null) {
            type = JMRenderTypes.create((String)("icon_unmasked" + id), (VertexFormat)DefaultVertexFormat.POSITION_TEX_COLOR, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)false, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.builder().setTextureState((RenderStateShard.EmptyTextureStateShard)new IconStateShard(id)).setDepthTestState(NO_DEPTH_TEST).setLineState(new RenderStateShard.LineStateShard(OptionalDouble.empty())).setLayeringState(NO_LAYERING).setTransparencyState(ICON_TRANSPARENCY).setLightmapState(NO_LIGHTMAP).setCullState(NO_CULL).setWriteMaskState(COLOR_WRITE).setShaderState(POSITION_TEX_COLOR_SHADER).createCompositeState(false));
            ICON_UNMASKED_RENDER_TYPE_MAP.put(id, (Object)type);
        }
        return type;
    }

    public static RenderType getPolygonWithTexture(Texture texture) {
        int id = texture.getTextureId();
        RenderType type = (RenderType)POLYGON_WITH_TEXTURE_RENDER_TYPE_MAP.get(id);
        if (type == null) {
            type = JMRenderTypes.create((String)("polygon" + id), (VertexFormat)DefaultVertexFormat.POSITION_TEX_COLOR, (VertexFormat.Mode)VertexFormat.Mode.TRIANGLES, (int)256, (boolean)false, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.builder().setTextureState(new RenderStateShard.EmptyTextureStateShard(() -> {
                RenderWrapper.bindTexture(id);
                RenderWrapper.setShaderTexture(0, id);
            }, () -> {})).setDepthTestState(LEQUAL_DEPTH_TEST).setLineState(new RenderStateShard.LineStateShard(OptionalDouble.empty())).setLayeringState(NO_LAYERING).setTransparencyState(POLYGON_TRANSPARENCY).setLightmapState(NO_LIGHTMAP).setCullState(NO_CULL).setWriteMaskState(COLOR_WRITE).setShaderState(POSITION_TEX_COLOR_SHADER).createCompositeState(false));
            POLYGON_WITH_TEXTURE_RENDER_TYPE_MAP.put(id, (Object)type);
        }
        return type;
    }

    static {
        REGION_SHADERS_MAP = (Object2ObjectOpenHashMap)Util.make(() -> {
            Object2ObjectOpenHashMap map = new Object2ObjectOpenHashMap();
            map.put((Object)"default", (Object)POSITION_TEX_COLOR_SHADER);
            return map;
        });
        GRID_LINES_TRANSPARENCY = new RenderStateShard.TransparencyStateShard("grid_lines_transparency", () -> {
            RenderWrapper.enableBlend();
            RenderWrapper.blendFuncSeparate(770, 771, 1, 771);
            RenderWrapper.texParameter(3553, 10241, 9728);
            RenderWrapper.texParameter(3553, 10240, 9728);
            RenderWrapper.texParameter(3553, 10242, 10497);
            RenderWrapper.texParameter(3553, 10243, 10497);
        }, () -> {
            RenderWrapper.disableBlend();
            RenderWrapper.defaultBlendFunc();
        });
        MINIMAP_MASK_TRANSPARENCY = new RenderStateShard.TexturingStateShard("minimap_mask_texturing", () -> {
            RenderSystem.clearDepth((double)0.0);
            RenderWrapper.clear(256);
            RenderSystem.clearDepth((double)1.0);
            RenderWrapper.depthFunc(519);
        }, () -> RenderWrapper.depthFunc(515));
        ICON_TRANSPARENCY = new RenderStateShard.TransparencyStateShard("icon_transparency", () -> {
            RenderWrapper.enableBlend();
            RenderWrapper.blendFuncSeparate(770, 771, 1, 0);
        }, () -> {
            RenderWrapper.disableBlend();
            RenderWrapper.defaultBlendFunc();
        });
        POLYGON_TRANSPARENCY = new RenderStateShard.TransparencyStateShard("polygon_transparency", () -> {
            RenderWrapper.enableBlend();
            RenderWrapper.blendFuncSeparate(770, 771, 1, 0);
            RenderWrapper.texParameter(3553, 10241, 9728);
            RenderWrapper.texParameter(3553, 10240, 9728);
            RenderWrapper.texParameter(3553, 10242, 10497);
            RenderWrapper.texParameter(3553, 10243, 10497);
        }, () -> {
            RenderWrapper.disableBlend();
            RenderWrapper.defaultBlendFunc();
        });
        MINIMAP_RECTANGLE_MASK_RENDER_TYPE = JMRenderTypes.create((String)"minimap_rectangle_mask", (VertexFormat)DefaultVertexFormat.POSITION_COLOR, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)false, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.builder().setTextureState(NO_TEXTURE).setDepthTestState(LEQUAL_DEPTH_TEST).setLineState(new RenderStateShard.LineStateShard(OptionalDouble.empty())).setLayeringState(NO_LAYERING).setTransparencyState(NO_TRANSPARENCY).setLightmapState(NO_LIGHTMAP).setCullState(NO_CULL).setTexturingState(MINIMAP_MASK_TRANSPARENCY).setWriteMaskState(DEPTH_WRITE).setShaderState(POSITION_COLOR_SHADER).createCompositeState(false));
        BEAM_RENDER_TYPE = JMRenderTypes.create((String)"waypoint_beam", (VertexFormat)DefaultVertexFormat.POSITION_COLOR_TEX_LIGHTMAP, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)false, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.builder().setTextureState((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(WAYPOINT_DEFAULT_BEAM, true, false)).setCullState(CULL).setLineState(new RenderStateShard.LineStateShard(OptionalDouble.empty())).setLayeringState(NO_LAYERING).setTransparencyState(TRANSLUCENT_TRANSPARENCY).setLightmapState(LIGHTMAP).setWriteMaskState(COLOR_WRITE).setShaderState(POSITION_COLOR_TEX_LIGHTMAP_SHADER).createCompositeState(false));
        RECTANGLE_RENDER_TYPE = JMRenderTypes.create((String)"rectangle", (VertexFormat)DefaultVertexFormat.POSITION_COLOR, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)false, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.builder().setTextureState(NO_TEXTURE).setDepthTestState(LEQUAL_DEPTH_TEST).setCullState(NO_CULL).setLineState(new RenderStateShard.LineStateShard(OptionalDouble.empty())).setLayeringState(NO_LAYERING).setTransparencyState(TRANSLUCENT_TRANSPARENCY).setLightmapState(NO_LIGHTMAP).setWriteMaskState(COLOR_DEPTH_WRITE).setShaderState(POSITION_COLOR_SHADER).createCompositeState(false));
        GRID_LINES_RENDER_TYPE = JMRenderTypes.create((String)"grid_lines", (VertexFormat)DefaultVertexFormat.POSITION_COLOR, (VertexFormat.Mode)VertexFormat.Mode.DEBUG_LINES, (int)256, (boolean)false, (boolean)true, (RenderType.CompositeState)RenderType.CompositeState.builder().setTextureState(NO_TEXTURE).setDepthTestState(LEQUAL_DEPTH_TEST).setLineState(new RenderStateShard.LineStateShard(OptionalDouble.of(1.0))).setLayeringState(NO_LAYERING).setTransparencyState(TRANSLUCENT_TRANSPARENCY).setLightmapState(NO_LIGHTMAP).setCullState(NO_CULL).setWriteMaskState(COLOR_WRITE).setShaderState(POSITION_COLOR_SHADER).createCompositeState(false));
        POLYGON_WITHOUT_TEXTURE_RENDER_TYPE = JMRenderTypes.create((String)"polygon", (VertexFormat)DefaultVertexFormat.POSITION_COLOR, (VertexFormat.Mode)VertexFormat.Mode.TRIANGLES, (int)256, (boolean)false, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.builder().setTextureState(NO_TEXTURE).setDepthTestState(LEQUAL_DEPTH_TEST).setCullState(NO_CULL).setLineState(new RenderStateShard.LineStateShard(OptionalDouble.empty())).setLayeringState(NO_LAYERING).setTransparencyState(POLYGON_TRANSPARENCY).setLightmapState(NO_LIGHTMAP).setWriteMaskState(COLOR_WRITE).setShaderState(POSITION_COLOR_SHADER).createCompositeState(false));
        POLYGON_STROKE_RENDER_TYPE = JMRenderTypes.create((String)"polygon_stroke", (VertexFormat)DefaultVertexFormat.POSITION_COLOR, (VertexFormat.Mode)VertexFormat.Mode.TRIANGLE_STRIP, (int)256, (boolean)false, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.builder().setTextureState(NO_TEXTURE).setDepthTestState(LEQUAL_DEPTH_TEST).setCullState(NO_CULL).setLineState(new RenderStateShard.LineStateShard(OptionalDouble.empty())).setLayeringState(NO_LAYERING).setTransparencyState(POLYGON_TRANSPARENCY).setLightmapState(NO_LIGHTMAP).setWriteMaskState(COLOR_WRITE).setShaderState(POSITION_COLOR_SHADER).createCompositeState(false));
    }

    protected static class RegionTileStateShard
    extends RenderStateShard.EmptyTextureStateShard {
        private final int textureId;

        public RegionTileStateShard(int textureId) {
            super(() -> {
                RenderWrapper.bindTexture(textureId);
                RenderWrapper.texParameter(3553, 10241, 9984);
                RenderWrapper.texParameter(3553, 10240, 9728);
                RenderWrapper.texParameter(3553, 10242, 33071);
                RenderWrapper.texParameter(3553, 10243, 33071);
                int mipmapLevels = JourneymapClient.getInstance().getCoreProperties().mipmapLevels.get();
                RenderWrapper.texParameter(3553, 33085, mipmapLevels);
                RenderWrapper.texParameter(3553, 33082, 0);
                RenderWrapper.texParameter(3553, 33083, mipmapLevels);
                RenderWrapper.texParameter(3553, 34049, 0);
                RenderWrapper.setShaderTexture(0, textureId);
            }, () -> {});
            this.textureId = textureId;
        }

        public String toString() {
            return this.name + "[" + this.textureId + ")]";
        }
    }

    protected static class IconStateShard
    extends RenderStateShard.EmptyTextureStateShard {
        private final int textureId;

        public IconStateShard(int textureId) {
            super(() -> {
                RenderWrapper.bindTexture(textureId);
                RenderWrapper.texParameter(3553, 10241, 9729);
                RenderWrapper.texParameter(3553, 10240, 9729);
                RenderWrapper.texParameter(3553, 10242, 10497);
                RenderWrapper.texParameter(3553, 10243, 10497);
                RenderWrapper.setShaderTexture(0, textureId);
            }, () -> {});
            this.textureId = textureId;
        }

        public String toString() {
            return this.name + "[" + this.textureId + ")]";
        }
    }
}

