/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.model;

import com.google.common.collect.ImmutableSortedMap;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import journeymap.api.client.impl.EntityRegistrationFactory;
import journeymap.client.JourneymapClient;
import journeymap.client.data.DataCache;
import journeymap.client.event.dispatchers.CustomEventDispatcher;
import journeymap.client.log.JMLogger;
import journeymap.client.log.StatTimer;
import journeymap.client.model.EntityDTO;
import journeymap.client.render.RenderFacade;
import journeymap.common.Journeymap;
import journeymap.common.log.LogFormatter;
import journeymap.common.util.PlayerRadarManager;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.client.renderer.entity.CreeperRenderer;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.VillagerRenderer;
import net.minecraft.client.renderer.entity.ZombieVillagerRenderer;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.ZombieVillager;
import net.minecraft.world.entity.npc.Npc;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.VillagerDataHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;

public class EntityHelper {
    private static final EntityDistanceComparator entityDistanceComparator = new EntityDistanceComparator();
    private static final EntityDTODistanceComparator entityDTODistanceComparator = new EntityDTODistanceComparator();
    public static final EntityMapComparator entityMapComparator = new EntityMapComparator();
    private static final String[] HORSE_TEXTURES = new String[]{"textures/entity/horse/horse_white.png", "textures/entity/horse/horse_creamy.png", "textures/entity/horse/horse_chestnut.png", "textures/entity/horse/horse_brown.png", "textures/entity/horse/horse_black.png", "textures/entity/horse/horse_gray.png", "textures/entity/horse/horse_darkbrown.png"};

    public static List<EntityDTO> getEntitiesNearby(String timerName, int maxEntities, boolean hostile, List<Class<? extends Entity>> entities, Class ... entityClasses) {
        StatTimer timer = StatTimer.get("EntityHelper." + timerName);
        timer.start();
        ArrayList<Class> classes = new ArrayList<Class>(List.of(entityClasses));
        classes.addAll(entities);
        Minecraft mc = Minecraft.getInstance();
        List<EntityDTO> list = new ArrayList<EntityDTO>();
        ArrayList allEntities = new ArrayList();
        mc.level.entitiesForRendering().forEach(allEntities::add);
        AABB bb = EntityHelper.getBB((Player)mc.player);
        try {
            block2: for (Entity entity : allEntities) {
                if (!entity.isAlive() || !bb.intersects(entity.getBoundingBox())) continue;
                for (Class entityClass : classes) {
                    if (!entityClass.isAssignableFrom(entity.getClass()) || !EntityHelper.isSpecialCreature(entity, hostile)) continue;
                    LivingEntity entityLivingBase = (LivingEntity)entity;
                    EntityDTO dto = DataCache.INSTANCE.getEntityDTO(entityLivingBase);
                    dto.update(entityLivingBase, hostile);
                    if (!CustomEventDispatcher.getInstance().entityRadarMobUpdateEvent(dto)) continue block2;
                    list.add(dto);
                    continue block2;
                }
            }
            if (list.size() > maxEntities) {
                EntityHelper.entityDTODistanceComparator.player = mc.player;
                Collections.sort(list, entityDTODistanceComparator);
                list = list.subList(0, maxEntities);
            }
        }
        catch (Throwable t) {
            Journeymap.getLogger().warn("Failed to " + timerName + ": " + LogFormatter.toString(t));
        }
        timer.stop();
        return list;
    }

    private static boolean isSpecialCreature(Entity entity, boolean hostile) {
        if (PathfinderMob.class.isAssignableFrom(entity.getClass())) {
            if (hostile && entity.getType().getCategory().equals((Object)MobCategory.MONSTER)) {
                return true;
            }
            return !hostile && entity.getType().getCategory().isFriendly();
        }
        return true;
    }

    public static List<EntityDTO> getMobsNearby() {
        return EntityHelper.getEntitiesNearby("getMobsNearby", JourneymapClient.getInstance().getCoreProperties().maxMobsData.get(), true, EntityRegistrationFactory.getInstance().getHostiles(), Enemy.class);
    }

    public static List<EntityDTO> getVillagersNearby() {
        return EntityHelper.getEntitiesNearby("getVillagersNearby", JourneymapClient.getInstance().getCoreProperties().maxVillagersData.get(), false, EntityRegistrationFactory.getInstance().getVillagers(), Npc.class);
    }

    public static List<EntityDTO> getAnimalsNearby() {
        return EntityHelper.getEntitiesNearby("getAnimalsNearby", JourneymapClient.getInstance().getCoreProperties().maxAnimalsData.get(), false, EntityRegistrationFactory.getInstance().getPassives(), new Class[0]);
    }

    public static List<EntityDTO> getAmbientCreaturesNearby() {
        return EntityHelper.getEntitiesNearby("getAmbientCreaturesNearby", JourneymapClient.getInstance().getCoreProperties().maxAmbientCreaturesData.get(), false, EntityRegistrationFactory.getInstance().getAmbient(), new Class[0]);
    }

    public static boolean isPassive(LivingEntity entityLiving) {
        if (entityLiving == null) {
            return false;
        }
        if (entityLiving instanceof Enemy) {
            return false;
        }
        LivingEntity attackTarget = entityLiving.getKillCredit();
        return attackTarget == null || !(attackTarget instanceof Player) && !(attackTarget instanceof TamableAnimal);
    }

    public static List<EntityDTO> getPlayersNearby() {
        StatTimer timer = StatTimer.get("EntityHelper.getPlayersNearby");
        timer.start();
        Minecraft mc = Minecraft.getInstance();
        List<Player> allPlayers = new ArrayList();
        if (JourneymapClient.getInstance().getStateHandler().isExpandedRadarEnabled()) {
            if (mc.getConnection().getOnlinePlayers() != null && mc.getConnection().getOnlinePlayers().size() > 1) {
                for (PlayerInfo onlinePlayer : mc.getConnection().getOnlinePlayers()) {
                    Player networkedPlayer;
                    if (onlinePlayer.getProfile().getId().equals(mc.player.getUUID()) || (networkedPlayer = PlayerRadarManager.getInstance().getPlayers().get(onlinePlayer.getProfile().getId())) == null || networkedPlayer.getCommandSenderWorld().dimension() != Minecraft.getInstance().player.getCommandSenderWorld().dimension()) continue;
                    allPlayers.add(networkedPlayer);
                }
            }
        } else {
            allPlayers.addAll(mc.level.players());
            allPlayers.remove(mc.player);
        }
        int max = JourneymapClient.getInstance().getCoreProperties().maxPlayersData.get();
        if (allPlayers.size() > max) {
            EntityHelper.entityDistanceComparator.player = mc.player;
            Collections.sort(allPlayers, entityDistanceComparator);
            allPlayers = allPlayers.subList(0, max);
        }
        ArrayList<EntityDTO> playerDTOs = new ArrayList<EntityDTO>(allPlayers.size());
        for (Player player : allPlayers) {
            EntityDTO dto = DataCache.INSTANCE.getEntityDTO((LivingEntity)player);
            dto.update((LivingEntity)player, false);
            if (!CustomEventDispatcher.getInstance().entityRadarPlayerUpdateEvent(dto)) continue;
            playerDTOs.add(dto);
        }
        timer.stop();
        return playerDTOs;
    }

    private static AABB getBB(Player player) {
        int lateralDistance = JourneymapClient.getInstance().getCoreProperties().radarLateralDistance.get();
        int verticalDistance = JourneymapClient.getInstance().getCoreProperties().radarVerticalDistance.get();
        return EntityHelper.getBoundingBox(player, lateralDistance, verticalDistance);
    }

    public static AABB getBoundingBox(Player player, double lateralDistance, double verticalDistance) {
        return player.getBoundingBox().inflate(lateralDistance, verticalDistance, lateralDistance);
    }

    public static Map<String, EntityDTO> buildEntityIdMap(List<? extends EntityDTO> list, boolean sort) {
        if (list == null || list.isEmpty()) {
            return Collections.emptyMap();
        }
        if (sort) {
            Collections.sort(list, entityMapComparator);
        }
        LinkedHashMap<CallSite, EntityDTO> idMap = new LinkedHashMap<CallSite, EntityDTO>(list.size());
        for (EntityDTO entityDTO : list) {
            idMap.put((CallSite)((Object)("id" + entityDTO.entityId)), entityDTO);
        }
        return ImmutableSortedMap.copyOf(idMap);
    }

    public static IconData getIconData(Entity entity) {
        try {
            String typePath;
            EntityRenderer entityRender = Minecraft.getInstance().getEntityRenderDispatcher().getRenderer(entity);
            IconData iconData = new IconData();
            iconData.type = BuiltInRegistries.ENTITY_TYPE.getKey((Object)entity.getType());
            if (entityRender instanceof CreeperRenderer) {
                Creeper creeper = (Creeper)entity;
                iconData.icon = iconData.texture = entityRender.getTextureLocation((Entity)creeper);
                if (creeper.isPowered()) {
                    String iconPath = iconData.icon.getPath().replace("creeper.png", "creeper_armor.png");
                    typePath = iconData.type.getPath().replace("creeper", "charged_creeper");
                    iconData.icon = ResourceLocation.fromNamespaceAndPath((String)iconData.icon.getNamespace(), (String)iconPath);
                    iconData.type = ResourceLocation.fromNamespaceAndPath((String)iconData.type.getNamespace(), (String)typePath);
                }
            } else if (entityRender instanceof VillagerRenderer || entityRender instanceof ZombieVillagerRenderer) {
                String type;
                if (entityRender instanceof VillagerRenderer) {
                    type = "villager.png";
                    iconData.texture = entityRender.getTextureLocation((Entity)((Villager)entity));
                } else {
                    type = "zombie_villager.png";
                    iconData.texture = entityRender.getTextureLocation((Entity)((ZombieVillager)entity));
                }
                iconData.icon = iconData.texture;
                VillagerDataHolder villagerData = (VillagerDataHolder)entity;
                String profession = BuiltInRegistries.VILLAGER_PROFESSION.getKey((Object)villagerData.getVillagerData().getProfession()).getPath();
                if (profession.contains(":")) {
                    String namespace = profession.split(":")[0];
                    String path = profession.split(":")[1];
                    String poiJobIconPath = iconData.icon.getPath().replace(type, path + ".png");
                    String poiJobTypePath = iconData.type.getPath().concat("_" + path);
                    iconData.icon = ResourceLocation.fromNamespaceAndPath((String)namespace, (String)poiJobIconPath);
                    iconData.type = ResourceLocation.fromNamespaceAndPath((String)namespace, (String)poiJobTypePath);
                } else if ("minecraft".equals(iconData.icon.getNamespace()) && !"unemployed".equals(profession) && !"none".equals(profession)) {
                    String iconPath = iconData.icon.getPath().replace(type, profession + ".png");
                    String typePath2 = iconData.type.getPath().concat("_" + profession);
                    iconData.icon = ResourceLocation.fromNamespaceAndPath((String)iconData.icon.getNamespace(), (String)iconPath);
                    iconData.type = ResourceLocation.fromNamespaceAndPath((String)iconData.type.getNamespace(), (String)typePath2);
                }
            } else {
                iconData.icon = iconData.texture = RenderFacade.getEntityTexture(entityRender, entity);
            }
            if (iconData.icon == null) {
                JMLogger.logOnce("Can't get entityTexture for " + String.valueOf(entity.getClass()) + " via " + String.valueOf(entityRender.getClass()));
                return iconData;
            }
            int lastSlash = iconData.icon.getPath().lastIndexOf(47);
            int extension = iconData.icon.getPath().lastIndexOf(".png");
            typePath = iconData.icon.getPath().substring(lastSlash + 1, extension);
            iconData.type = ResourceLocation.fromNamespaceAndPath((String)iconData.type.getNamespace(), (String)typePath);
            if (iconData.icon.getNamespace().equals("cobblemon")) {
                iconData.icon = ResourceLocation.fromNamespaceAndPath((String)iconData.icon.getNamespace(), (String)iconData.icon.getPath().replace("pokemon", "entity_icon"));
            } else if (iconData.icon.getPath().contains("/model/entity/")) {
                iconData.icon = ResourceLocation.fromNamespaceAndPath((String)iconData.icon.getNamespace(), (String)iconData.icon.getPath().replace("/model/entity/", "/entity_icon/"));
            } else if ((iconData.icon.getPath().contains("/model/") || iconData.icon.getPath().contains("/models/")) && !iconData.icon.getPath().contains("/entity/")) {
                iconData.icon = ResourceLocation.fromNamespaceAndPath((String)iconData.icon.getNamespace(), (String)iconData.icon.getPath().replace("/model/", "/entity_icon/"));
            } else if (iconData.icon.getPath().contains("/entity/")) {
                iconData.icon = ResourceLocation.fromNamespaceAndPath((String)iconData.icon.getNamespace(), (String)iconData.icon.getPath().replace("/entity/", "/entity_icon/"));
            } else {
                JMLogger.logOnce(String.valueOf(iconData.icon) + " doesn't have /entity/ in path, so can't look for /entity_icon/");
                return null;
            }
            int entityIconBegin = iconData.icon.getPath().lastIndexOf("/entity_icon/");
            if (entityIconBegin != -1) {
                String name;
                extension = iconData.icon.getPath().lastIndexOf(".png");
                typePath = iconData.icon.getPath().substring(entityIconBegin += "/entity_icon/".length(), extension);
                int slash = typePath.indexOf(47);
                if (slash != -1 && typePath.startsWith(name = typePath.substring(0, slash), slash + 1)) {
                    typePath = typePath.substring(name.length() + 1);
                }
                typePath = typePath.replace('/', '_');
                iconData.type = ResourceLocation.fromNamespaceAndPath((String)iconData.type.getNamespace(), (String)typePath);
            }
            return iconData;
        }
        catch (Throwable t) {
            JMLogger.throwLogOnce("Can't get entityTexture for " + String.valueOf(entity.getName()), t);
            return new IconData();
        }
    }

    private static class EntityDTODistanceComparator
    implements Comparator<EntityDTO> {
        Player player;

        private EntityDTODistanceComparator() {
        }

        @Override
        public int compare(EntityDTO o1, EntityDTO o2) {
            Entity e1 = (Entity)o1.entityRef.get();
            Entity e2 = (Entity)o2.entityRef.get();
            if (e1 == null || e2 == null) {
                return 0;
            }
            return Double.compare(e1.distanceToSqr((Entity)this.player), e2.distanceToSqr((Entity)this.player));
        }
    }

    private static class EntityDistanceComparator
    implements Comparator<Entity> {
        Player player;

        private EntityDistanceComparator() {
        }

        @Override
        public int compare(Entity o1, Entity o2) {
            return Double.compare(o1.distanceToSqr((Entity)this.player), o2.distanceToSqr((Entity)this.player));
        }
    }

    private static class EntityMapComparator
    implements Comparator<EntityDTO> {
        private EntityMapComparator() {
        }

        @Override
        public int compare(EntityDTO o1, EntityDTO o2) {
            Integer n;
            Integer o1rank = 0;
            Integer o2rank = 0;
            if (o1.getCustomName() != null) {
                n = o1rank;
                o1rank = o1rank + 1;
            } else if (o1.username != null) {
                o1rank = o1rank + 2;
            }
            if (o2.getCustomName() != null) {
                n = o2rank;
                o2rank = o2rank + 1;
            } else if (o2.username != null) {
                o2rank = o2rank + 2;
            }
            if (o1rank.equals(o2rank) && o1.entityTypeLocation != null && o2.entityTypeLocation != null) {
                return o1.entityTypeLocation.compareTo(o2.entityTypeLocation);
            }
            return o1rank.compareTo(o2rank);
        }
    }

    public static class IconData {
        ResourceLocation texture = null;
        ResourceLocation icon = null;
        ResourceLocation type = null;
    }
}

