/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.event.handlers;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import journeymap.api.common.waypoint.WaypointFactoryImpl;
import journeymap.api.v2.client.event.PopupMenuEvent;
import journeymap.api.v2.client.fullscreen.IFullscreen;
import journeymap.api.v2.client.fullscreen.ModPopupMenu;
import journeymap.api.v2.common.event.ClientEventRegistry;
import journeymap.client.Constants;
import journeymap.client.JourneymapClient;
import journeymap.client.command.CmdTeleportWaypoint;
import journeymap.client.data.DataCache;
import journeymap.client.io.FileHandler;
import journeymap.client.model.ChunkMD;
import journeymap.client.model.MapType;
import journeymap.client.model.NBTChunkMD;
import journeymap.client.model.RegionCoord;
import journeymap.client.task.main.DeleteMapTask;
import journeymap.client.ui.UIManager;
import journeymap.client.ui.fullscreen.Fullscreen;
import journeymap.client.ui.waypoint.legacy.LegacyWaypointManager;
import journeymap.client.waypoint.ClientWaypointImpl;
import journeymap.common.Journeymap;
import journeymap.common.nbt.RegionData;
import journeymap.common.nbt.RegionDataStorageHandler;
import journeymap.common.waypoint.WaypointGroupStore;
import journeymap.common.waypoint.WaypointStore;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.datafix.DataFixers;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.storage.ChunkStorage;
import net.minecraft.world.level.chunk.storage.RegionStorageInfo;
import org.apache.commons.lang3.time.StopWatch;

public class PopupMenuEventHandler {
    public static PopupMenuEventHandler INSTANCE;

    private PopupMenuEventHandler() {
        ClientEventRegistry.FULLSCREEN_POPUP_MENU_EVENT.subscribe("journeymap", this::onFullscreenPopupMenu);
        ClientEventRegistry.WAYPOINT_POPUP_MENU_EVENT.subscribe("journeymap", this::onWaypointPopupMenu);
    }

    public static PopupMenuEventHandler init() {
        if (INSTANCE == null) {
            INSTANCE = new PopupMenuEventHandler();
        }
        return INSTANCE;
    }

    private void onFullscreenPopupMenu(PopupMenuEvent.FullscreenPopupMenuEvent event) {
        if (JourneymapClient.getInstance().enabled() && !event.isCancelled()) {
            try {
                if (CmdTeleportWaypoint.isPermitted(Minecraft.getInstance())) {
                    event.getPopupMenu().addMenuItem(Constants.getString("jm.waypoint.teleport"), this.doTeleport(event.getFullscreen()));
                }
                if (JourneymapClient.getInstance().getStateHandler().isWaypointsAllowed()) {
                    event.getPopupMenu().createSubItemList(Constants.getString("jm.waypoint.waypoints")).addMenuItem(Constants.getString("key.journeymap.create_waypoint"), this.createWaypoint(event.getFullscreen(), false)).addMenuItem(Constants.getString("jm.waypoint.create_temp_waypoint"), this.createWaypoint(event.getFullscreen(), true)).addMenuItem(Constants.getString("jm.waypoint.show_all"), b -> LegacyWaypointManager.renderWaypoints(true)).addMenuItem(Constants.getString("jm.waypoint.hide_all"), b -> LegacyWaypointManager.renderWaypoints(false));
                }
                event.getPopupMenu().addMenuItem(Constants.getString("key.journeymap.fullscreen.menu.chat_position"), this.chatAtPos(event.getFullscreen()));
                event.getPopupMenu().createSubItemList(Constants.getString("jm.fullscreen.menu.advanced")).addMenuItem(Constants.getString("jm.fullscreen.menu.delete_region"), blockPos -> this.deleteRegion(blockPos, (Fullscreen)event.getFullscreen()));
            }
            catch (Exception e) {
                Journeymap.getLogger().error("Error handling PopupMenuEvent.FullscreenPopupMenuEvent", (Throwable)e);
            }
        }
    }

    public void onWaypointPopupMenu(PopupMenuEvent.WaypointPopupMenuEvent event) {
        if (JourneymapClient.getInstance().enabled() && !event.isCancelled()) {
            try {
                List<ClientWaypointImpl> waypoints;
                ClientWaypointImpl waypoint;
                if (JourneymapClient.getInstance().getStateHandler().isWaypointsAllowed() && (waypoint = (ClientWaypointImpl)(waypoints = WaypointStore.getInstance().getAll()).stream().filter(wp -> event.getWaypoint().getId().equals(wp.getId())).findAny().orElse(null)) != null) {
                    if (CmdTeleportWaypoint.isPermitted(Minecraft.getInstance()) && CmdTeleportWaypoint.isPermitted(Minecraft.getInstance())) {
                        event.getPopupMenu().addMenuItem(Constants.getString("jm.waypoint.teleport"), blockPos -> new CmdTeleportWaypoint(waypoint).run());
                    }
                    event.getPopupMenu().addMenuItem(Constants.getString("jm.waypoint.edit"), blockPos -> UIManager.INSTANCE.openWaypointEditor(waypoint, false, (Fullscreen)event.getFullscreen()));
                    event.getPopupMenu().addMenuItem(Constants.getString("jm.waypoint.disable"), blockPos -> {
                        waypoint.setEnabled(false);
                        WaypointStore.getInstance().save(waypoint, false);
                    });
                    event.getPopupMenu().addMenuItem(Constants.getString("jm.waypoint.remove"), blockPos -> WaypointStore.getInstance().remove(waypoint, true));
                }
            }
            catch (Exception e) {
                Journeymap.getLogger().error("Error handling PopupMenuEvent.FullscreenPopupMenuEvent", (Throwable)e);
            }
        }
    }

    private ModPopupMenu.Action chatAtPos(IFullscreen fullscreen) {
        return blockPos -> {
            ClientWaypointImpl waypoint = WaypointFactoryImpl.at(blockPos, false, fullscreen.getMinecraft().player.getCommandSenderWorld().dimension().location().toString());
            ((Fullscreen)fullscreen).chatOpenedFromEvent = true;
            ((Fullscreen)fullscreen).openChat(waypoint.toChatString());
        };
    }

    private ModPopupMenu.Action createWaypoint(IFullscreen fullscreen, boolean temp) {
        return blockPos -> {
            int y = blockPos.getY();
            RegionData regionData = RegionDataStorageHandler.getInstance().getRegionDataAsyncNoCache(blockPos, ((Fullscreen)fullscreen).getMapType());
            if (regionData != null) {
                regionData.getTopY(blockPos);
            }
            BlockPos pos = new BlockPos(blockPos.getX(), y + 1, blockPos.getZ());
            ClientWaypointImpl waypoint = WaypointFactoryImpl.at(pos, false, fullscreen.getMinecraft().player.getCommandSenderWorld().dimension().location().toString());
            if (temp) {
                waypoint.setOrigin("temp");
                waypoint.setName(Constants.getString("jm.waypoint.temp") + waypoint.getName());
                waypoint.setGroupId(WaypointGroupStore.TEMP.getGuid());
                WaypointStore.getInstance().save(waypoint, true);
            } else {
                UIManager.INSTANCE.openWaypointEditor(waypoint, true, (Fullscreen)fullscreen);
            }
        };
    }

    private ModPopupMenu.Action doTeleport(IFullscreen fullscreen) {
        return blockPos -> {
            int y = blockPos.getY();
            RegionData regionData = RegionDataStorageHandler.getInstance().getRegionDataAsyncNoCache(blockPos, ((Fullscreen)fullscreen).getMapType());
            if (regionData != null) {
                y = regionData.getTopY(blockPos);
            }
            BlockPos pos = new BlockPos(blockPos.getX(), y + 1, blockPos.getZ());
            CmdTeleportWaypoint.teleport(pos, (ResourceKey<Level>)Minecraft.getInstance().level.dimension());
        };
    }

    private void deleteRegion(BlockPos blockPos, Fullscreen fullscreen) {
        try {
            MapType mapType = fullscreen.getMapType();
            ChunkPos pos = new ChunkPos(blockPos);
            File jmWorldDir = FileHandler.getJMWorldDir(Minecraft.getInstance());
            RegionCoord rCoord = RegionCoord.fromChunkPos(jmWorldDir, mapType, pos.x, pos.z);
            DeleteMapTask.queue(rCoord, mapType);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private ModPopupMenu.Action doRender(Fullscreen fullscreen) {
        return blockPos -> this.renderChunk(blockPos, fullscreen);
    }

    private void saveChunk(BlockPos pos) {
        try {
            Minecraft mc = Minecraft.getInstance();
            Path path = new File(FileHandler.getWorldSaveDir(mc), "region").toPath();
            RegionStorageInfo storage = new RegionStorageInfo(path.toString(), mc.level.dimension(), "chunk");
            ChunkStorage loader = new ChunkStorage(storage, path, DataFixers.getDataFixer(), true);
            CompletableFuture chunkFuture = loader.read(new ChunkPos(pos));
            File jmWorldDir = FileHandler.getJMWorldDir(mc);
            chunkFuture.whenCompleteAsync((chunkOptional, throwable) -> {
                if (chunkOptional.isPresent()) {
                    try {
                        NbtIo.writeCompressed((CompoundTag)((CompoundTag)chunkOptional.get()), (Path)new File(String.valueOf(jmWorldDir) + "/" + String.valueOf(new ChunkPos(pos)) + ".chunk.dat").toPath());
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void renderChunk(BlockPos blockPos, Fullscreen fullscreen) {
        MapType mapType = fullscreen.getMapType();
        CompoundTag chunk = RegionDataStorageHandler.getInstance().getRegionDataAsyncNoCache(blockPos, mapType).getChunkNbt(new ChunkPos(blockPos));
        ChunkPos chunkPos = new ChunkPos(chunk.getLong("pos"));
        File jmWorldDir = FileHandler.getJMWorldDir(Minecraft.getInstance());
        RegionCoord rCoord = RegionCoord.fromChunkPos(jmWorldDir, mapType, chunkPos.x, chunkPos.z);
        RegionDataStorageHandler.Key key = new RegionDataStorageHandler.Key(rCoord, mapType);
        RegionData regionData = RegionDataStorageHandler.getInstance().getRegionData(key);
        try {
            NbtIo.writeCompressed((CompoundTag)chunk, (Path)new File(String.valueOf(jmWorldDir) + "/" + mapType.name() + ".chunk.dat").toPath());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        NBTChunkMD chunkMd = new NBTChunkMD(new LevelChunk((Level)Minecraft.getInstance().level, chunkPos), chunkPos, chunk, mapType);
        ChunkMD md = DataCache.INSTANCE.getChunkMD(chunkPos.toLong());
        JourneymapClient.getInstance().getChunkRenderController().renderChunk(rCoord, fullscreen.getMapType(), chunkMd, regionData);
    }

    private void renderRegion(BlockPos blockPos, Fullscreen fullscreen) {
        try {
            JourneymapClient.getInstance().queueOneOff(() -> {
                MapType mapType = fullscreen.getMapType();
                ChunkPos pos = new ChunkPos(blockPos);
                File jmWorldDir = FileHandler.getJMWorldDir(Minecraft.getInstance());
                RegionCoord rCoord = RegionCoord.fromChunkPos(jmWorldDir, mapType, pos.x, pos.z);
                RegionDataStorageHandler.Key key = new RegionDataStorageHandler.Key(rCoord, mapType);
                RegionData regionData = RegionDataStorageHandler.getInstance().getRegionData(key);
                StopWatch stopwatch = new StopWatch();
                stopwatch.start();
                for (ChunkPos chunkPos : rCoord.getChunkCoordsInRegion()) {
                    CompoundTag chunk = regionData.getChunkNbt(chunkPos);
                    if (chunk.getAllKeys().size() <= 1) continue;
                    NBTChunkMD chunkMd = new NBTChunkMD(new LevelChunk((Level)Minecraft.getInstance().level, chunkPos), chunkPos, chunk, mapType);
                    ChunkMD md = DataCache.INSTANCE.getChunkMD(chunkPos.toLong());
                    JourneymapClient.getInstance().getChunkRenderController().renderChunk(rCoord, fullscreen.getMapType(), chunkMd, regionData);
                }
                stopwatch.stop();
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

