/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.command;

import com.google.common.base.Joiner;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import journeymap.client.JourneymapClient;
import journeymap.client.command.JMCommand;
import journeymap.client.log.ChatLog;
import journeymap.client.task.main.IMainThreadTask;
import journeymap.client.ui.UIManager;
import journeymap.client.waypoint.ClientWaypointImpl;
import journeymap.client.waypoint.WaypointParser;
import net.minecraft.client.Minecraft;
import net.minecraft.commands.CommandSource;

public class CmdEditWaypoint
implements JMCommand {
    @Override
    public String getName() {
        return "wpedit";
    }

    @Override
    public int execute(CommandSource sender, String[] args) throws CommandSyntaxException {
        String text = Joiner.on((String)" ").skipNulls().join((Object[])args);
        final ClientWaypointImpl holder = new ClientWaypointImpl(WaypointParser.parse(text));
        if (holder != null) {
            final boolean controlDown = InputConstants.isKeyDown((long)Minecraft.getInstance().getWindow().getWindow(), (int)341) || InputConstants.isKeyDown((long)Minecraft.getInstance().getWindow().getWindow(), (int)345);
            JourneymapClient.getInstance().queueMainThreadTask(new IMainThreadTask(){

                @Override
                public IMainThreadTask perform(Minecraft mc, JourneymapClient jm) {
                    if (controlDown) {
                        if (holder.isInPlayerDimension()) {
                            holder.setPersistent(false);
                            UIManager.INSTANCE.openFullscreenMap(holder);
                        } else {
                            ChatLog.announceError("Location is not in your dimension");
                        }
                    } else {
                        UIManager.INSTANCE.openWaypointEditor(holder, true, null);
                    }
                    return null;
                }

                @Override
                public String getName() {
                    return "Edit Waypoint";
                }
            });
        } else {
            ChatLog.announceError("Not a valid waypoint. Use: 'x:3, z:70', etc. : " + text);
        }
        return 0;
    }

    @Override
    public String getUsage(CommandSource sender) {
        return null;
    }
}

