/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.packmenu.slideshow;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import dev.shadowsoffire.packmenu.ExtendedMenuScreen;
import dev.shadowsoffire.packmenu.PackMenu;
import dev.shadowsoffire.placebo.util.ClientUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ClientTickEvent;

@EventBusSubscriber(value={Dist.CLIENT}, modid="packmenu")
public class Slideshow {
    private static long ticks = 0L;
    private static int index = 0;
    private static boolean fading = false;
    private static boolean finished = false;

    public static void render(ExtendedMenuScreen screen, GuiGraphics gfx, float partialTicks) {
        if (!PackMenu.slideshowRepeat && finished) {
            gfx.blit(PackMenu.slideshowTextures.get(index), 0, 0, screen.width, screen.height, 0.0f, 0.0f, 16, 128, 16, 128);
            return;
        }
        gfx.blit(PackMenu.slideshowTextures.get(index), 0, 0, screen.width, screen.height, 0.0f, 0.0f, 16, 128, 16, 128);
        if (fading) {
            RenderSystem.enableBlend();
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)PackMenu.slideshowTextures.get(Slideshow.nextIndex()));
            ClientUtil.colorBlit((PoseStack)gfx.pose(), (int)0, (int)0, (int)screen.width, (int)screen.height, (float)0.0f, (float)0.0f, (int)16, (int)128, (int)16, (int)128, (int)(Slideshow.getAlphaFade(partialTicks) << 24 | 0xFFFFFF));
            RenderSystem.disableBlend();
        }
    }

    @SubscribeEvent
    public static void tick(ClientTickEvent.Post e) {
        if (Minecraft.getInstance().screen instanceof ExtendedMenuScreen && !finished) {
            boolean wasFading = fading;
            boolean bl = fading = ++ticks % (long)(PackMenu.slideshowDuration + PackMenu.slideshowTransition) >= (long)PackMenu.slideshowDuration;
            if (wasFading && !fading && (index = Slideshow.nextIndex()) == PackMenu.slideshowTextures.size() - 1) {
                finished = true;
            }
        }
    }

    public static void reset() {
        ticks = 0L;
        index = 0;
        fading = false;
        finished = false;
    }

    public static int nextIndex() {
        return index + 1 == PackMenu.slideshowTextures.size() ? 0 : index + 1;
    }

    public static int getAlphaFade(float partial) {
        float counterProgress = ((float)ticks + partial) % (float)(PackMenu.slideshowDuration + PackMenu.slideshowTransition) - (float)PackMenu.slideshowDuration;
        float durationTeiler = 1.0f / (float)PackMenu.slideshowTransition;
        float alpha = durationTeiler * counterProgress;
        return (int)(255.0f * alpha);
    }
}

