/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.packmenu.gui;

import dev.shadowsoffire.packmenu.PackMenu;
import dev.shadowsoffire.packmenu.reload.Supporters;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ClientTickEvent;

@EventBusSubscriber(value={Dist.CLIENT}, modid="packmenu")
public class SupporterScreen
extends Screen {
    public static final String PM_PATREON = "https://discord.shadowsoffire.dev/landing";
    protected final Screen parent;
    protected static final Int2IntMap colorFades = new Int2IntOpenHashMap();
    protected static long ticks = 0L;
    protected final Random rand = new Random();
    protected final Component patreon;
    protected final Component patreon2;
    protected final Component patreon3;

    public SupporterScreen(Screen parent) {
        super((Component)Component.translatable((String)"packmenu.supporters"));
        this.parent = parent;
        colorFades.defaultReturnValue(-1);
        this.patreon = Component.translatable((String)"packmenu.support.modpack").withStyle(Style.EMPTY.withClickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, PackMenu.patreonUrl)));
        this.patreon2 = Component.translatable((String)"packmenu.support").withStyle(Style.EMPTY.withClickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, PM_PATREON)));
        this.patreon3 = Component.translatable((String)"packmenu.support1");
    }

    protected void init() {
        this.addRenderableWidget((GuiEventListener)new Button.Builder(CommonComponents.GUI_BACK, p_213056_1_ -> this.minecraft.setScreen(this.parent)).bounds(5, this.height - 25, 40, 20).build());
    }

    protected boolean isBigLinkHovered(int mouseX, int mouseY) {
        int texWidth = this.font.width((FormattedText)this.patreon);
        Objects.requireNonNull(this.font);
        return mouseY > this.height - 9 * 2 - 5 && mouseY < this.height - 5 && mouseX > this.width / 2 - texWidth && mouseX < this.width / 2 + texWidth;
    }

    protected boolean isTinyLinkHovered(int mouseX, int mouseY) {
        int texWidth = this.font.width((FormattedText)this.patreon3);
        Objects.requireNonNull(this.font);
        return mouseY > this.height - 9 * 2 - 5 && mouseY < this.height - 5 && mouseX > this.width - texWidth - 5 && mouseX < this.width - 5;
    }

    public void render(GuiGraphics gfx, int mouseX, int mouseY, float partialTicks) {
        super.render(gfx, mouseX, mouseY, partialTicks);
        gfx.pose().scale(2.0f, 2.0f, 2.0f);
        gfx.drawString(this.font, this.title, (this.width / 2 - this.font.width((FormattedText)this.title)) / 2, 5, 0xEEEEEE, true);
        int n = (this.width / 2 - this.font.width((FormattedText)this.patreon)) / 2;
        Objects.requireNonNull(this.font);
        gfx.drawString(this.font, this.patreon, n, (this.height - 9 * 2 - 5) / 2, (this.isBigLinkHovered(mouseX, mouseY) ? ChatFormatting.RED.getColor() : ChatFormatting.DARK_RED.getColor()).intValue(), true);
        gfx.pose().scale(0.5f, 0.5f, 0.5f);
        int color = this.isTinyLinkHovered(mouseX, mouseY) ? 0x33BB33 : 39168;
        int n2 = this.width - this.font.width((FormattedText)this.patreon2) / 2 - this.font.width((FormattedText)this.patreon3) / 2 - 5;
        Objects.requireNonNull(this.font);
        gfx.drawString(this.font, this.patreon2, n2, this.height - 9 * 2 - 5, color, true);
        int n3 = this.width - this.font.width((FormattedText)this.patreon3) - 5;
        Objects.requireNonNull(this.font);
        Objects.requireNonNull(this.font);
        gfx.drawString(this.font, this.patreon3, n3, this.height - 9 * 2 - 5 + 9, color, true);
        List<String> names = Supporters.INSTANCE.getSupporters();
        int width = (int)((double)this.width * 0.66);
        int strWidth = 0;
        int renders = 3;
        MutableComponent rendering = Component.literal((String)"");
        for (int i = 0; i < names.size(); ++i) {
            String s = names.get(i);
            strWidth = this.font.width((FormattedText)(rendering = Component.translatable((String)"%s %s", (Object[])new Object[]{rendering, this.comp(i, s + "    ")})));
            if (strWidth >= width) {
                int n4 = this.width / 2 - strWidth / 2;
                int n5 = renders++;
                Objects.requireNonNull(this.font);
                gfx.drawString(this.font, (Component)rendering, n4, n5 * (2 + 9), 0xCCCCCC, true);
                rendering = Component.literal((String)"");
                continue;
            }
            if (i != names.size() - 1) continue;
            int n6 = this.width / 2 - strWidth / 2;
            int n7 = renders++;
            Objects.requireNonNull(this.font);
            gfx.drawString(this.font, (Component)rendering, n6, n7 * (2 + 9), 0xCCCCCC, true);
        }
    }

    public boolean mouseClicked(double pMouseX, double pMouseY, int pButton) {
        if (this.isBigLinkHovered((int)Math.round(pMouseX), (int)Math.round(pMouseY))) {
            return this.handleComponentClicked(this.patreon.getStyle());
        }
        if (this.isTinyLinkHovered((int)Math.round(pMouseX), (int)Math.round(pMouseY))) {
            return this.handleComponentClicked(this.patreon2.getStyle());
        }
        return super.mouseClicked(pMouseX, pMouseY, pButton);
    }

    Component comp(int index, String s) {
        MutableComponent comp = Component.literal((String)s);
        if (colorFades.get(index) != -1) {
            int color = colorFades.get(index);
            return comp.withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)color)));
        }
        if (this.rand.nextInt(1600) == 0) {
            colorFades.put(index, 0x9999FF);
        }
        return comp;
    }

    static int step(int color) {
        return color + 65792 - 1;
    }

    @SubscribeEvent
    public static void tickFades(ClientTickEvent.Post e) {
        colorFades.replaceAll((k, v) -> v == -1 || SupporterScreen.step(v) == 0xCCCCCC ? -1 : SupporterScreen.step(v));
    }
}

