/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.loading.math;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

public record Operator(String symbol, int precedence, Operation operation) implements Comparable<Operator>
{
    private static final Map<String, Operator> OPERATORS = new HashMap<String, Operator>(14);
    public static final Operator ADD = Operator.register("+", 1, (a, b) -> a + b);
    public static final Operator SUB = Operator.register("-", 1, (a, b) -> a - b);
    public static final Operator MUL = Operator.register("*", 2, (a, b) -> a * b);
    public static final Operator DIV = Operator.register("/", 2, (a, b) -> b == 0.0 ? a : a / b);
    public static final Operator MOD = Operator.register("%", 2, (a, b) -> b == 0.0 ? a : a % b);
    public static final Operator POW = Operator.register("^", 3, Math::pow);
    public static final Operator AND = Operator.register("&&", 5, (a, b) -> a != 0.0 && b != 0.0 ? 1.0 : 0.0);
    public static final Operator OR = Operator.register("||", 5, (a, b) -> a != 0.0 || b != 0.0 ? 1.0 : 0.0);
    public static final Operator LT = Operator.register("<", 5, (a, b) -> a < b ? 1.0 : 0.0);
    public static final Operator LTE = Operator.register("<=", 5, (a, b) -> a <= b ? 1.0 : 0.0);
    public static final Operator GT = Operator.register(">", 5, (a, b) -> a > b ? 1.0 : 0.0);
    public static final Operator GTE = Operator.register(">=", 5, (a, b) -> a >= b ? 1.0 : 0.0);
    public static final Operator EQUAL = Operator.register("==", 5, (a, b) -> Math.abs(a - b) < 1.0E-5 ? 1.0 : 0.0);
    public static final Operator NOT_EQUAL = Operator.register("!=", 5, (a, b) -> Math.abs(a - b) >= 1.0E-5 ? 1.0 : 0.0);
    public static final Operator ASSIGN_VARIABLE = Operator.register("=", Integer.MAX_VALUE, (a, b) -> 0.0);

    public static Operator register(String symbol, int precedence, Operation operation) {
        Operator operator = new Operator(symbol, precedence, operation);
        if (OPERATORS.put(symbol, operator) != null) {
            throw new IllegalArgumentException("Attempting to register an already existing operator! '" + symbol + "'");
        }
        return operator;
    }

    public static boolean isOperator(String symbol) {
        return OPERATORS.containsKey(symbol);
    }

    public static Optional<Operator> getOperatorFor(String symbol) {
        return Optional.ofNullable(OPERATORS.get(symbol));
    }

    public double compute(double argA, double argB) {
        return this.operation.compute(argA, argB);
    }

    @Override
    public int compareTo(@NotNull Operator operator) {
        return Integer.compare(this.precedence, operator.precedence);
    }

    public boolean takesPrecedenceOver(Operator operator) {
        return this.compareTo(operator) > 0;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.symbol);
    }

    @FunctionalInterface
    public static interface Operation {
        public double compute(double var1, double var3);
    }
}

