/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.cache.texture;

import com.mojang.blaze3d.pipeline.RenderCall;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.resources.metadata.texture.TextureMetadataSection;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.metadata.MetadataSectionSerializer;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.GeckoLibConstants;
import software.bernie.geckolib.GeckoLibServices;
import software.bernie.geckolib.cache.texture.GeoAbstractTexture;
import software.bernie.geckolib.resource.GeoGlowingTextureMeta;

public class AutoGlowingTexture
extends GeoAbstractTexture {
    private static final RenderStateShard.ShaderStateShard SHADER_STATE = new RenderStateShard.ShaderStateShard(GameRenderer::getRendertypeEntityTranslucentEmissiveShader);
    private static final RenderStateShard.TransparencyStateShard TRANSPARENCY_STATE = new RenderStateShard.TransparencyStateShard("translucent_transparency", () -> {
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
    }, () -> {
        RenderSystem.disableBlend();
        RenderSystem.defaultBlendFunc();
    });
    private static final RenderStateShard.WriteMaskStateShard WRITE_MASK = new RenderStateShard.WriteMaskStateShard(true, true);
    private static final Function<ResourceLocation, RenderType> RENDER_TYPE_FUNCTION = Util.memoize(texture -> {
        RenderStateShard.TextureStateShard textureState = new RenderStateShard.TextureStateShard(texture, false, false);
        return RenderType.create((String)"geo_glowing_layer", (VertexFormat)DefaultVertexFormat.NEW_ENTITY, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)false, (boolean)true, (RenderType.CompositeState)RenderType.CompositeState.builder().setShaderState(SHADER_STATE).setTextureState((RenderStateShard.EmptyTextureStateShard)textureState).setTransparencyState(TRANSPARENCY_STATE).setWriteMaskState(WRITE_MASK).createCompositeState(false));
    });
    private static final String APPENDIX = "_glowmask";
    public static boolean PRINT_DEBUG_IMAGES = false;
    protected final ResourceLocation textureBase;
    protected final ResourceLocation glowLayer;

    public AutoGlowingTexture(ResourceLocation originalLocation, ResourceLocation location) {
        this.textureBase = originalLocation;
        this.glowLayer = location;
    }

    public static ResourceLocation getEmissiveResource(ResourceLocation baseResource) {
        ResourceLocation path = AutoGlowingTexture.appendToPath(baseResource, APPENDIX);
        AutoGlowingTexture.generateTexture(path, textureManager -> textureManager.register(path, (AbstractTexture)new AutoGlowingTexture(baseResource, path)));
        return path;
    }

    @Override
    @Nullable
    protected RenderCall loadTexture(ResourceManager resourceManager, Minecraft mc) throws IOException {
        NativeImage nativeImage;
        AbstractTexture originalTexture;
        try {
            originalTexture = (AbstractTexture)mc.submit(() -> mc.getTextureManager().getTexture(this.textureBase)).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new IOException("Failed to load original texture: " + String.valueOf(this.textureBase), e);
        }
        Resource textureBaseResource = (Resource)resourceManager.getResource(this.textureBase).get();
        if (originalTexture instanceof DynamicTexture) {
            DynamicTexture dynamicTexture = (DynamicTexture)originalTexture;
            nativeImage = dynamicTexture.getPixels();
        } else {
            nativeImage = NativeImage.read((InputStream)textureBaseResource.open());
        }
        NativeImage baseImage = nativeImage;
        NativeImage glowImage = null;
        Optional textureBaseMeta = textureBaseResource.metadata().getSection((MetadataSectionSerializer)TextureMetadataSection.SERIALIZER);
        boolean blur = textureBaseMeta.isPresent() && ((TextureMetadataSection)textureBaseMeta.get()).isBlur();
        boolean clamp = textureBaseMeta.isPresent() && ((TextureMetadataSection)textureBaseMeta.get()).isClamp();
        try {
            Optional glowLayerResource = resourceManager.getResource(this.glowLayer);
            GeoGlowingTextureMeta glowLayerMeta = null;
            if (glowLayerResource.isPresent()) {
                glowImage = NativeImage.read((InputStream)((Resource)glowLayerResource.get()).open());
                glowLayerMeta = GeoGlowingTextureMeta.fromExistingImage(glowImage);
            } else {
                Optional meta = textureBaseResource.metadata().getSection(GeoGlowingTextureMeta.DESERIALIZER);
                if (meta.isPresent()) {
                    glowLayerMeta = (GeoGlowingTextureMeta)meta.get();
                    glowImage = new NativeImage(baseImage.getWidth(), baseImage.getHeight(), true);
                }
            }
            if (glowLayerMeta != null) {
                glowLayerMeta.createImageMask(baseImage, glowImage);
                if (PRINT_DEBUG_IMAGES && GeckoLibServices.PLATFORM.isDevelopmentEnvironment()) {
                    this.printDebugImageToDisk(this.textureBase, baseImage);
                    this.printDebugImageToDisk(this.glowLayer, glowImage);
                }
            }
        }
        catch (IOException e) {
            GeckoLibConstants.LOGGER.warn("Resource failed to open for glowlayer meta: {}", (Object)this.glowLayer, (Object)e);
        }
        NativeImage mask = glowImage;
        if (mask == null) {
            return null;
        }
        return () -> {
            AutoGlowingTexture.uploadSimple(this.getId(), mask, blur, clamp);
            if (originalTexture instanceof DynamicTexture) {
                DynamicTexture dynamicTexture = (DynamicTexture)originalTexture;
                dynamicTexture.upload();
            } else {
                AutoGlowingTexture.uploadSimple(originalTexture.getId(), baseImage, blur, clamp);
            }
        };
    }

    public static RenderType getRenderType(ResourceLocation texture) {
        return RENDER_TYPE_FUNCTION.apply(AutoGlowingTexture.getEmissiveResource(texture));
    }
}

