/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.animatable;

import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.GeckoLibConstants;
import software.bernie.geckolib.GeckoLibServices;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.constant.dataticket.SerializableDataTicket;
import software.bernie.geckolib.util.RenderUtil;

public interface GeoBlockEntity
extends GeoAnimatable {
    @ApiStatus.NonExtendable
    @Nullable
    default public <D> D getAnimData(SerializableDataTicket<D> dataTicket) {
        return this.getAnimatableInstanceCache().getManagerForId(0L).getData(dataTicket);
    }

    @ApiStatus.NonExtendable
    default public <D> void setAnimData(SerializableDataTicket<D> dataTicket, D data) {
        BlockEntity blockEntity = (BlockEntity)this;
        Level level = blockEntity.getLevel();
        if (level == null) {
            GeckoLibConstants.LOGGER.error("Attempting to set animation data for BlockEntity too early! Must wait until after the BlockEntity has been set in the world. (" + blockEntity.getClass().toString() + ")");
            return;
        }
        if (level.isClientSide()) {
            this.getAnimatableInstanceCache().getManagerForId(0L).setData(dataTicket, data);
        } else {
            GeckoLibServices.NETWORK.syncBlockEntityAnimData(blockEntity.getBlockPos(), dataTicket, data, (ServerLevel)level);
        }
    }

    @ApiStatus.NonExtendable
    default public void triggerAnim(@Nullable String controllerName, String animName) {
        BlockEntity blockEntity = (BlockEntity)this;
        Level level = blockEntity.getLevel();
        if (level == null) {
            GeckoLibConstants.LOGGER.error("Attempting to trigger an animation for a BlockEntity too early! Must wait until after the BlockEntity has been set in the world. (" + blockEntity.getClass().toString() + ")");
            return;
        }
        if (level.isClientSide()) {
            this.getAnimatableInstanceCache().getManagerForId(0L).tryTriggerAnimation(controllerName, animName);
        } else {
            GeckoLibServices.NETWORK.triggerBlockEntityAnim(blockEntity.getBlockPos(), controllerName, animName, (ServerLevel)level);
        }
    }

    @Override
    default public double getTick(Object blockEntity) {
        return RenderUtil.getCurrentTick();
    }
}

