/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.aquaculture.item.crafting;

import com.teammetallurgy.aquaculture.api.AquacultureAPI;
import com.teammetallurgy.aquaculture.api.fish.FishData;
import com.teammetallurgy.aquaculture.init.AquaDataComponents;
import com.teammetallurgy.aquaculture.init.AquaItems;
import com.teammetallurgy.aquaculture.init.AquaRecipeSerializers;
import com.teammetallurgy.aquaculture.misc.AquaConfig;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.server.ServerLifecycleHooks;

public class FishFilletRecipe
extends CustomRecipe {
    public FishFilletRecipe(CraftingBookCategory craftingBookCategory) {
        super(craftingBookCategory);
    }

    public boolean matches(@Nonnull CraftingInput craftingInventory, @Nonnull Level world) {
        ItemStack stack = ItemStack.EMPTY;
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        for (int i = 0; i < craftingInventory.size(); ++i) {
            ItemStack slotStack = craftingInventory.getItem(i);
            if (slotStack.isEmpty()) continue;
            if (AquacultureAPI.FISH_DATA.hasFilletAmount(slotStack.getItem())) {
                if (!stack.isEmpty()) {
                    return false;
                }
                stack = slotStack;
                continue;
            }
            if (!slotStack.is(AquacultureAPI.Tags.KNIVES) || !slotStack.isDamageableItem() && !FishFilletRecipe.isKnifeNeptunium(slotStack.getItem()) || !(slotStack.getItem() instanceof TieredItem)) {
                return false;
            }
            list.add(slotStack);
        }
        return !stack.isEmpty() && !list.isEmpty();
    }

    @Nonnull
    public ItemStack assemble(@Nonnull CraftingInput craftingInventory, @Nonnull HolderLookup.Provider provider) {
        ItemStack fish = ItemStack.EMPTY;
        Item knife = null;
        for (int i = 0; i < craftingInventory.size(); ++i) {
            ItemStack stackSlot = craftingInventory.getItem(i);
            if (stackSlot.isEmpty()) continue;
            Item item = stackSlot.getItem();
            if (AquacultureAPI.FISH_DATA.hasFilletAmount(item)) {
                if (!fish.isEmpty()) {
                    return ItemStack.EMPTY;
                }
                fish = stackSlot.copy();
                continue;
            }
            if (!stackSlot.is(AquacultureAPI.Tags.KNIVES)) {
                return ItemStack.EMPTY;
            }
            knife = item;
        }
        if (!fish.isEmpty() && knife != null) {
            int filletAmount = AquacultureAPI.FISH_DATA.getFilletAmount(fish.getItem());
            Float fishWeight = (Float)fish.get((DataComponentType)AquaDataComponents.FISH_WEIGHT.get());
            if (((Boolean)AquaConfig.BASIC_OPTIONS.randomWeight.get()).booleanValue() && fish.has(AquaDataComponents.FISH_WEIGHT) && fishWeight != null) {
                filletAmount = FishData.getFilletAmountFromWeight(fishWeight.floatValue());
            }
            if (FishFilletRecipe.isKnifeNeptunium(knife)) {
                filletAmount = (int)((float)filletAmount + (float)filletAmount * 0.25f);
            }
            return new ItemStack((ItemLike)AquaItems.FISH_FILLET.get(), filletAmount);
        }
        return ItemStack.EMPTY;
    }

    @Nonnull
    public NonNullList<ItemStack> getRemainingItems(CraftingInput craftingInventory) {
        NonNullList list = NonNullList.withSize((int)craftingInventory.size(), (Object)ItemStack.EMPTY);
        for (int i = 0; i < list.size(); ++i) {
            MinecraftServer server;
            ItemStack stack = craftingInventory.getItem(i);
            if (!stack.is(AquacultureAPI.Tags.KNIVES)) continue;
            ItemStack knife = stack.copy();
            if (!FishFilletRecipe.isKnifeNeptunium(knife.getItem()) && (server = ServerLifecycleHooks.getCurrentServer()) != null) {
                knife.hurtAndBreak(1, server.overworld(), null, item -> knife.shrink(1));
            }
            list.set(i, (Object)knife);
        }
        return list;
    }

    public static boolean isKnifeNeptunium(@Nonnull Item knife) {
        return knife instanceof TieredItem && ((TieredItem)knife).getTier() == AquacultureAPI.MATS.NEPTUNIUM;
    }

    @Nonnull
    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)AquaRecipeSerializers.FISH_FILLET_SERIALIZER.get();
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width * height >= 2;
    }
}

