/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.aquaculture.item;

import com.teammetallurgy.aquaculture.api.AquacultureAPI;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.common.ItemAbilities;
import net.neoforged.neoforge.common.ItemAbility;

public class ItemFilletKnife
extends SwordItem {
    public ItemFilletKnife(Tier tier) {
        super(tier, new Item.Properties().durability(tier == AquacultureAPI.MATS.NEPTUNIUM ? -1 : (int)((float)tier.getUses() * 0.75f)).attributes(SwordItem.createAttributes((Tier)tier, (float)(tier.getAttackDamageBonus() / 2.0f), (float)-2.2f)));
    }

    public boolean isPrimaryItemFor(@Nonnull ItemStack stack, @Nonnull Holder<Enchantment> enchantment) {
        return super.isPrimaryItemFor(stack, enchantment) && this.canApplyEnchantment(enchantment);
    }

    private boolean canApplyEnchantment(Holder<Enchantment> enchantment) {
        return enchantment != Enchantments.LOOTING && enchantment != Enchantments.SWEEPING_EDGE;
    }

    public boolean canPerformAction(@Nonnull ItemStack stack, @Nonnull ItemAbility toolAction) {
        return toolAction == ItemAbilities.SWORD_DIG;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(@Nonnull ItemStack stack, @Nonnull Item.TooltipContext tooltipContext, @Nonnull List<Component> tooltip, @Nonnull TooltipFlag tooltipFlag) {
        if (this.getTier() == AquacultureAPI.MATS.NEPTUNIUM) {
            MutableComponent unbreakable = Component.translatable((String)"aquaculture.unbreakable");
            tooltip.add((Component)unbreakable.withStyle(unbreakable.getStyle().withColor(ChatFormatting.DARK_GRAY).withBold(Boolean.valueOf(true))));
        }
        super.appendHoverText(stack, tooltipContext, tooltip, tooltipFlag);
    }
}

