/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.aquaculture.inventory.container;

import com.teammetallurgy.aquaculture.api.AquacultureAPI;
import com.teammetallurgy.aquaculture.block.blockentity.TackleBoxBlockEntity;
import com.teammetallurgy.aquaculture.init.AquaBlocks;
import com.teammetallurgy.aquaculture.init.AquaGuis;
import com.teammetallurgy.aquaculture.inventory.container.slot.SlotFishingRod;
import com.teammetallurgy.aquaculture.inventory.container.slot.SlotHidable;
import com.teammetallurgy.aquaculture.item.BaitItem;
import com.teammetallurgy.aquaculture.item.HookItem;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.SlotItemHandler;

public class TackleBoxContainer
extends AbstractContainerMenu {
    public TackleBoxBlockEntity tackleBox;
    private int rows = 4;
    private int collumns = 4;
    public Slot slotHook;
    public Slot slotBait;
    public Slot slotLine;
    public Slot slotBobber;

    public TackleBoxContainer(int windowID, BlockPos pos, Inventory playerInventory) {
        super((MenuType)AquaGuis.TACKLE_BOX.get(), windowID);
        Player player = playerInventory.player;
        this.tackleBox = (TackleBoxBlockEntity)player.level().getBlockEntity(pos);
        if (this.tackleBox != null) {
            int row;
            int column;
            this.tackleBox.startOpen(player);
            IItemHandler tackleBoxCapability = (IItemHandler)player.level().getCapability(Capabilities.ItemHandler.BLOCK, pos, null);
            if (tackleBoxCapability != null) {
                SlotFishingRod fishingRodSlot = (SlotFishingRod)this.addSlot((Slot)new SlotFishingRod(tackleBoxCapability, 0, 117, 21));
                this.slotHook = this.addSlot((Slot)new SlotHidable(this, fishingRodSlot, 0, 106, 44){

                    @Override
                    public boolean mayPlace(@Nonnull ItemStack stack) {
                        return stack.getItem() instanceof HookItem && super.mayPlace(stack);
                    }
                });
                this.slotBait = this.addSlot((Slot)new SlotHidable(this, fishingRodSlot, 1, 129, 44){

                    @Override
                    public boolean mayPlace(@Nonnull ItemStack stack) {
                        return stack.getItem() instanceof BaitItem && super.mayPlace(stack);
                    }

                    @Override
                    public boolean mayPickup(Player player) {
                        return false;
                    }
                });
                this.slotLine = this.addSlot((Slot)new SlotHidable(this, fishingRodSlot, 2, 106, 67){

                    @Override
                    public boolean mayPlace(@Nonnull ItemStack stack) {
                        boolean isDyeable = stack.is(ItemTags.DYEABLE);
                        return stack.is(AquacultureAPI.Tags.FISHING_LINE) && isDyeable && super.mayPlace(stack);
                    }
                });
                this.slotBobber = this.addSlot((Slot)new SlotHidable(this, fishingRodSlot, 3, 129, 67){

                    @Override
                    public boolean mayPlace(@Nonnull ItemStack stack) {
                        boolean isDyeable = stack.is(ItemTags.DYEABLE);
                        return stack.is(AquacultureAPI.Tags.BOBBER) && isDyeable && super.mayPlace(stack);
                    }
                });
            }
            for (column = 0; column < this.collumns; ++column) {
                for (row = 0; row < this.rows; ++row) {
                    this.addSlot((Slot)new SlotItemHandler(this, tackleBoxCapability, 1 + row + column * this.collumns, 8 + row * 18, 8 + column * 18){

                        public boolean mayPlace(@Nonnull ItemStack stack) {
                            return TackleBoxBlockEntity.canBePutInTackleBox(stack);
                        }
                    });
                }
            }
            for (column = 0; column < 3; ++column) {
                for (row = 0; row < 9; ++row) {
                    this.addSlot(new Slot((Container)playerInventory, row + column * 9 + 9, 8 + row * 18, 90 + column * 18));
                }
            }
            for (int row2 = 0; row2 < 9; ++row2) {
                this.addSlot(new Slot((Container)playerInventory, row2, 8 + row2 * 18, 148));
            }
        }
    }

    public boolean stillValid(@Nonnull Player player) {
        return TackleBoxContainer.stillValid((ContainerLevelAccess)ContainerLevelAccess.create((Level)Objects.requireNonNull(this.tackleBox.getLevel()), (BlockPos)this.tackleBox.getBlockPos()), (Player)player, (Block)((Block)AquaBlocks.TACKLE_BOX.get()));
    }

    @Nonnull
    public ItemStack quickMoveStack(@Nonnull Player player, int index) {
        ItemStack transferStack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot != null && slot.hasItem()) {
            ItemStack slotStack = slot.getItem();
            transferStack = slotStack.copy();
            if (index < this.rows * this.collumns ? !this.moveItemStackTo(slotStack, this.rows * this.collumns, this.slots.size(), true) : !this.moveItemStackTo(slotStack, 0, this.rows * this.collumns, false)) {
                return ItemStack.EMPTY;
            }
            if (slotStack.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
        }
        return transferStack;
    }

    public void removed(@Nonnull Player player) {
        super.removed(player);
        this.tackleBox.stopOpen(player);
    }

    public void clicked(int slotId, int dragType, @Nonnull ClickType clickType, @Nonnull Player player) {
        ItemStack mouseStack;
        SlotItemHandler slotHandler;
        Slot slot;
        if (slotId >= 0 && clickType == ClickType.PICKUP && (slot = (Slot)this.slots.get(slotId)) == this.slotBait && (slotHandler = (SlotItemHandler)slot).mayPlace(mouseStack = player.containerMenu.getCarried()) && (slot.getItem().isDamaged() || slot.getItem().isEmpty() || slot.getItem().getItem() != mouseStack.getItem())) {
            slotHandler.set(ItemStack.EMPTY);
        }
        super.clicked(slotId, dragType, clickType, player);
    }
}

