/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.aquaculture.integration.jei.recipes;

import com.teammetallurgy.aquaculture.api.AquacultureAPI;
import com.teammetallurgy.aquaculture.init.AquaItems;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.level.ItemLike;

public class FilletKnifeRecipeMaker {
    public static List<RecipeHolder<CraftingRecipe>> createFilletKnifeRecipes() {
        ArrayList<RecipeHolder<CraftingRecipe>> recipes = new ArrayList<RecipeHolder<CraftingRecipe>>();
        for (Item fish : AquacultureAPI.FISH_DATA.getFish()) {
            TagKey<Item> filletKnifeTag = AquacultureAPI.Tags.KNIVES;
            NonNullList input = NonNullList.of((Object)Ingredient.EMPTY, (Object[])new Ingredient[]{Ingredient.of(filletKnifeTag), Ingredient.of((ItemLike[])new ItemLike[]{fish})});
            if (!AquacultureAPI.FISH_DATA.hasFilletAmount(fish)) continue;
            ItemStack output = new ItemStack((ItemLike)AquaItems.FISH_FILLET.get(), AquacultureAPI.FISH_DATA.getFilletAmount(fish));
            ResourceLocation itemID = BuiltInRegistries.ITEM.getKey((Object)fish);
            if (itemID == null) continue;
            ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)"aquaculture", (String)("fish_fillet." + itemID.getPath()));
            ShapelessRecipe recipe = new ShapelessRecipe("aquaculture.fish_fillet", CraftingBookCategory.MISC, output, input);
            recipes.add((RecipeHolder<CraftingRecipe>)new RecipeHolder(id, (Recipe)recipe));
        }
        return recipes;
    }
}

