/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.aquaculture.api;

import com.teammetallurgy.aquaculture.init.AquaItems;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.registries.DeferredRegister;

public class AquaArmorMaterials {
    public static final DeferredRegister<ArmorMaterial> ARMOR_MATERIAL_DEFERRED = DeferredRegister.create((ResourceKey)Registries.ARMOR_MATERIAL, (String)"aquaculture");
    public static Holder<ArmorMaterial> NEPTUNIUM = AquaArmorMaterials.register("neptunium", (EnumMap)Util.make(new EnumMap(ArmorItem.Type.class), map -> {
        map.put(ArmorItem.Type.BOOTS, 3);
        map.put(ArmorItem.Type.LEGGINGS, 6);
        map.put(ArmorItem.Type.CHESTPLATE, 8);
        map.put(ArmorItem.Type.HELMET, 3);
        map.put(ArmorItem.Type.HELMET, 11);
    }), 14, (Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_DIAMOND, 2.0f, 0.0f, () -> Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)AquaItems.NEPTUNIUM_INGOT.get()}));

    public static Holder<ArmorMaterial> register(String name, EnumMap<ArmorItem.Type, Integer> defense, int enchantmentValue, Holder<SoundEvent> equipSound, float toughness, float knockbackResistance, Supplier<Ingredient> repairIngredient) {
        EnumMap<ArmorItem.Type, Integer> armorTypeMap = new EnumMap<ArmorItem.Type, Integer>(ArmorItem.Type.class);
        ResourceLocation location = ResourceLocation.fromNamespaceAndPath((String)"aquaculture", (String)name);
        for (ArmorItem.Type armoritem$type : ArmorItem.Type.values()) {
            armorTypeMap.put(armoritem$type, defense.get(armoritem$type));
        }
        List<ArmorMaterial.Layer> list = List.of(new ArmorMaterial.Layer(location));
        return ARMOR_MATERIAL_DEFERRED.register(name, () -> new ArmorMaterial((Map)armorTypeMap, enchantmentValue, equipSound, repairIngredient, list, toughness, knockbackResistance));
    }
}

