/*
 * Decompiled with CFR 0.152.
 */
package net.commoble.jumbofurnace.client.emi;

import dev.emi.emi.api.EmiEntrypoint;
import dev.emi.emi.api.EmiPlugin;
import dev.emi.emi.api.EmiRegistry;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.render.EmiRenderable;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import net.commoble.jumbofurnace.JumboFurnace;
import net.commoble.jumbofurnace.client.emi.JumboSmeltingEmiRecipe;
import net.commoble.jumbofurnace.recipes.JumboFurnaceRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.level.ItemLike;

@EmiEntrypoint
public class EmiProxy
implements EmiPlugin {
    public static final EmiStack JUMBO_FURNACE_ICON = EmiStack.of((ItemLike)((ItemLike)JumboFurnace.get().jumboFurnaceJeiDummy.get()));
    public static final EmiRecipeCategory JUMBO_SMELTING_CATEGORY = new EmiRecipeCategory(JumboFurnace.get().jumboSmeltingRecipeSerializer.getId(), (EmiRenderable)JUMBO_FURNACE_ICON);

    public void register(EmiRegistry registry) {
        registry.addCategory(JUMBO_SMELTING_CATEGORY);
        registry.addWorkstation(JUMBO_SMELTING_CATEGORY, (EmiIngredient)JUMBO_FURNACE_ICON);
        RecipeManager recipeManager = registry.getRecipeManager();
        for (RecipeHolder recipe : recipeManager.getAllRecipesFor(RecipeType.SMELTING)) {
            registry.addRecipe((EmiRecipe)new JumboSmeltingEmiRecipe(EmiProxy.wrapId(recipe.id()), new JumboFurnaceRecipe((SmeltingRecipe)recipe.value())));
        }
        for (RecipeHolder recipe : recipeManager.getAllRecipesFor((RecipeType)JumboFurnace.get().jumboSmeltingRecipeType.get())) {
            registry.addRecipe((EmiRecipe)new JumboSmeltingEmiRecipe(recipe.id(), (JumboFurnaceRecipe)recipe.value()));
        }
    }

    static ResourceLocation wrapId(ResourceLocation original) {
        return ResourceLocation.fromNamespaceAndPath((String)original.getNamespace(), (String)String.format("/jumbo_smelting_wrapper/%s", original.getPath()));
    }
}

