/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.kleeslabs.converter;

import net.blay09.mods.kleeslabs.converter.SlabConverter;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;

public class SmartSlabConverter
implements SlabConverter {
    private final Block singleSlab;

    public SmartSlabConverter(Block singleSlab) {
        this.singleSlab = singleSlab;
    }

    @Override
    public BlockState getSingleSlab(BlockState state, Level level, BlockPos pos, Player player, SlabType slabType) {
        BlockState newState = this.singleSlab.defaultBlockState();
        for (Property property : state.getProperties()) {
            if (!newState.getProperties().contains(property)) continue;
            newState = this.copyProperty(state, newState, property);
        }
        return (BlockState)newState.setValue((Property)BlockStateProperties.SLAB_TYPE, (Comparable)slabType);
    }

    @Override
    public boolean isDoubleSlab(BlockState state) {
        return state.getValue((Property)BlockStateProperties.SLAB_TYPE) == SlabType.DOUBLE;
    }

    private <T extends Comparable<T>> BlockState copyProperty(BlockState sourceState, BlockState targetState, Property<T> property) {
        return (BlockState)targetState.setValue(property, sourceState.getValue(property));
    }
}

