/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.kleeslabs;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.blay09.mods.balm.api.event.server.ServerStartedEvent;
import net.blay09.mods.kleeslabs.KleeSlabsConfig;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SlabDumpHandler {
    private static final Logger log = LoggerFactory.getLogger(SlabDumpHandler.class);

    public static void onServerStarted(ServerStartedEvent event) {
        if (KleeSlabsConfig.getActive().dumpSlabs) {
            SlabDumpHandler.dumpSlabs();
        }
    }

    public static void dumpSlabs() {
        Map<String, List<ResourceLocation>> slabsByMod = BuiltInRegistries.BLOCK.keySet().stream().filter(itemName -> itemName.getPath().endsWith("_slab")).collect(Collectors.groupingBy(ResourceLocation::getNamespace));
        for (Map.Entry<String, List<ResourceLocation>> slabs : slabsByMod.entrySet()) {
            String slabsOutput = slabs.getValue().stream().map(ResourceLocation::getPath).map(it -> "\"" + it + "\"").sorted().collect(Collectors.joining(",\n"));
            log.info("Slabs from mod {}:\n{}", (Object)slabs.getKey(), (Object)slabsOutput);
        }
    }
}

