/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.kleeslabs;

import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.event.BreakBlockEvent;
import net.blay09.mods.balm.api.event.PlayerLoginEvent;
import net.blay09.mods.balm.api.event.server.ServerStartedEvent;
import net.blay09.mods.kleeslabs.BlockBreakHandler;
import net.blay09.mods.kleeslabs.KleeSlabsConfig;
import net.blay09.mods.kleeslabs.KleeSlabsMode;
import net.blay09.mods.kleeslabs.LoginSyncHandler;
import net.blay09.mods.kleeslabs.SlabDumpHandler;
import net.blay09.mods.kleeslabs.network.ModNetworking;
import net.blay09.mods.kleeslabs.registry.json.JsonCompatLoader;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.entity.player.Player;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class KleeSlabs {
    public static final String MOD_ID = "kleeslabs";
    public static final Logger logger = LogManager.getLogger();

    public static void initialize() {
        KleeSlabsConfig.initialize();
        ModNetworking.initialize(Balm.getNetworking());
        Balm.addServerReloadListener((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)"json_registry"), (PreparableReloadListener)new JsonCompatLoader());
        Balm.getEvents().onEvent(ServerStartedEvent.class, SlabDumpHandler::onServerStarted);
        Balm.getEvents().onEvent(PlayerLoginEvent.class, LoginSyncHandler::onPlayerLogin);
        Balm.getEvents().onEvent(BreakBlockEvent.class, BlockBreakHandler::onBreakBlock);
    }

    public static boolean isPlayerKleeSlabbing(Player player) {
        return switch (KleeSlabsConfig.getActive().mode) {
            default -> throw new MatchException(null, null);
            case KleeSlabsMode.ALWAYS -> true;
            case KleeSlabsMode.ONLY_WHEN_SNEAKING -> player.isShiftKeyDown();
            case KleeSlabsMode.ONLY_WHEN_NOT_SNEAKING -> !player.isShiftKeyDown();
        };
    }
}

