/*
 * Decompiled with CFR 0.152.
 */
package com.chaosthedude.notes.note;

import com.chaosthedude.notes.util.FileUtils;
import com.chaosthedude.notes.util.StringUtils;
import java.io.File;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.world.level.storage.LevelResource;

public class Scope {
    private static final Minecraft mc = Minecraft.getInstance();
    public static final Scope GLOBAL = new Scope("notes.scope.global", "global"){

        @Override
        public boolean isActive() {
            return true;
        }
    };
    public static final Scope LOCAL = new Scope("notes.scope.local", "local"){

        @Override
        public File getCurrentSaveDirectory() {
            File saveDirFile = new File(this.getRootSaveDirectory(), 2.getWorldName());
            if (!saveDirFile.exists()) {
                saveDirFile.mkdirs();
            }
            return saveDirFile;
        }

        @Override
        public boolean isActive() {
            return 2.isLocal();
        }
    };
    public static final Scope REMOTE = new Scope("notes.scope.remote", "remote"){

        @Override
        public File getCurrentSaveDirectory() {
            File saveDirFile = new File(this.getRootSaveDirectory(), 3.getServerIP());
            if (!saveDirFile.exists()) {
                saveDirFile.mkdirs();
            }
            return saveDirFile;
        }

        @Override
        public boolean isActive() {
            return 3.isLocal();
        }
    };
    private String unlocName;
    private String saveDir;

    public Scope(String unlocName, String saveDir) {
        this.unlocName = unlocName;
        this.saveDir = saveDir;
    }

    public String localize() {
        return I18n.get((String)this.unlocName, (Object[])new Object[0]);
    }

    public String format() {
        return "(" + this.localize() + ")";
    }

    public File getCurrentSaveDirectory() {
        return this.getRootSaveDirectory();
    }

    public File getRootSaveDirectory() {
        File saveDirFile = new File(FileUtils.getRootSaveDirectory(), this.saveDir);
        if (!saveDirFile.exists()) {
            saveDirFile.mkdirs();
        }
        return saveDirFile;
    }

    public boolean isActive() {
        return false;
    }

    public static Scope getCurrentScope() {
        if (Scope.isLocal()) {
            return LOCAL;
        }
        if (Scope.isRemote()) {
            return REMOTE;
        }
        return GLOBAL;
    }

    public static Scope getCurrentScopeOrGlobal(boolean global) {
        return global ? GLOBAL : Scope.getCurrentScope();
    }

    public static Scope getScopeFromParentFile(File parentFile) {
        if (LOCAL.getRootSaveDirectory().equals(parentFile.getParentFile())) {
            return LOCAL;
        }
        if (REMOTE.getRootSaveDirectory().equals(parentFile.getParentFile())) {
            return REMOTE;
        }
        return GLOBAL;
    }

    public static boolean currentScopeIsValid() {
        return Scope.getCurrentScope() != GLOBAL;
    }

    public static boolean isLocal() {
        return mc.isLocalServer();
    }

    public static boolean isRemote() {
        return mc.getCurrentServer() != null;
    }

    public static String getServerIP() {
        if (Scope.isRemote()) {
            return StringUtils.filterFileName(Scope.mc.getCurrentServer().ip);
        }
        return null;
    }

    public static String getWorldName() {
        if (Scope.isLocal()) {
            return StringUtils.filterFileName(mc.getSingleplayerServer().getWorldPath(LevelResource.ICON_FILE).getParent().getFileName().toString());
        }
        return null;
    }
}

