/*
 * Decompiled with CFR 0.152.
 */
package com.chaosthedude.notes.gui;

import com.chaosthedude.notes.gui.EditNoteScreen;
import com.chaosthedude.notes.gui.NotesButton;
import com.chaosthedude.notes.gui.NotesList;
import com.chaosthedude.notes.gui.NotesListEntry;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class SelectNoteScreen
extends Screen {
    private Screen prevScreen;
    private NotesButton newButton;
    private NotesButton selectButton;
    private NotesButton editButton;
    private NotesButton copyButton;
    private NotesButton deleteButton;
    private NotesButton pinButton;
    private NotesButton cancelButton;
    private NotesList selectionList;

    public SelectNoteScreen(Screen prevScreen) {
        super((Component)Component.translatable((String)"notes.selectNote"));
        this.prevScreen = prevScreen;
    }

    public void init() {
        this.setupButtons();
        this.selectionList = new NotesList(this, this.minecraft, this.width + 110, this.height, 40, 36);
        this.addRenderableWidget((GuiEventListener)this.selectionList);
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        guiGraphics.drawCenteredString(this.font, I18n.get((String)"notes.selectNote", (Object[])new Object[0]), this.width / 2 + 60, 15, 0xFFFFFF);
    }

    public void tick() {
        if (this.selectionList.getSelected() != null) {
            this.pinButton.setMessage((Component)(((NotesListEntry)this.selectionList.getSelected()).isPinned() ? Component.translatable((String)"notes.unpin") : Component.translatable((String)"notes.pin")));
        }
    }

    public void selectNote(NotesListEntry entry) {
        boolean enable;
        this.selectButton.active = enable = entry != null;
        this.deleteButton.active = enable;
        this.editButton.active = enable;
        this.copyButton.active = enable;
        this.pinButton.active = enable;
    }

    private void setupButtons() {
        this.newButton = (NotesButton)this.addRenderableWidget((GuiEventListener)new NotesButton(10, 40, 110, 20, (Component)Component.translatable((String)"notes.new"), onPress -> this.minecraft.setScreen((Screen)new EditNoteScreen(this, null))));
        this.selectButton = (NotesButton)this.addRenderableWidget((GuiEventListener)new NotesButton(10, 75, 110, 20, (Component)Component.translatable((String)"notes.select"), onPress -> {
            NotesListEntry notesEntry = (NotesListEntry)this.selectionList.getSelected();
            if (notesEntry != null) {
                notesEntry.loadNote();
            }
        }));
        this.editButton = (NotesButton)this.addRenderableWidget((GuiEventListener)new NotesButton(10, 100, 110, 20, (Component)Component.translatable((String)"notes.edit"), onPress -> {
            NotesListEntry notesEntry = (NotesListEntry)this.selectionList.getSelected();
            if (notesEntry != null) {
                notesEntry.editNote();
            }
        }));
        this.copyButton = (NotesButton)this.addRenderableWidget((GuiEventListener)new NotesButton(10, 125, 110, 20, (Component)Component.translatable((String)"notes.copy"), onPress -> {
            NotesListEntry notesEntry = (NotesListEntry)this.selectionList.getSelected();
            notesEntry.copyNote();
        }));
        this.deleteButton = (NotesButton)this.addRenderableWidget((GuiEventListener)new NotesButton(10, 150, 110, 20, (Component)Component.translatable((String)"notes.delete"), onPress -> {
            NotesListEntry notesEntry = (NotesListEntry)this.selectionList.getSelected();
            if (notesEntry != null) {
                notesEntry.deleteNote();
            }
        }));
        this.pinButton = (NotesButton)this.addRenderableWidget((GuiEventListener)new NotesButton(10, 175, 110, 20, (Component)Component.translatable((String)"notes.pin"), onPress -> {
            NotesListEntry notesEntry = (NotesListEntry)this.selectionList.getSelected();
            notesEntry.togglePin();
        }));
        this.cancelButton = (NotesButton)this.addRenderableWidget((GuiEventListener)new NotesButton(10, this.height - 30, 110, 20, (Component)Component.translatable((String)"gui.cancel"), onPress -> this.minecraft.setScreen(this.prevScreen)));
        this.selectButton.active = false;
        this.deleteButton.active = false;
        this.editButton.active = false;
        this.copyButton.active = false;
        this.pinButton.active = false;
    }
}

