/*
 * Decompiled with CFR 0.152.
 */
package com.chaosthedude.notes.gui;

import com.chaosthedude.notes.Notes;
import com.chaosthedude.notes.config.ConfigHandler;
import com.chaosthedude.notes.util.RenderUtils;
import java.util.List;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.LayeredDraw;
import net.minecraft.client.gui.screens.ChatScreen;
import net.minecraft.util.Mth;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class PinnedNoteLayer
implements LayeredDraw.Layer {
    private static final Minecraft CLIENT = Minecraft.getInstance();

    public void render(GuiGraphics guiGraphics, DeltaTracker deltaTracker) {
        if (!PinnedNoteLayer.CLIENT.options.hideGui && (PinnedNoteLayer.CLIENT.screen == null || PinnedNoteLayer.CLIENT.screen instanceof ChatScreen) && Notes.pinnedNote != null && Notes.pinnedNote.isValidScope()) {
            Notes.pinnedNote.update();
            int maxWidth = Mth.floor((double)((double)CLIENT.getWindow().getGuiScaledWidth() * (Double)ConfigHandler.CLIENT.pinnedWidthScale.get()));
            int maxHeight = Mth.floor((double)((double)CLIENT.getWindow().getGuiScaledHeight() * (Double)ConfigHandler.CLIENT.pinnedHeightScale.get()));
            String text = Notes.pinnedNote.getFilteredText();
            List<String> widthSplitLines = RenderUtils.splitStringToWidth(text, maxWidth);
            List<String> lines = RenderUtils.splitStringToHeight(widthSplitLines, maxHeight);
            if (widthSplitLines.size() > lines.size()) {
                String lastLine = lines.get(lines.size() - 1);
                lines.set(lines.size() - 1, RenderUtils.addEllipses(lastLine, maxWidth));
            }
            int renderWidth = RenderUtils.getSplitStringWidth(lines);
            int renderHeight = RenderUtils.getSplitStringHeight(lines);
            int renderX = RenderUtils.getPinnedNoteX((String)ConfigHandler.CLIENT.pinnedNotePosition.get(), renderWidth);
            int renderY = RenderUtils.getPinnedNoteY((String)ConfigHandler.CLIENT.pinnedNotePosition.get(), renderHeight);
            int opacity = (int)(255.0 * (Double)PinnedNoteLayer.CLIENT.options.textBackgroundOpacity().get());
            guiGraphics.fill(renderX - 5, renderY - 5, renderX + renderWidth + 5, renderY + renderHeight + 5, opacity << 24);
            RenderUtils.renderSplitString(guiGraphics, lines, renderX, renderY, 0xFFFFFF);
        }
    }
}

