/*
 * Decompiled with CFR 0.152.
 */
package com.chaosthedude.notes.gui;

import com.chaosthedude.notes.Notes;
import com.chaosthedude.notes.config.ConfigHandler;
import com.chaosthedude.notes.gui.DisplayNoteScreen;
import com.chaosthedude.notes.gui.EditNoteScreen;
import com.chaosthedude.notes.gui.NotesConfirmScreen;
import com.chaosthedude.notes.gui.NotesList;
import com.chaosthedude.notes.gui.SelectNoteScreen;
import com.chaosthedude.notes.note.Note;
import com.mojang.blaze3d.systems.RenderSystem;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Objects;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class NotesListEntry
extends ObjectSelectionList.Entry<NotesListEntry> {
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat();
    private final Minecraft mc;
    private final SelectNoteScreen parentScreen;
    private final Note note;
    private final NotesList notesList;
    private long lastClickTime;

    public NotesListEntry(NotesList notesList, Note note) {
        this.notesList = notesList;
        this.note = note;
        this.parentScreen = notesList.getParentScreen();
        this.mc = Minecraft.getInstance();
    }

    public void render(GuiGraphics guiGraphics, int par1, int par2, int par3, int par4, int par5, int par6, int par7, boolean par8, float par9) {
        guiGraphics.drawString(this.mc.font, this.note.getTitle(), par3 + 1, par2 + 1, 0xFFFFFF);
        guiGraphics.drawString(this.mc.font, this.note.getScope().format(), par3 + 4 + this.mc.font.width(this.note.getTitle()), par2 + 1, 0x808080);
        if (this.note.isPinned()) {
            guiGraphics.drawString(this.mc.font, I18n.get((String)"notes.pinned", (Object[])new Object[0]), par3 + 4 + this.mc.font.width(this.note.getTitle()) + this.mc.font.width(this.note.getScope().format()) + 4, par2 + 1, 0xFFFFFF);
        }
        guiGraphics.drawString(this.mc.font, this.note.getTitle(), par3 + 1, par2 + 1, 0xFFFFFF);
        Font font = this.mc.font;
        String string = this.note.getPreview(Mth.floor((double)((double)this.notesList.getRowWidth() * 0.9)));
        Objects.requireNonNull(this.mc.font);
        guiGraphics.drawString(font, string, par3 + 1, par2 + 9 + 3, 0x808080);
        Font font2 = this.mc.font;
        String string2 = this.note.getLastModifiedString();
        Objects.requireNonNull(this.mc.font);
        guiGraphics.drawString(font2, string2, par3 + 1, par2 + 9 + 14, 0x808080);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public boolean mouseClicked(double p_mouseClicked_1_, double p_mouseClicked_3_, int button) {
        if (button == 0) {
            this.notesList.selectNote(this);
            if (Util.getMillis() - this.lastClickTime < 250L) {
                this.loadNote();
                return true;
            }
            this.lastClickTime = Util.getMillis();
        }
        return false;
    }

    public void editNote() {
        if (((Boolean)ConfigHandler.CLIENT.useInGameEditor.get()).booleanValue() || !this.note.tryOpenExternal()) {
            this.mc.setScreen((Screen)new EditNoteScreen(this.parentScreen, this.note));
        }
    }

    public void copyNote() {
        this.note.copy();
        this.notesList.refreshList();
    }

    public void loadNote() {
        this.mc.getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
        if (((Boolean)ConfigHandler.CLIENT.useInGameViewer.get()).booleanValue() || !this.note.tryOpenExternal()) {
            this.mc.setScreen((Screen)new DisplayNoteScreen(this.parentScreen, this.note));
        }
    }

    public void togglePin() {
        if (this.isPinned()) {
            Notes.pinnedNote = null;
        } else {
            Notes.pinnedNote = this.note;
            this.mc.setScreen(null);
        }
    }

    public boolean isPinned() {
        return this.note.equals(Notes.pinnedNote);
    }

    public Note getNote() {
        return this.note;
    }

    public void deleteNote() {
        this.mc.setScreen((Screen)new NotesConfirmScreen(result -> {
            if (result) {
                this.note.delete();
            }
            this.mc.setScreen((Screen)this.parentScreen);
        }, (Component)Component.translatable((String)"notes.confirmDelete"), (Component)Component.literal((String)this.note.getTitle())));
    }

    public Component getNarration() {
        return Component.literal((String)this.note.getTitle());
    }
}

