/*
 * Decompiled with CFR 0.152.
 */
package com.chaosthedude.notes.gui;

import com.chaosthedude.notes.gui.NotesListEntry;
import com.chaosthedude.notes.gui.SelectNoteScreen;
import com.chaosthedude.notes.note.Note;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class NotesList
extends ObjectSelectionList<NotesListEntry> {
    private final SelectNoteScreen parentScreen;

    public NotesList(SelectNoteScreen notesScreen, Minecraft mc, int width, int height, int top, int bottom) {
        super(mc, width, height, top, bottom);
        this.parentScreen = notesScreen;
        this.refreshList();
    }

    protected int getScrollbarPosition() {
        return super.getScrollbarPosition() + 20;
    }

    public int getRowWidth() {
        return super.getRowWidth() + 50;
    }

    protected boolean isSelectedItem(int slotIndex) {
        return slotIndex >= 0 && slotIndex < this.children().size() ? ((Object)((Object)((NotesListEntry)((Object)this.children().get(slotIndex))))).equals(this.getSelected()) : false;
    }

    public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        guiGraphics.fill(this.getRowLeft() - 4, this.getY(), this.getRowLeft() + this.getRowWidth() + 4, this.getY() + this.getHeight() + 4, 0x7F000000);
        this.enableScissor(guiGraphics);
        int i = this.getItemCount();
        for (int j = 0; j < i; ++j) {
            int k = this.getRowTop(j);
            int l = this.getRowBottom(j);
            if (l < this.getY() || k > this.getBottom()) continue;
            int j1 = this.itemHeight - 4;
            NotesListEntry e = (NotesListEntry)this.getEntry(j);
            int k1 = this.getRowWidth();
            if (this.isSelectedItem(j)) {
                int insideLeft = this.getX() + this.width / 2 - this.getRowWidth() / 2 + 2;
                guiGraphics.fill(insideLeft - 4, k - 4, insideLeft + this.getRowWidth() + 4, k + this.itemHeight, 0x7F000000);
            }
            int j2 = this.getRowLeft();
            e.render(guiGraphics, j, k, j2, k1, j1, mouseX, mouseY, this.isMouseOver(mouseX, mouseY) && Objects.equals(this.getEntryAtPosition(mouseX, mouseY), (Object)e), partialTicks);
        }
        guiGraphics.disableScissor();
    }

    protected void enableScissor(GuiGraphics guiGraphics) {
        guiGraphics.enableScissor(this.getX(), this.getY(), this.getRight(), this.getBottom());
    }

    protected int getRowBottom(int index) {
        return this.getRowTop(index) + this.itemHeight;
    }

    public void refreshList() {
        this.clearEntries();
        for (Note note : Note.getCurrentNotes()) {
            this.addEntry((AbstractSelectionList.Entry)new NotesListEntry(this, note));
        }
    }

    public void selectNote(NotesListEntry entry) {
        this.setSelected((AbstractSelectionList.Entry)entry);
        this.parentScreen.selectNote(entry);
    }

    public SelectNoteScreen getParentScreen() {
        return this.parentScreen;
    }
}

