/*
 * Decompiled with CFR 0.152.
 */
package com.chaosthedude.notes.gui;

import com.chaosthedude.notes.Notes;
import com.chaosthedude.notes.gui.DisplayNoteScreen;
import com.chaosthedude.notes.gui.NotesButton;
import com.chaosthedude.notes.gui.NotesTextField;
import com.chaosthedude.notes.gui.NotesTitleField;
import com.chaosthedude.notes.note.Note;
import com.chaosthedude.notes.note.Scope;
import com.chaosthedude.notes.util.StringUtils;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class EditNoteScreen
extends Screen {
    private final Screen parentScreen;
    private NotesButton saveButton;
    private NotesButton globalButton;
    private NotesButton insertBiomeButton;
    private NotesButton insertChunkButton;
    private NotesButton insertCoordsButton;
    private NotesButton cancelButton;
    private NotesTitleField noteTitleField;
    private NotesTextField noteTextField;
    private String saveDirName;
    private Note note;
    private Scope scope;
    private boolean pinned;
    private boolean setTextFieldFocused;

    public EditNoteScreen(Screen parentScreen, @Nullable Note note) {
        super((Component)Component.literal((String)(note != null ? I18n.get((String)"notes.editNote", (Object[])new Object[0]) : I18n.get((String)"notes.newNote", (Object[])new Object[0]))));
        this.parentScreen = parentScreen;
        this.note = note != null ? note : new Note("New Note", "", Scope.getCurrentScope());
        this.scope = Scope.getCurrentScope();
        this.pinned = this.note.isPinned();
        this.setTextFieldFocused = false;
    }

    public void init() {
        this.setupTextFields();
        this.setupButtons();
    }

    public void tick() {
        this.insertChunkButton.active = this.insertCoordsButton.active = this.noteTextField.isFocused();
        this.insertBiomeButton.active = this.insertCoordsButton.active;
    }

    public boolean mouseClicked(double x, double y, int button) {
        boolean ret = super.mouseClicked(x, y, button);
        if (this.setTextFieldFocused) {
            this.noteTextField.setFocused(true);
            this.setFocused((GuiEventListener)this.noteTextField);
            this.setTextFieldFocused = false;
        }
        return ret;
    }

    public boolean keyPressed(int keyCode, int par2, int par3) {
        boolean ret = super.keyPressed(keyCode, par2, par3);
        this.updateNote();
        return ret;
    }

    public boolean keyReleased(int keyCode, int par2, int par3) {
        boolean ret = super.keyReleased(keyCode, par2, par3);
        this.updateNote();
        return ret;
    }

    public void setFocused(GuiEventListener listener) {
        super.setFocused(listener);
        if (listener != this.noteTextField && this.noteTextField != null) {
            this.noteTextField.setFocused(false);
        }
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        guiGraphics.drawCenteredString(this.font, this.title.getString(), this.width / 2 + 60, 15, 0xFFFFFF);
        guiGraphics.drawCenteredString(this.font, I18n.get((String)"notes.saveAs", (Object[])new Object[]{this.note.getUncollidingSaveName(this.note.getTitle())}), this.width / 2 + 55, 65, 0x808080);
    }

    private void setupButtons() {
        this.saveButton = (NotesButton)this.addRenderableWidget((GuiEventListener)new NotesButton(10, 40, 110, 20, (Component)Component.translatable((String)"notes.save"), onPress -> {
            this.updateNote();
            this.note.save();
            this.minecraft.setScreen((Screen)new DisplayNoteScreen(this.parentScreen, this.note));
            if (this.pinned) {
                Notes.pinnedNote = this.note;
            }
        }));
        this.globalButton = (NotesButton)this.addRenderableWidget((GuiEventListener)new NotesButton(10, 65, 110, 20, (Component)Component.translatable((String)"notes.global").append((Component)Component.literal((String)": ").append((Component)(this.note.getScope() == Scope.GLOBAL ? Component.translatable((String)"notes.on") : Component.translatable((String)"notes.off")))), onPress -> {
            this.scope = this.scope == Scope.GLOBAL ? Scope.getCurrentScope() : Scope.GLOBAL;
            this.globalButton.setMessage((Component)Component.literal((String)(I18n.get((String)"notes.global", (Object[])new Object[0]) + (this.scope == Scope.GLOBAL ? ": " + I18n.get((String)"notes.on", (Object[])new Object[0]) : ": " + I18n.get((String)"notes.off", (Object[])new Object[0])))));
            this.updateNote();
        }));
        this.insertBiomeButton = (NotesButton)this.addRenderableWidget((GuiEventListener)new NotesButton(10, 100, 110, 20, (Component)Component.translatable((String)"notes.biome"), onPress -> {
            this.insertBiome();
            this.setTextFieldFocused = true;
        }));
        this.insertChunkButton = (NotesButton)this.addRenderableWidget((GuiEventListener)new NotesButton(10, 125, 110, 20, (Component)Component.translatable((String)"notes.chunk"), onPress -> {
            this.insertChunk();
            this.setTextFieldFocused = true;
        }));
        this.insertCoordsButton = (NotesButton)this.addRenderableWidget((GuiEventListener)new NotesButton(10, 150, 110, 20, (Component)Component.translatable((String)"notes.coordinates"), onPress -> {
            this.insertCoords();
            this.setTextFieldFocused = true;
        }));
        this.cancelButton = (NotesButton)this.addRenderableWidget((GuiEventListener)new NotesButton(10, this.height - 30, 110, 20, (Component)Component.translatable((String)"gui.cancel"), onPress -> this.minecraft.setScreen(this.parentScreen)));
        this.insertBiomeButton.active = false;
        this.insertChunkButton.active = false;
        this.insertCoordsButton.active = false;
    }

    private void setupTextFields() {
        this.noteTitleField = (NotesTitleField)this.addRenderableWidget((GuiEventListener)new NotesTitleField(this.font, 130, 40, this.width - 140, 20, (Component)Component.literal((String)"")));
        this.noteTitleField.setValue(this.note.getTitle());
        this.addRenderableWidget((GuiEventListener)this.noteTitleField);
        this.noteTitleField.setFocused(true);
        this.setFocused((GuiEventListener)this.noteTitleField);
        this.noteTextField = (NotesTextField)this.addRenderableWidget((GuiEventListener)new NotesTextField(this.font, 130, 85, this.width - 140, this.height - 95, 5));
        this.noteTextField.setText(this.note.getFilteredText());
        this.addRenderableWidget((GuiEventListener)this.noteTextField);
    }

    private void updateNote() {
        this.note.setTitle(this.noteTitleField.getValue());
        this.note.setText(this.noteTextField.getText());
        this.note.setScope(this.scope);
    }

    private void insertBiome() {
        this.noteTextField.insert(StringUtils.fixBiomeName((Level)this.minecraft.level, (Biome)this.minecraft.level.getBiome(this.minecraft.player.blockPosition()).value()));
    }

    private void insertChunk() {
        this.noteTextField.insert(this.minecraft.player.chunkPosition().x + ", " + this.minecraft.player.chunkPosition().z);
    }

    private void insertCoords() {
        this.noteTextField.insert(this.minecraft.player.getBlockX() + ", " + this.minecraft.player.getBlockY() + ", " + this.minecraft.player.getBlockZ());
    }
}

