/*
 * Decompiled with CFR 0.152.
 */
package com.chaosthedude.notes.gui;

import com.chaosthedude.notes.Notes;
import com.chaosthedude.notes.config.ConfigHandler;
import com.chaosthedude.notes.gui.EditNoteScreen;
import com.chaosthedude.notes.gui.NotesButton;
import com.chaosthedude.notes.gui.NotesConfirmScreen;
import com.chaosthedude.notes.note.Note;
import com.chaosthedude.notes.util.RenderUtils;
import com.chaosthedude.notes.util.StringUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class DisplayNoteScreen
extends Screen {
    private final Screen parentScreen;
    private NotesButton doneButton;
    private NotesButton pinButton;
    private NotesButton editButton;
    private NotesButton deleteButton;
    private NotesButton prevButton;
    private NotesButton nextButton;
    private Note note;
    private int page;
    private List<String> pages;

    public DisplayNoteScreen(Screen parentScreen, Note note) {
        super((Component)Component.literal((String)note.getTitle()));
        this.parentScreen = parentScreen;
        this.note = note;
        this.page = 0;
        this.pages = new ArrayList<String>();
        this.pages.add("");
    }

    public void init() {
        this.setupButtons();
        this.setupPages();
    }

    public void tick() {
        this.prevButton.active = this.page > 0;
        this.nextButton.active = this.page < this.pages.size() - 1;
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        guiGraphics.drawCenteredString(this.font, this.title.getString(), this.width / 2 + 60, 15, -1);
        this.displayNote(guiGraphics);
    }

    public void displayNote(GuiGraphics guiGraphics) {
        List<String> lines = RenderUtils.splitStringToWidth(this.pages.get(this.page), this.width - 200);
        RenderUtils.renderSplitString(guiGraphics, lines, 160, 40, 0xFFFFFF);
    }

    private void setupButtons() {
        this.editButton = (NotesButton)this.addRenderableWidget((GuiEventListener)new NotesButton(10, 40, 110, 20, (Component)Component.translatable((String)"notes.edit"), onPress -> this.minecraft.setScreen((Screen)new EditNoteScreen(this.parentScreen, this.note))));
        this.deleteButton = (NotesButton)this.addRenderableWidget((GuiEventListener)new NotesButton(10, 65, 110, 20, (Component)Component.translatable((String)"notes.delete"), onPress -> this.deleteNote()));
        this.pinButton = (NotesButton)this.addRenderableWidget((GuiEventListener)new NotesButton(10, 90, 110, 20, (Component)(this.isPinned() ? Component.translatable((String)"notes.unpin") : Component.translatable((String)"notes.pin")), onPress -> {
            this.togglePin();
            if (this.isPinned()) {
                this.minecraft.setScreen(null);
            }
        }));
        this.doneButton = (NotesButton)this.addRenderableWidget((GuiEventListener)new NotesButton(10, this.height - 30, 110, 20, (Component)Component.translatable((String)"gui.done"), onPress -> this.minecraft.setScreen(this.parentScreen)));
        this.prevButton = (NotesButton)this.addRenderableWidget((GuiEventListener)new NotesButton(130, this.height - 30, 20, 20, (Component)Component.translatable((String)"<"), onPress -> {
            if (this.page > 0) {
                --this.page;
            }
        }));
        this.nextButton = (NotesButton)this.addRenderableWidget((GuiEventListener)new NotesButton(this.width - 30, this.height - 30, 20, 20, (Component)Component.translatable((String)">"), onPress -> {
            if (this.page < this.pages.size() - 1) {
                ++this.page;
            }
        }));
    }

    private void setupPages() {
        if (this.note != null) {
            List<String> lines = (Boolean)ConfigHandler.CLIENT.wrapNote.get() != false ? RenderUtils.splitStringToWidth(this.note.getFilteredText(), this.width - 200) : StringUtils.wrapToWidth(this.note.getFilteredText(), this.width - 200);
            this.pages = new ArrayList<String>();
            int lineCount = 0;
            Object page = "";
            for (String line : lines) {
                if (lineCount > 15) {
                    this.pages.add((String)page);
                    page = "";
                    lineCount = 0;
                }
                page = (String)page + line + "\n";
                ++lineCount;
            }
            if (!((String)page).isEmpty()) {
                this.pages.add((String)page);
            }
        }
        if (this.pages.isEmpty()) {
            this.pages.add("");
        }
    }

    private boolean isPinned() {
        return this.note.equals(Notes.pinnedNote);
    }

    private void togglePin() {
        if (this.isPinned()) {
            Notes.pinnedNote = null;
            this.pinButton.setMessage((Component)Component.translatable((String)"notes.pin"));
        } else {
            Notes.pinnedNote = this.note;
            this.pinButton.setMessage((Component)Component.translatable((String)"notes.unpin"));
        }
    }

    private void deleteNote() {
        this.minecraft.setScreen((Screen)new NotesConfirmScreen(result -> {
            if (result) {
                this.note.delete();
            }
            this.minecraft.setScreen(this.parentScreen);
        }, (Component)Component.translatable((String)"notes.confirmDelete"), (Component)Component.literal((String)this.note.getTitle())));
    }
}

