/*
 * Decompiled with CFR 0.152.
 */
package info.loenwind.gravitytorch;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.function.BiConsumer;
import java.util.function.ToIntFunction;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.AbstractCandleBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Fallable;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.TorchBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public final class GravityTorchBlock
extends TorchBlock
implements SimpleWaterloggedBlock,
Fallable {
    private static final float px = 0.0625f;
    private static final double diameter = 4.0;
    private static final double y_offset = 2.0;
    private static final double height = 12.0;
    private static final VoxelShape AABB = GravityTorchBlock.box((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)12.0, (double)10.0);
    private static final MapCodec<GravityTorchBlock> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)PARTICLE_OPTIONS_FIELD.forGetter(block -> block.flameParticle), (App)GravityTorchBlock.propertiesCodec()).apply((Applicative)instance, GravityTorchBlock::new));
    private static final BooleanProperty LIT = AbstractCandleBlock.LIT;
    private static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    private static final ToIntFunction<BlockState> LIGHT_EMISSION = blockstate -> (Boolean)blockstate.getValue((Property)LIT) != false && (Boolean)blockstate.getValue((Property)WATERLOGGED) == false ? 14 : 0;

    public static GravityTorchBlock create() {
        return new GravityTorchBlock(ParticleTypes.FLAME, BlockBehaviour.Properties.of().noCollission().instabreak().lightLevel(LIGHT_EMISSION).sound(SoundType.STONE).pushReaction(PushReaction.DESTROY));
    }

    public GravityTorchBlock(SimpleParticleType particle, BlockBehaviour.Properties bbp) {
        super(particle, bbp);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)LIT, (Comparable)Boolean.TRUE)).setValue((Property)WATERLOGGED, (Comparable)Boolean.FALSE));
    }

    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        FluidState fluidstate = pContext.getLevel().getFluidState(pContext.getClickedPos());
        boolean flag = fluidstate.getType() == Fluids.WATER;
        return (BlockState)((BlockState)super.getStateForPlacement(pContext).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag))).setValue((Property)LIT, (Comparable)Boolean.valueOf(!flag));
    }

    protected void onPlace(BlockState pState, Level pLevel, BlockPos pPos, BlockState pOldState, boolean pIsMoving) {
        pLevel.scheduleTick(pPos, (Block)this, this.getDelayAfterPlace());
    }

    protected BlockState updateShape(BlockState pState, Direction pDirection, BlockState pNeighborState, LevelAccessor pLevel, BlockPos pPos, BlockPos pNeighborPos) {
        if (((Boolean)pState.getValue((Property)WATERLOGGED)).booleanValue()) {
            pLevel.scheduleTick(pPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)pLevel));
        }
        pLevel.scheduleTick(pPos, (Block)this, this.getDelayAfterPlace());
        return pState;
    }

    private int getDelayAfterPlace() {
        return 2;
    }

    protected void tick(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        if (!this.canSurvive(pState, (LevelReader)pLevel, pPos) && pPos.getY() >= pLevel.getMinBuildHeight()) {
            FallingBlockEntity.fall((Level)pLevel, (BlockPos)pPos, (BlockState)pState);
        }
    }

    public void onLand(Level pLevel, BlockPos pPos, BlockState pState, BlockState pReplaceableState, FallingBlockEntity pFallingBlock) {
        if (((Boolean)pState.getValue((Property)WATERLOGGED)).booleanValue() && ((Boolean)pState.getValue((Property)LIT)).booleanValue()) {
            GravityTorchBlock.extinguish(null, pState, (LevelAccessor)pLevel, pPos);
        }
    }

    protected FluidState getFluidState(BlockState pState) {
        return (Boolean)pState.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(pState);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.add(new Property[]{LIT, WATERLOGGED});
    }

    public boolean placeLiquid(LevelAccessor pLevel, BlockPos pPos, BlockState pState, FluidState pFluidState) {
        if (!((Boolean)pState.getValue((Property)WATERLOGGED)).booleanValue() && pFluidState.getType() == Fluids.WATER) {
            BlockState blockstate = (BlockState)pState.setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(true));
            if (((Boolean)pState.getValue((Property)LIT)).booleanValue()) {
                GravityTorchBlock.extinguish(null, blockstate, pLevel, pPos);
            } else {
                pLevel.setBlock(pPos, blockstate, 3);
            }
            pLevel.scheduleTick(pPos, pFluidState.getType(), pFluidState.getType().getTickDelay((LevelReader)pLevel));
            return true;
        }
        return false;
    }

    protected ItemInteractionResult useItemOn(ItemStack pStack, BlockState blockstate, Level level, BlockPos blockpos, Player player, InteractionHand pHand, BlockHitResult pHitResult) {
        if (pStack.getItem() == Items.FLINT_AND_STEEL && player.getAbilities().mayBuild && this.canBeLit(blockstate)) {
            level.playSound(player, blockpos, SoundEvents.FLINTANDSTEEL_USE, SoundSource.BLOCKS, 1.0f, level.getRandom().nextFloat() * 0.4f + 0.8f);
            level.setBlock(blockpos, (BlockState)blockstate.setValue((Property)BlockStateProperties.LIT, (Comparable)Boolean.valueOf(true)), 11);
            level.gameEvent((Entity)player, (Holder)GameEvent.BLOCK_CHANGE, blockpos);
            if (player != null) {
                pStack.hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)pHand));
            }
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return super.useItemOn(pStack, blockstate, level, blockpos, player, pHand, pHitResult);
    }

    protected boolean canBeLit(BlockState pState) {
        return (Boolean)pState.getValue((Property)WATERLOGGED) == false && (Boolean)pState.getValue((Property)LIT) == false;
    }

    protected void onProjectileHit(Level pLevel, BlockState pState, BlockHitResult pHit, Projectile pProjectile) {
        if (!pLevel.isClientSide && pProjectile.isOnFire() && this.canBeLit(pState)) {
            pLevel.setBlock(pHit.getBlockPos(), (BlockState)pState.setValue((Property)LIT, (Comparable)Boolean.valueOf(true)), 11);
        }
    }

    protected void onExplosionHit(BlockState pState, Level pLevel, BlockPos pPos, Explosion pExplosion, BiConsumer<ItemStack, BlockPos> pDropConsumer) {
        if (pExplosion.canTriggerBlocks() && ((Boolean)pState.getValue((Property)LIT)).booleanValue()) {
            GravityTorchBlock.extinguish(null, pState, (LevelAccessor)pLevel, pPos);
        }
        super.onExplosionHit(pState, pLevel, pPos, pExplosion, pDropConsumer);
    }

    public static void extinguish(@Nullable Player pPlayer, BlockState pState, LevelAccessor pLevel, BlockPos pPos) {
        pLevel.setBlock(pPos, (BlockState)pState.setValue((Property)LIT, (Comparable)Boolean.valueOf(false)), 11);
        pLevel.playSound(null, pPos, SoundEvents.CANDLE_EXTINGUISH, SoundSource.BLOCKS, 1.0f, 1.0f);
        pLevel.gameEvent((Entity)pPlayer, (Holder)GameEvent.BLOCK_CHANGE, pPos);
    }

    public MapCodec<? extends TorchBlock> codec() {
        return CODEC;
    }

    protected VoxelShape getShape(BlockState p_304673_, BlockGetter p_304919_, BlockPos p_304930_, CollisionContext p_304757_) {
        return AABB;
    }

    public void animateTick(BlockState pState, Level pLevel, BlockPos pPos, RandomSource pRandom) {
        if (((Boolean)pState.getValue((Property)LIT)).booleanValue()) {
            double d0 = (double)pPos.getX() + 0.5;
            double d1 = (double)pPos.getY() + 0.7 + 0.125;
            double d2 = (double)pPos.getZ() + 0.5;
            pLevel.addParticle((ParticleOptions)ParticleTypes.SMOKE, d0, d1, d2, 0.0, 0.0, 0.0);
            pLevel.addParticle((ParticleOptions)this.flameParticle, d0, d1, d2, 0.0, 0.0, 0.0);
        }
    }
}

