/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.clientsort.util;

import java.awt.Color;
import java.util.Iterator;
import net.minecraft.client.Minecraft;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.DyedItemColor;
import net.minecraft.world.level.Level;

public class ItemStackUtils {
    public static int compareEqualItems(ItemStack a, ItemStack b) {
        int cmp = Integer.compare(b.getCount(), a.getCount());
        if (cmp != 0) {
            return cmp;
        }
        return ItemStackUtils.compareEqualItems2(a, b);
    }

    private static int compareEqualItems2(ItemStack a, ItemStack b) {
        if (ItemStackUtils.hasCustomHoverName(a)) {
            if (!ItemStackUtils.hasCustomHoverName(b)) {
                return -1;
            }
            return ItemStackUtils.compareEqualItems3(a, b);
        }
        if (ItemStackUtils.hasCustomHoverName(b)) {
            return 1;
        }
        return ItemStackUtils.compareEqualItems3(a, b);
    }

    private static boolean hasCustomHoverName(ItemStack itemStack) {
        return itemStack.get(DataComponents.CUSTOM_NAME) != null;
    }

    private static int compareEqualItems3(ItemStack a, ItemStack b) {
        Iterator tooltipsA = a.getTooltipLines(Item.TooltipContext.of((Level)Minecraft.getInstance().level), null, (TooltipFlag)TooltipFlag.Default.NORMAL).iterator();
        Iterator tooltipsB = b.getTooltipLines(Item.TooltipContext.of((Level)Minecraft.getInstance().level), null, (TooltipFlag)TooltipFlag.Default.NORMAL).iterator();
        while (tooltipsA.hasNext()) {
            if (!tooltipsB.hasNext()) {
                return 1;
            }
            int cmp = ((Component)tooltipsA.next()).getString().compareToIgnoreCase(((Component)tooltipsB.next()).getString());
            if (cmp == 0) continue;
            return cmp;
        }
        if (tooltipsB.hasNext()) {
            return -1;
        }
        return ItemStackUtils.compareEqualItems4(a, b);
    }

    private static int compareEqualItems4(ItemStack a, ItemStack b) {
        Item item = a.getItem();
        if (item.getDefaultInstance().is(ItemTags.DYEABLE)) {
            float[] hsbB;
            int colorA = DyedItemColor.getOrDefault((ItemStack)a, (int)-6265536);
            int colorB = DyedItemColor.getOrDefault((ItemStack)b, (int)-6265536);
            float[] hsbA = Color.RGBtoHSB(colorA >> 16 & 0xFF, colorA >> 8 & 0xFF, colorA & 0xFF, null);
            int cmp = Float.compare(hsbA[0], (hsbB = Color.RGBtoHSB(colorB >> 16 & 0xFF, colorB >> 8 & 0xFF, colorB & 0xFF, null))[0]);
            if (cmp != 0) {
                return cmp;
            }
            cmp = Float.compare(hsbA[1], hsbB[1]);
            if (cmp != 0) {
                return cmp;
            }
            cmp = Float.compare(hsbA[2], hsbB[2]);
            if (cmp != 0) {
                return cmp;
            }
        }
        return ItemStackUtils.compareEqualItems5(a, b);
    }

    private static int compareEqualItems5(ItemStack a, ItemStack b) {
        return Integer.compare(a.getDamageValue(), b.getDamageValue());
    }
}

