/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.clientsort.util;

import dev.terminalmc.clientsort.ClientSort;
import dev.terminalmc.clientsort.config.Config;
import dev.terminalmc.clientsort.mixin.accessor.LocalPlayerAccessor;
import dev.terminalmc.clientsort.util.StackMatcher;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.minecraft.client.Minecraft;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.ItemStack;

public class CreativeSearchOrder {
    private static final Object2IntMap<StackMatcher> stackToSearchPositionLookup = new Object2IntOpenHashMap();
    private static final ReadWriteLock stackToSearchPositionLookupLock;

    public static Lock getReadLock() {
        return stackToSearchPositionLookupLock.readLock();
    }

    public static int getStackSearchPosition(ItemStack stack) {
        int pos = stackToSearchPositionLookup.getInt((Object)StackMatcher.of(stack));
        if (pos == Integer.MAX_VALUE) {
            pos = stackToSearchPositionLookup.getInt((Object)StackMatcher.ignoreNbt(stack));
        }
        return pos;
    }

    public static void tryRefreshItemSearchPositionLookup() {
        if (ClientSort.emiReloading) {
            ClientSort.updateBlockedByEmi = true;
        } else {
            CreativeSearchOrder.refreshItemSearchPositionLookup();
        }
    }

    public static void refreshItemSearchPositionLookup() {
        if (Config.get().options.optimizedCreativeSorting) {
            Minecraft mc = Minecraft.getInstance();
            if (mc.level == null || mc.player == null) {
                return;
            }
            FeatureFlagSet enabledFeatures = mc.level.enabledFeatures();
            boolean opTab = (Boolean)mc.options.operatorItemsTab().get() != false && ((LocalPlayerAccessor)mc.player).getPermissionLevel() >= 2;
            CreativeModeTabs.tryRebuildTabContents((FeatureFlagSet)enabledFeatures, (!opTab ? 1 : 0) != 0, (HolderLookup.Provider)mc.level.registryAccess());
            ArrayList displayStacks = new ArrayList(CreativeModeTabs.searchTab().getDisplayItems());
            new Thread(() -> {
                Lock lock = stackToSearchPositionLookupLock.writeLock();
                lock.lock();
                stackToSearchPositionLookup.clear();
                if (displayStacks.isEmpty()) {
                    lock.unlock();
                    return;
                }
                int i = 0;
                for (ItemStack stack : displayStacks) {
                    StackMatcher plainMatcher = StackMatcher.ignoreNbt(stack);
                    if (!stack.hasFoil() || !stackToSearchPositionLookup.containsKey((Object)plainMatcher)) {
                        stackToSearchPositionLookup.put((Object)plainMatcher, i);
                        ++i;
                    }
                    stackToSearchPositionLookup.put((Object)StackMatcher.of(stack), i);
                    ++i;
                }
                lock.unlock();
            }, "Mouse Wheelie: creative search stack position lookup builder").start();
        } else {
            Lock lock = stackToSearchPositionLookupLock.writeLock();
            lock.lock();
            stackToSearchPositionLookup.clear();
            lock.unlock();
        }
    }

    static {
        stackToSearchPositionLookup.defaultReturnValue(Integer.MAX_VALUE);
        stackToSearchPositionLookupLock = new ReentrantReadWriteLock();
    }
}

