/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.clientsort.screen;

import dev.terminalmc.clientsort.screen.ClothConfigScreenProvider;
import dev.terminalmc.clientsort.util.mod.Localization;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.MultiLineTextWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.ConfirmLinkScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.options.OptionsSubScreen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;

public class ConfigScreenProvider {
    public static Screen getConfigScreen(Screen parent) {
        try {
            return ClothConfigScreenProvider.getConfigScreen(parent);
        }
        catch (NoClassDefFoundError ignored) {
            return new BackupScreen(parent);
        }
    }

    static class BackupScreen
    extends OptionsSubScreen {
        public BackupScreen(Screen parent) {
            super(parent, Minecraft.getInstance().options, (Component)Localization.localized("screen", "default", new Object[0]));
        }

        public void init() {
            MultiLineTextWidget messageWidget = new MultiLineTextWidget(this.width / 2 - 120, this.height / 2 - 40, (Component)Localization.localized("message", "install_cloth", new Object[0]), this.minecraft.font);
            messageWidget.setMaxWidth(240);
            messageWidget.setCentered(true);
            this.addRenderableWidget((GuiEventListener)messageWidget);
            Button openLinkButton = Button.builder((Component)Localization.localized("message", "go_modrinth", new Object[0]), button -> this.minecraft.setScreen((Screen)new ConfirmLinkScreen(open -> {
                if (open) {
                    Util.getPlatform().openUri("https://modrinth.com/mod/9s6osm5g");
                }
                this.minecraft.setScreen(this.lastScreen);
            }, "https://modrinth.com/mod/9s6osm5g", true))).pos(this.width / 2 - 120, this.height / 2).size(115, 20).build();
            this.addRenderableWidget((GuiEventListener)openLinkButton);
            Button exitButton = Button.builder((Component)CommonComponents.GUI_OK, button -> this.onClose()).pos(this.width / 2 + 5, this.height / 2).size(115, 20).build();
            this.addRenderableWidget((GuiEventListener)exitButton);
        }

        protected void addOptions() {
        }
    }
}

