/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.clientsort.screen;

import dev.terminalmc.clientsort.config.Config;
import dev.terminalmc.clientsort.inventory.sort.SortMode;
import dev.terminalmc.clientsort.util.CreativeSearchOrder;
import dev.terminalmc.clientsort.util.mod.Localization;
import java.util.Optional;
import me.shedaniel.clothconfig2.api.AbstractConfigListEntry;
import me.shedaniel.clothconfig2.api.ConfigBuilder;
import me.shedaniel.clothconfig2.api.ConfigCategory;
import me.shedaniel.clothconfig2.api.ConfigEntryBuilder;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public class ClothConfigScreenProvider {
    static Screen getConfigScreen(Screen parent) {
        Config.Options options = Config.get().options;
        ConfigBuilder builder = ConfigBuilder.create().setParentScreen(parent).setTitle((Component)Localization.localized("screen", "options", new Object[0])).setSavingRunnable(Config::getAndSave);
        ConfigEntryBuilder eb = builder.entryBuilder();
        ConfigCategory general = builder.getOrCreateCategory((Component)Localization.localized("option", "general", new Object[0]));
        general.addEntry((AbstractConfigListEntry)eb.startIntField((Component)Localization.localized("option", "interaction_rate_server", new Object[0]), options.interactionRateServer).setTooltip(new Component[]{Localization.localized("option", "interaction_rate.tooltip", new Object[0])}).setErrorSupplier(val -> {
            if (val < 1) {
                return Optional.of(Localization.localized("option", "error.low", new Object[0]));
            }
            if (val > 100) {
                return Optional.of(Localization.localized("option", "error.high", new Object[0]));
            }
            return Optional.empty();
        }).setDefaultValue(10).setSaveConsumer(val -> {
            options.interactionRateServer = val;
        }).build());
        general.addEntry((AbstractConfigListEntry)eb.startIntField((Component)Localization.localized("option", "interaction_rate_client", new Object[0]), options.interactionRateClient).setTooltip(new Component[]{Localization.localized("option", "interaction_rate.tooltip", new Object[0])}).setErrorSupplier(val -> {
            if (val < 1) {
                return Optional.of(Localization.localized("option", "error.low", new Object[0]));
            }
            if (val > 100) {
                return Optional.of(Localization.localized("option", "error.high", new Object[0]));
            }
            return Optional.empty();
        }).setDefaultValue(1).setSaveConsumer(val -> {
            options.interactionRateClient = val;
        }).build());
        general.addEntry((AbstractConfigListEntry)eb.startEnumSelector((Component)Localization.localized("option", "hotbar_mode", new Object[0]), Config.Options.HotbarMode.class, (Enum)options.hotbarMode).setEnumNameProvider(val -> Localization.localized("hotbar_mode", ((Config.Options.HotbarMode)((Object)val)).lowerName(), new Object[0])).setTooltipSupplier(val -> Optional.of(new Component[]{Localization.localized("hotbar_mode", val.lowerName() + ".tooltip", new Object[0])})).setDefaultValue((Enum)Config.Options.defaultHotbarMode).setSaveConsumer(val -> {
            options.hotbarMode = val;
        }).build());
        ConfigCategory sort = builder.getOrCreateCategory((Component)Localization.localized("option", "sorting", new Object[0]));
        sort.addEntry((AbstractConfigListEntry)eb.startSelector((Component)Localization.localized("option", "sort_mode", new Object[0]), SortMode.SORT_MODES.values().toArray(), (Object)options.sortMode).setNameProvider(val -> Localization.localized("sort_order", ((SortMode)val).name, new Object[0])).setDefaultValue((Object)Config.Options.defaultSortMode).setSaveConsumer(val -> {
            options.sortMode = (SortMode)val;
        }).build());
        sort.addEntry((AbstractConfigListEntry)eb.startSelector((Component)Localization.localized("option", "shift_sort_mode", new Object[0]), SortMode.SORT_MODES.values().toArray(), (Object)options.shiftSortMode).setNameProvider(val -> Localization.localized("sort_order", ((SortMode)val).name, new Object[0])).setDefaultValue((Object)Config.Options.defaultShiftSortMode).setSaveConsumer(val -> {
            options.shiftSortMode = (SortMode)val;
        }).build());
        sort.addEntry((AbstractConfigListEntry)eb.startSelector((Component)Localization.localized("option", "ctrl_sort_mode", new Object[0]), SortMode.SORT_MODES.values().toArray(), (Object)options.ctrlSortMode).setNameProvider(val -> Localization.localized("sort_order", ((SortMode)val).name, new Object[0])).setDefaultValue((Object)Config.Options.defaultCtrlSortMode).setSaveConsumer(val -> {
            options.ctrlSortMode = (SortMode)val;
        }).build());
        sort.addEntry((AbstractConfigListEntry)eb.startSelector((Component)Localization.localized("option", "alt_sort_mode", new Object[0]), SortMode.SORT_MODES.values().toArray(), (Object)options.altSortMode).setNameProvider(val -> Localization.localized("sort_order", ((SortMode)val).name, new Object[0])).setDefaultValue((Object)Config.Options.defaultAltSortMode).setSaveConsumer(val -> {
            options.altSortMode = (SortMode)val;
        }).build());
        sort.addEntry((AbstractConfigListEntry)eb.startBooleanToggle((Component)Localization.localized("option", "optimized_creative_sorting", new Object[0]), options.optimizedCreativeSorting).setDefaultValue(true).setSaveConsumer(val -> {
            options.optimizedCreativeSorting = val;
            if (val.booleanValue()) {
                CreativeSearchOrder.tryRefreshItemSearchPositionLookup();
            }
        }).build());
        return builder.build();
    }
}

