/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.clientsort.network;

import com.mojang.logging.LogUtils;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Queue;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickType;

public class InteractionManager {
    private static final Queue<InteractionEvent> interactionEventQueue = new ArrayDeque<InteractionEvent>();
    private static final ScheduledThreadPoolExecutor scheduledExecutor = new ScheduledThreadPoolExecutor(1);
    private static ScheduledFuture<?> tickFuture;
    public static final Waiter TICK_WAITER;
    private static Waiter waiter;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void push(InteractionEvent interactionEvent) {
        if (interactionEvent == null) {
            return;
        }
        Queue<InteractionEvent> queue = interactionEventQueue;
        synchronized (queue) {
            interactionEventQueue.add(interactionEvent);
            if (waiter == null) {
                InteractionManager.triggerSend(TriggerType.INITIAL);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void pushAll(Collection<InteractionEvent> interactionEvents) {
        if (interactionEvents == null) {
            return;
        }
        Queue<InteractionEvent> queue = interactionEventQueue;
        synchronized (queue) {
            interactionEventQueue.addAll(interactionEvents);
            if (waiter == null) {
                InteractionManager.triggerSend(TriggerType.INITIAL);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void triggerSend(TriggerType triggerType) {
        Queue<InteractionEvent> queue = interactionEventQueue;
        synchronized (queue) {
            if (waiter == null || waiter.trigger(triggerType)) {
                do {
                    InteractionEvent event;
                    if ((event = interactionEventQueue.poll()) == null) {
                        waiter = null;
                        break;
                    }
                    InteractionManager.doSendEvent(event);
                } while (waiter.trigger(TriggerType.INITIAL));
            }
        }
    }

    private static void doSendEvent(InteractionEvent event) {
        if (event.shouldRunOnMainThread()) {
            InteractionManager.runOnMainThread(event);
        } else {
            waiter = event.send();
        }
    }

    private static void runOnMainThread(InteractionEvent event) {
        Waiter blockingWaiter;
        waiter = blockingWaiter = tt -> false;
        Minecraft.getInstance().execute(() -> {
            Queue<InteractionEvent> queue = interactionEventQueue;
            synchronized (queue) {
                if (waiter == blockingWaiter) {
                    waiter = event.send();
                }
            }
        });
    }

    public static void setTickRate(long milliSeconds) {
        if (tickFuture != null) {
            tickFuture.cancel(false);
        }
        tickFuture = scheduledExecutor.scheduleAtFixedRate(InteractionManager::tick, milliSeconds, milliSeconds, TimeUnit.MILLISECONDS);
    }

    public static void tick() {
        try {
            InteractionManager.triggerSend(TriggerType.TICK);
        }
        catch (Exception e) {
            LogUtils.getLogger().error("Error while ticking InteractionManager", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clear() {
        Queue<InteractionEvent> queue = interactionEventQueue;
        synchronized (queue) {
            interactionEventQueue.clear();
            waiter = null;
        }
    }

    static {
        TICK_WAITER = triggerType -> triggerType == TriggerType.TICK;
        waiter = null;
    }

    @FunctionalInterface
    public static interface Waiter {
        public boolean trigger(TriggerType var1);

        public static Waiter equal(TriggerType triggerType) {
            return triggerType::equals;
        }
    }

    public static enum TriggerType {
        INITIAL,
        CONTAINER_SLOT_UPDATE,
        GUI_CONFIRM,
        HELD_ITEM_CHANGE,
        TICK;

    }

    @FunctionalInterface
    public static interface InteractionEvent {
        public Waiter send();

        default public boolean shouldRunOnMainThread() {
            return false;
        }
    }

    public static class CallbackEvent
    implements InteractionEvent {
        private final Supplier<Waiter> callback;
        private final boolean shouldRunOnMainThread;

        public CallbackEvent(Supplier<Waiter> callback, boolean shouldRunOnMainThread) {
            this.callback = callback;
            this.shouldRunOnMainThread = shouldRunOnMainThread;
        }

        @Override
        public Waiter send() {
            return this.callback.get();
        }

        @Override
        public boolean shouldRunOnMainThread() {
            return this.shouldRunOnMainThread;
        }
    }

    public static class ClickEvent
    implements InteractionEvent {
        private final Waiter waiter;
        private final int containerSyncId;
        private final int slotId;
        private final int buttonId;
        private final ClickType slotAction;

        public ClickEvent(int containerSyncId, int slotId, int buttonId, ClickType slotAction) {
            this(containerSyncId, slotId, buttonId, slotAction, TICK_WAITER);
        }

        public ClickEvent(int containerSyncId, int slotId, int buttonId, ClickType slotAction, Waiter waiter) {
            this.containerSyncId = containerSyncId;
            this.slotId = slotId;
            this.buttonId = buttonId;
            this.slotAction = slotAction;
            this.waiter = waiter;
        }

        @Override
        public Waiter send() {
            Minecraft.getInstance().gameMode.handleInventoryMouseClick(this.containerSyncId, this.slotId, this.buttonId, this.slotAction, (Player)Minecraft.getInstance().player);
            return this.waiter;
        }

        @Override
        public boolean shouldRunOnMainThread() {
            return true;
        }
    }

    @Deprecated
    public static class GuiConfirmWaiter
    implements Waiter {
        int triggers;

        public GuiConfirmWaiter(int triggers) {
            this.triggers = triggers;
        }

        @Override
        public boolean trigger(TriggerType triggerType) {
            return triggerType == TriggerType.GUI_CONFIRM && --this.triggers == 0;
        }
    }
}

