/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.clientsort.mixin;

import com.google.common.base.Suppliers;
import dev.terminalmc.clientsort.config.Config;
import dev.terminalmc.clientsort.inventory.ContainerScreenHelper;
import dev.terminalmc.clientsort.inventory.sort.InventorySorter;
import dev.terminalmc.clientsort.inventory.sort.SortMode;
import dev.terminalmc.clientsort.network.InteractionManager;
import dev.terminalmc.clientsort.util.inject.IContainerScreen;
import dev.terminalmc.clientsort.util.inject.ISlot;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import org.lwjgl.glfw.GLFW;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={AbstractContainerScreen.class})
public abstract class MixinAbstractContainerScreen
extends Screen
implements IContainerScreen {
    @Shadow
    @Final
    protected AbstractContainerMenu menu;
    @Shadow
    protected Slot hoveredSlot;
    @Unique
    private final Supplier<ContainerScreenHelper<AbstractContainerScreen<AbstractContainerMenu>>> clientSort$screenHelper = Suppliers.memoize(() -> ContainerScreenHelper.of((AbstractContainerScreen)this, (slot, data, slotActionType) -> new InteractionManager.CallbackEvent(() -> {
        this.slotClicked(slot, ((ISlot)slot).mouseWheelie_getIdInContainer(), data, slotActionType);
        return InteractionManager.TICK_WAITER;
    }, true)));

    protected MixinAbstractContainerScreen(Component textComponent_1) {
        super(textComponent_1);
    }

    @Shadow
    protected abstract void slotClicked(Slot var1, int var2, int var3, ClickType var4);

    @Override
    public boolean mouseWheelie_triggerSort() {
        if (this.hoveredSlot == null) {
            return false;
        }
        LocalPlayer player = Minecraft.getInstance().player;
        if (player.getAbilities().instabuild && GLFW.glfwGetMouseButton((long)this.minecraft.getWindow().getWindow(), (int)2) != 0 && !this.hoveredSlot.getItem().isEmpty() == this.menu.getCarried().isEmpty()) {
            return false;
        }
        InventorySorter sorter = new InventorySorter(this.clientSort$screenHelper.get(), (AbstractContainerScreen)this, this.hoveredSlot);
        Config.Options options = Config.get().options;
        SortMode sortMode = MixinAbstractContainerScreen.hasShiftDown() ? options.shiftSortMode : (MixinAbstractContainerScreen.hasControlDown() ? options.ctrlSortMode : (MixinAbstractContainerScreen.hasAltDown() ? options.altSortMode : options.sortMode));
        if (sortMode == null) {
            return false;
        }
        sorter.sort(sortMode);
        return true;
    }
}

