/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.clientsort.inventory.sort;

import dev.terminalmc.clientsort.config.Config;
import dev.terminalmc.clientsort.inventory.sort.SortContext;
import dev.terminalmc.clientsort.util.CreativeSearchOrder;
import dev.terminalmc.clientsort.util.ItemStackUtils;
import dev.terminalmc.clientsort.util.StackMatcher;
import it.unimi.dsi.fastutil.ints.IntArrays;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public abstract class SortMode {
    public static final Map<String, SortMode> SORT_MODES = new HashMap<String, SortMode>();
    public final String name;
    public static final SortMode NONE = SortMode.register("none", new SortMode("none"){});
    public static final SortMode ALPHABET = SortMode.register("alphabet", new SortMode("alphabet"){

        @Override
        public int[] sort(int[] sortIds, ItemStack[] stacks, SortContext context) {
            String[] strings = new String[sortIds.length];
            for (int i = 0; i < sortIds.length; ++i) {
                ItemStack stack = stacks[i];
                strings[i] = stack.isEmpty() ? "" : stack.getHoverName().getString();
            }
            IntArrays.quickSort((int[])sortIds, (a, b) -> {
                if (strings[a].isEmpty()) {
                    if (strings[b].isEmpty()) {
                        return 0;
                    }
                    return 1;
                }
                if (strings[b].isEmpty()) {
                    return -1;
                }
                int comp = strings[a].compareToIgnoreCase(strings[b]);
                if (comp == 0) {
                    return ItemStackUtils.compareEqualItems(stacks[a], stacks[b]);
                }
                return comp;
            });
            return sortIds;
        }
    });
    public static final SortMode CREATIVE = SortMode.register("creative", new SortMode("creative"){

        @Override
        public int[] sort(int[] sortIds, ItemStack[] stacks, SortContext context) {
            int[] sortValues = new int[sortIds.length];
            if (Config.get().options.optimizedCreativeSorting) {
                Lock lock = CreativeSearchOrder.getReadLock();
                lock.lock();
                for (int i = 0; i < stacks.length; ++i) {
                    sortValues[i] = CreativeSearchOrder.getStackSearchPosition(stacks[i]);
                }
                lock.unlock();
            } else {
                Collection displayStacks = CreativeModeTabs.searchTab().getDisplayItems();
                ArrayList displayStackList = displayStacks instanceof List ? (ArrayList)displayStacks : new ArrayList(displayStacks);
                Object2IntOpenHashMap lookup = new Object2IntOpenHashMap(stacks.length);
                for (int i = 0; i < stacks.length; ++i) {
                    ItemStack stack = stacks[i];
                    sortValues[i] = lookup.computeIfAbsent((Object)StackMatcher.of(stack), arg_0 -> 3.lambda$sort$1(displayStackList, (Object2IntMap)lookup, stack, arg_0));
                }
            }
            SortMode.sortByValues(sortIds, stacks, sortValues);
            return sortIds;
        }

        private static /* synthetic */ int lambda$sort$1(List displayStackList, Object2IntMap lookup, ItemStack stack, Object matcher) {
            int index = displayStackList.indexOf(matcher);
            if (index == -1) {
                return lookup.computeIfAbsent((Object)StackMatcher.ignoreNbt(stack), matcher2 -> {
                    int plainIndex = displayStackList.indexOf(matcher2);
                    if (plainIndex == -1) {
                        return Integer.MAX_VALUE;
                    }
                    return plainIndex;
                });
            }
            return index;
        }
    });
    public static final SortMode QUANTITY = SortMode.register("quantity", new SortMode("quantity"){

        @Override
        public int[] sort(int[] sortIds, ItemStack[] stacks, SortContext context) {
            HashMap<Item, Integer> itemToAmountMap = new HashMap<Item, Integer>();
            for (ItemStack stack : stacks) {
                if (stack.isEmpty()) continue;
                if (!itemToAmountMap.containsKey(stack.getItem())) {
                    itemToAmountMap.put(stack.getItem(), stack.getCount());
                    continue;
                }
                itemToAmountMap.put(stack.getItem(), (Integer)itemToAmountMap.get(stack.getItem()) + stack.getCount());
            }
            IntArrays.quickSort((int[])sortIds, (a, b) -> {
                ItemStack stack = stacks[a];
                ItemStack stack2 = stacks[b];
                if (stack.isEmpty()) {
                    return stack2.isEmpty() ? 0 : 1;
                }
                if (stack2.isEmpty()) {
                    return -1;
                }
                Integer amountA = (Integer)itemToAmountMap.get(stack.getItem());
                Integer amountB = (Integer)itemToAmountMap.get(stack2.getItem());
                int cmp = Integer.compare(amountB, amountA);
                if (cmp != 0) {
                    return cmp;
                }
                return ItemStackUtils.compareEqualItems(stack, stack2);
            });
            return sortIds;
        }
    });
    public static final SortMode RAW_ID = SortMode.register("raw_id", new SortMode("raw_id"){

        @Override
        public int[] sort(int[] sortIds, ItemStack[] stacks, SortContext context) {
            int[] rawIds = Arrays.stream(stacks).mapToInt(stack -> stack.isEmpty() ? Integer.MAX_VALUE : BuiltInRegistries.ITEM.getId((Object)stack.getItem())).toArray();
            SortMode.sortByValues(sortIds, stacks, rawIds);
            return sortIds;
        }
    });

    public static <T extends SortMode> T register(String name, T sortMode) {
        SORT_MODES.put(name, sortMode);
        return sortMode;
    }

    public static void unregister(String name) {
        SORT_MODES.remove(name);
    }

    protected SortMode(String name) {
        this.name = name;
    }

    public int[] sort(int[] sortIds, ItemStack[] stacks, SortContext context) {
        return sortIds;
    }

    private static void sortByValues(int[] sortIds, ItemStack[] stacks, int[] values) {
        IntArrays.quickSort((int[])sortIds, (a, b) -> {
            int cmp = Integer.compare(values[a], values[b]);
            if (cmp != 0) {
                return cmp;
            }
            return ItemStackUtils.compareEqualItems(stacks[a], stacks[b]);
        });
    }
}

