/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.clientsort.inventory.sort;

import dev.terminalmc.clientsort.inventory.ContainerScreenHelper;
import dev.terminalmc.clientsort.inventory.sort.SortContext;
import dev.terminalmc.clientsort.inventory.sort.SortMode;
import dev.terminalmc.clientsort.network.InteractionManager;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class InventorySorter {
    private final ContainerScreenHelper<? extends AbstractContainerScreen<?>> screenHelper;
    private final AbstractContainerScreen<?> containerScreen;
    private Slot[] inventorySlots;
    private final ItemStack[] stacks;

    public InventorySorter(ContainerScreenHelper<? extends AbstractContainerScreen<?>> screenHelper, AbstractContainerScreen<?> containerScreen, Slot originSlot) {
        this.screenHelper = screenHelper;
        this.containerScreen = containerScreen;
        this.collectSlots(originSlot);
        this.stacks = new ItemStack[this.inventorySlots.length];
        for (int i = 0; i < this.inventorySlots.length; ++i) {
            this.stacks[i] = this.inventorySlots[i].getItem();
        }
    }

    private void collectSlots(Slot originSlot) {
        int originScope = this.screenHelper.getScope(originSlot);
        if (originScope == Integer.MAX_VALUE) {
            this.inventorySlots = new Slot[0];
            return;
        }
        ArrayList<Slot> slotsInScope = new ArrayList<Slot>();
        for (Slot slot : this.containerScreen.getMenu().slots) {
            if (originScope != this.screenHelper.getScope(slot, true)) continue;
            slotsInScope.add(slot);
        }
        this.inventorySlots = slotsInScope.toArray(new Slot[0]);
    }

    private void combineStacks() {
        ArrayDeque<InteractionManager.InteractionEvent> clickEvents = new ArrayDeque<InteractionManager.InteractionEvent>();
        for (int i = this.stacks.length - 1; i >= 0; --i) {
            int stackSize;
            ItemStack stack = this.stacks[i];
            if (stack.isEmpty() || (stackSize = stack.getCount()) >= stack.getItem().getDefaultMaxStackSize()) continue;
            clickEvents.add(this.screenHelper.createClickEvent(this.inventorySlots[i], 0, ClickType.PICKUP));
            for (int j = 0; j < i; ++j) {
                ItemStack targetStack = this.stacks[j];
                if (targetStack.isEmpty() || targetStack.getCount() >= targetStack.getItem().getDefaultMaxStackSize() || !ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)targetStack)) continue;
                int delta = targetStack.getItem().getDefaultMaxStackSize() - targetStack.getCount();
                delta = Math.min(delta, stackSize);
                targetStack.setCount(targetStack.getCount() + delta);
                clickEvents.add(this.screenHelper.createClickEvent(this.inventorySlots[j], 0, ClickType.PICKUP));
                if ((stackSize -= delta) <= 0) break;
            }
            if (clickEvents.size() <= 1) {
                clickEvents.clear();
                continue;
            }
            InteractionManager.pushAll(clickEvents);
            InteractionManager.triggerSend(InteractionManager.TriggerType.GUI_CONFIRM);
            clickEvents.clear();
            if (stackSize > 0) {
                InteractionManager.push(this.screenHelper.createClickEvent(this.inventorySlots[i], 0, ClickType.PICKUP));
                stack.setCount(stackSize);
                continue;
            }
            this.stacks[i] = ItemStack.EMPTY;
        }
    }

    public void sort(SortMode sortMode) {
        if (this.inventorySlots.length <= 1) {
            return;
        }
        this.combineStacks();
        int[] sortIds = new int[this.stacks.length];
        for (int i = 0; i < sortIds.length; ++i) {
            sortIds[i] = i;
        }
        sortIds = sortMode.sort(sortIds, this.stacks, new SortContext(this.containerScreen, Arrays.asList(this.inventorySlots)));
        this.sortOnClient(sortIds);
    }

    protected void sortOnClient(int[] sortedIds) {
        int i;
        int slotCount = this.stacks.length;
        int[] origin2Target = new int[slotCount];
        for (int i2 = 0; i2 < origin2Target.length; ++i2) {
            origin2Target[sortedIds[i2]] = i2;
        }
        BitSet doneSlashEmpty = new BitSet(slotCount * 2);
        for (i = 0; i < slotCount; ++i) {
            if (i == sortedIds[i]) {
                doneSlashEmpty.set(i);
                continue;
            }
            if (!this.stacks[i].isEmpty()) continue;
            doneSlashEmpty.set(slotCount + i);
        }
        block2: for (i = 0; i < slotCount; ++i) {
            if (doneSlashEmpty.get(i)) continue;
            if (doneSlashEmpty.get(slotCount + sortedIds[i])) {
                doneSlashEmpty.set(sortedIds[i]);
                continue;
            }
            InteractionManager.push(this.screenHelper.createClickEvent(this.inventorySlots[sortedIds[i]], 0, ClickType.PICKUP));
            doneSlashEmpty.set(slotCount + sortedIds[i]);
            ItemStack currentStack = this.stacks[sortedIds[i]];
            Slot workingSlot = this.inventorySlots[sortedIds[i]];
            int id = i;
            do {
                if (this.stacks[id].getItem() == currentStack.getItem() && !doneSlashEmpty.get(slotCount + id) && ItemStack.isSameItemSameComponents((ItemStack)this.stacks[id], (ItemStack)currentStack)) {
                    if (this.stacks[id].getCount() == currentStack.getCount()) {
                        doneSlashEmpty.set(id);
                        id = origin2Target[id];
                        continue;
                    }
                    if (currentStack.getCount() < this.stacks[id].getCount()) {
                        Slot targetSlot = this.inventorySlots[id];
                        InteractionManager.push(this.screenHelper.createClickEvent(workingSlot, 0, ClickType.PICKUP));
                        InteractionManager.push(this.screenHelper.createClickEvent(targetSlot, 0, ClickType.PICKUP));
                        InteractionManager.push(this.screenHelper.createClickEvent(workingSlot, 0, ClickType.PICKUP));
                        InteractionManager.push(this.screenHelper.createClickEvent(targetSlot, 0, ClickType.PICKUP));
                        InteractionManager.push(this.screenHelper.createClickEvent(workingSlot, 0, ClickType.PICKUP));
                        currentStack = this.stacks[id];
                        doneSlashEmpty.set(id);
                        id = origin2Target[id];
                        continue;
                    }
                }
                InteractionManager.push(this.screenHelper.createClickEvent(this.inventorySlots[id], 0, ClickType.PICKUP));
                currentStack = this.stacks[id];
                doneSlashEmpty.set(id);
                if (doneSlashEmpty.get(slotCount + id)) continue block2;
                id = origin2Target[id];
            } while (!doneSlashEmpty.get(id));
        }
    }
}

