/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.clientsort.inventory;

import dev.terminalmc.clientsort.config.Config;
import dev.terminalmc.clientsort.inventory.CreativeContainerScreenHelper;
import dev.terminalmc.clientsort.network.ClickEventFactory;
import dev.terminalmc.clientsort.network.InteractionManager;
import dev.terminalmc.clientsort.util.inject.ISlot;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.client.gui.screens.inventory.EffectRenderingInventoryScreen;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class ContainerScreenHelper<T extends AbstractContainerScreen<?>> {
    protected final T screen;
    protected final ClickEventFactory clickEventFactory;
    public static final int INVALID_SCOPE = Integer.MAX_VALUE;

    protected ContainerScreenHelper(T screen, ClickEventFactory clickEventFactory) {
        this.screen = screen;
        this.clickEventFactory = clickEventFactory;
    }

    public static <T extends AbstractContainerScreen<?>> ContainerScreenHelper<T> of(T screen, ClickEventFactory clickEventFactory) {
        if (screen instanceof CreativeModeInventoryScreen) {
            return new CreativeContainerScreenHelper<CreativeModeInventoryScreen>((CreativeModeInventoryScreen)screen, clickEventFactory);
        }
        return new ContainerScreenHelper<T>(screen, clickEventFactory);
    }

    public InteractionManager.InteractionEvent createClickEvent(Slot slot, int action, ClickType actionType) {
        return this.clickEventFactory.create(slot, action, actionType);
    }

    public boolean isHotbarSlot(Slot slot) {
        return ((ISlot)slot).mouseWheelie_getIndexInInv() < 9;
    }

    public int getScope(Slot slot) {
        return this.getScope(slot, false);
    }

    public int getScope(Slot slot, boolean preferSmallerScopes) {
        if (slot.container == null || ((ISlot)slot).mouseWheelie_getIndexInInv() >= slot.container.getContainerSize() || !slot.mayPlace(ItemStack.EMPTY)) {
            return Integer.MAX_VALUE;
        }
        if (this.screen instanceof EffectRenderingInventoryScreen) {
            if (slot.container instanceof Inventory) {
                if (this.isHotbarSlot(slot)) {
                    Config.Options options = Config.get().options;
                    if (options.hotbarMode == Config.Options.HotbarMode.HARD || options.hotbarMode == Config.Options.HotbarMode.SOFT && preferSmallerScopes) {
                        return -1;
                    }
                } else if (((ISlot)slot).mouseWheelie_getIndexInInv() >= 40) {
                    return -1;
                }
                return 0;
            }
            return 2;
        }
        if (slot.container instanceof Inventory) {
            if (this.isHotbarSlot(slot)) {
                Config.Options options = Config.get().options;
                if (options.hotbarMode == Config.Options.HotbarMode.HARD || options.hotbarMode == Config.Options.HotbarMode.SOFT && preferSmallerScopes) {
                    return -1;
                }
            }
            return 0;
        }
        return 1;
    }
}

