/*
 * Decompiled with CFR 0.152.
 */
package tfar.overloadedarmorbar.overlay;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiGraphics;
import tfar.overloadedarmorbar.overlay.ArmorBar;
import tfar.overloadedarmorbar.overlay.ArmorIcon;
import tfar.overloadedarmorbar.overlay.ArmorIconColor;
import tfar.overloadedarmorbar.platform.Services;

public class OverlayRenderer {
    private static final int UNKNOWN_ARMOR_VALUE = -1;
    private static int previousArmorValue = -1;
    private static final int ARMOR_ICON_SIZE = 9;
    private static final int ARMOR_FIRST_HALF_ICON_SIZE = 5;
    private static final int ARMOR_SECOND_HALF_ICON_SIZE = 4;
    private static ArmorIcon[] armorIcons;

    public static void renderArmorBar(GuiGraphics graphics) {
        if (Minecraft.getInstance().gameMode.canHurtPlayer()) {
            int currentArmorValue = Minecraft.getInstance().player.getArmorValue();
            int xStart = graphics.guiWidth() / 2 - 91;
            int yPosition = graphics.guiHeight() - Services.PLATFORM.getLeftHeight(Minecraft.getInstance().gui);
            if (currentArmorValue != previousArmorValue) {
                armorIcons = ArmorBar.calculateArmorIcons(currentArmorValue);
                previousArmorValue = currentArmorValue;
            }
            int armorIconCounter = 0;
            for (ArmorIcon icon : armorIcons) {
                int xPosition = xStart + armorIconCounter * 8;
                switch (icon.armorIconType) {
                    case NONE: {
                        ArmorIconColor color = icon.primaryArmorIconColor;
                        OverlayRenderer.color4f(color.Red, color.Green, color.Blue, color.Alpha);
                        if (currentArmorValue > 20) {
                            graphics.blitSprite(Gui.ARMOR_FULL_SPRITE, xPosition, yPosition, 9, 9);
                            break;
                        }
                        if (!Services.PLATFORM.getConfig().showEmptyArmorIcons() || !Services.PLATFORM.getConfig().alwaysShowArmorBar() && currentArmorValue <= 0) break;
                        graphics.blitSprite(Gui.ARMOR_EMPTY_SPRITE, xPosition, yPosition, 9, 9);
                        break;
                    }
                    case HALF: {
                        ArmorIconColor firstHalfColor = icon.primaryArmorIconColor;
                        ArmorIconColor secondHalfColor = icon.secondaryArmorIconColor;
                        OverlayRenderer.color4f(firstHalfColor.Red, firstHalfColor.Green, firstHalfColor.Blue, firstHalfColor.Alpha);
                        graphics.blitSprite(Gui.ARMOR_HALF_SPRITE, xPosition, yPosition, 9, 9);
                        OverlayRenderer.color4f(secondHalfColor.Red, secondHalfColor.Green, secondHalfColor.Blue, secondHalfColor.Alpha);
                        if (currentArmorValue <= 20) break;
                        graphics.blitSprite(Gui.ARMOR_FULL_SPRITE, 9, 9, 5, 0, xPosition + 5, yPosition, 4, 9);
                        break;
                    }
                    case FULL: {
                        ArmorIconColor fullColor = icon.primaryArmorIconColor;
                        OverlayRenderer.color4f(fullColor.Red, fullColor.Green, fullColor.Blue, fullColor.Alpha);
                        graphics.blitSprite(Gui.ARMOR_FULL_SPRITE, xPosition, yPosition, 9, 9);
                        break;
                    }
                }
                ++armorIconCounter;
            }
            OverlayRenderer.color4f(1.0f, 1.0f, 1.0f, 1.0f);
            Services.PLATFORM.offsetLeftHeight(Minecraft.getInstance().gui, 10);
        }
    }

    private static void color4f(float r, float g, float b, float a) {
        RenderSystem.setShaderColor((float)r, (float)g, (float)b, (float)a);
    }
}

