/*
 * Decompiled with CFR 0.152.
 */
package com.illusivesoulworks.polymorph.common;

import com.illusivesoulworks.polymorph.api.PolymorphApi;
import com.illusivesoulworks.polymorph.api.common.base.IPolymorphNetwork;
import com.illusivesoulworks.polymorph.api.common.base.IPolymorphRecipeManager;
import com.illusivesoulworks.polymorph.api.common.capability.IBlockEntityRecipeData;
import com.illusivesoulworks.polymorph.api.common.capability.IPlayerRecipeData;
import com.illusivesoulworks.polymorph.common.PolymorphRecipeManager;
import com.illusivesoulworks.polymorph.common.capability.PolymorphCapabilities;
import com.illusivesoulworks.polymorph.platform.Services;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.block.entity.BlockEntity;

public class PolymorphApiImpl
extends PolymorphApi {
    public static final PolymorphApi INSTANCE = new PolymorphApiImpl();
    private final List<PolymorphApi.IBlockEntityFactory> blockEntityFactories = new LinkedList<PolymorphApi.IBlockEntityFactory>();
    private final List<PolymorphApi.IRecipeDataFactory> recipeDataFactories = new LinkedList<PolymorphApi.IRecipeDataFactory>();
    private final IPolymorphNetwork distributor = Services.PLATFORM.getPacketDistributor();
    private final IPolymorphRecipeManager recipeManager = new PolymorphRecipeManager();

    @Override
    public IPolymorphNetwork getNetwork() {
        return this.distributor;
    }

    @Override
    public IPolymorphRecipeManager getRecipeManager() {
        return this.recipeManager;
    }

    @Override
    public IBlockEntityRecipeData createBlockEntityRecipeData(BlockEntity blockEntity) {
        for (PolymorphApi.IRecipeDataFactory function : this.recipeDataFactories) {
            IBlockEntityRecipeData recipeData = function.createRecipeData(blockEntity);
            if (recipeData == null) continue;
            return recipeData;
        }
        return null;
    }

    @Override
    public IBlockEntityRecipeData getBlockEntityRecipeData(BlockEntity blockEntity) {
        return PolymorphCapabilities.getRecipeData(blockEntity);
    }

    @Override
    public IBlockEntityRecipeData getBlockEntityRecipeData(AbstractContainerMenu container) {
        for (PolymorphApi.IBlockEntityFactory function : this.blockEntityFactories) {
            BlockEntity blockEntity = function.getBlockEntity(container);
            if (blockEntity == null) continue;
            return this.getBlockEntityRecipeData(blockEntity);
        }
        return null;
    }

    @Override
    public IPlayerRecipeData getPlayerRecipeData(Player player) {
        return PolymorphCapabilities.getRecipeData(player);
    }

    @Override
    public void registerMenu(PolymorphApi.IBlockEntityFactory blockEntityFactory) {
        this.blockEntityFactories.add(blockEntityFactory);
    }

    @Override
    public void registerBlockEntity(PolymorphApi.IRecipeDataFactory recipeDataFactory) {
        this.recipeDataFactories.add(recipeDataFactory);
    }
}

