/*
 * Decompiled with CFR 0.152.
 */
package net.chococraft.neoforge.datagen;

import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.chococraft.common.world.worldgen.ModFeatures;
import net.chococraft.neoforge.common.modifier.AddChocoboModifier;
import net.chococraft.neoforge.datagen.client.ChocoBlockModels;
import net.chococraft.neoforge.datagen.client.ChocoBlockstates;
import net.chococraft.neoforge.datagen.client.ChocoItemModels;
import net.chococraft.neoforge.datagen.client.ChocoLanguage;
import net.chococraft.neoforge.datagen.client.ChocoSoundProvider;
import net.chococraft.neoforge.datagen.data.ChocoLoot;
import net.chococraft.neoforge.datagen.data.ChocoRecipes;
import net.minecraft.core.Cloner;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.RegistrySetBuilder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.registries.VanillaRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BiomeTags;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.data.DatapackBuiltinEntriesProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.common.world.BiomeModifier;
import net.neoforged.neoforge.common.world.BiomeModifiers;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import net.neoforged.neoforge.registries.DataPackRegistriesHooks;
import net.neoforged.neoforge.registries.NeoForgeRegistries;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public class ModDatagenerator {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        ExistingFileHelper helper = event.getExistingFileHelper();
        CompletableFuture lookupProvider = event.getLookupProvider();
        if (event.includeServer()) {
            generator.addProvider(event.includeServer(), (DataProvider)new ChocoLoot(packOutput, lookupProvider));
            generator.addProvider(event.includeServer(), (DataProvider)new ChocoRecipes(packOutput, lookupProvider));
            generator.addProvider(event.includeServer(), (DataProvider)new DatapackBuiltinEntriesProvider(packOutput, CompletableFuture.supplyAsync(ModDatagenerator::getProvider), Set.of("chococraft")));
        }
        if (event.includeClient()) {
            generator.addProvider(event.includeClient(), (DataProvider)new ChocoLanguage(packOutput));
            generator.addProvider(event.includeClient(), (DataProvider)new ChocoBlockModels(packOutput, helper));
            generator.addProvider(event.includeClient(), (DataProvider)new ChocoBlockstates(packOutput, helper));
            generator.addProvider(event.includeClient(), (DataProvider)new ChocoItemModels(packOutput, helper));
            generator.addProvider(event.includeClient(), (DataProvider)new ChocoSoundProvider(packOutput, helper));
        }
    }

    private static RegistrySetBuilder.PatchedRegistries getProvider() {
        RegistrySetBuilder registryBuilder = new RegistrySetBuilder();
        registryBuilder.add(Registries.CONFIGURED_FEATURE, ModFeatures::configuredBootstrap);
        registryBuilder.add(Registries.PLACED_FEATURE, ModFeatures::placedBootstrap);
        registryBuilder.add(NeoForgeRegistries.Keys.BIOME_MODIFIERS, context -> {
            HolderGetter biomeGetter = context.lookup(Registries.BIOME);
            HolderGetter placedGetter = context.lookup(Registries.PLACED_FEATURE);
            context.register(ModDatagenerator.createModifierKey("add_plains_chocobos"), (Object)new AddChocoboModifier((HolderSet<Biome>)biomeGetter.getOrThrow(Tags.Biomes.IS_PLAINS)));
            context.register(ModDatagenerator.createModifierKey("add_mountain_chocobos"), (Object)new AddChocoboModifier((HolderSet<Biome>)biomeGetter.getOrThrow(Tags.Biomes.IS_MOUNTAIN)));
            context.register(ModDatagenerator.createModifierKey("add_nether_chocobos"), (Object)new AddChocoboModifier((HolderSet<Biome>)biomeGetter.getOrThrow(BiomeTags.IS_NETHER)));
            context.register(ModDatagenerator.createModifierKey("add_gysahl_green"), (Object)new BiomeModifiers.AddFeaturesBiomeModifier((HolderSet)biomeGetter.getOrThrow(BiomeTags.IS_OVERWORLD), (HolderSet)HolderSet.direct((Holder[])new Holder[]{placedGetter.getOrThrow(ModFeatures.PLACED_PATCH_GYSAHL_GREEN)}), GenerationStep.Decoration.VEGETAL_DECORATION));
        });
        registryBuilder.add(Registries.BIOME, $ -> {});
        RegistryAccess.Frozen regAccess = RegistryAccess.fromRegistryOfRegistries((Registry)BuiltInRegistries.REGISTRY);
        Cloner.Factory cloner$factory = new Cloner.Factory();
        DataPackRegistriesHooks.getDataPackRegistriesWithDimensions().forEach(data -> data.runWithArguments((arg_0, arg_1) -> ((Cloner.Factory)cloner$factory).addCodec(arg_0, arg_1)));
        return registryBuilder.buildPatch((RegistryAccess)regAccess, VanillaRegistries.createLookup(), cloner$factory);
    }

    public static ResourceKey<BiomeModifier> createModifierKey(String name) {
        return ResourceKey.create((ResourceKey)NeoForgeRegistries.Keys.BIOME_MODIFIERS, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"chococraft", (String)name));
    }
}

