/*
 * Decompiled with CFR 0.152.
 */
package net.chococraft.neoforge.common.config;

import java.util.List;
import net.chococraft.Chococraft;
import net.chococraft.common.config.ChocoConfig;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class NeoForgeChocoConfig {
    public static final ModConfigSpec commonSpec;
    public static final Common COMMON;

    @SubscribeEvent
    public static void onLoad(ModConfigEvent.Loading configEvent) {
        Chococraft.LOGGER.debug("Loaded Chococraft's config file {}", (Object)configEvent.getConfig().getFileName());
    }

    @SubscribeEvent
    public static void onFileChange(ModConfigEvent.Reloading configEvent) {
        Chococraft.LOGGER.debug("Chococraft's config just got changed on the file system!");
        if (configEvent.getConfig().getModId().equals("chococraft") && (Integer)NeoForgeChocoConfig.COMMON.chocoboPackSizeMin.get() > (Integer)NeoForgeChocoConfig.COMMON.chocoboPackSizeMax.get()) {
            Chococraft.LOGGER.error("Chocobo Pack Size Min {} is greater than Chocobo Pack Size Max {}. This is not allowed!", NeoForgeChocoConfig.COMMON.chocoboPackSizeMin.get(), NeoForgeChocoConfig.COMMON.chocoboPackSizeMax.get());
        }
    }

    static {
        Pair specPair = new ModConfigSpec.Builder().configure(Common::new);
        commonSpec = (ModConfigSpec)specPair.getRight();
        COMMON = (Common)specPair.getLeft();
    }

    public static class Common {
        public final ModConfigSpec.IntValue chocoboSpawnWeight;
        public final ModConfigSpec.IntValue chocoboPackSizeMin;
        public final ModConfigSpec.IntValue chocoboPackSizeMax;
        public final ModConfigSpec.DoubleValue tameChance;
        public final ModConfigSpec.BooleanValue nameTamedChocobos;
        public final ModConfigSpec.BooleanValue canChocobosFly;
        public final ModConfigSpec.IntValue kwehIntervalLimit;
        public final ModConfigSpec.ConfigValue<List<? extends String>> maleNames;
        public final ModConfigSpec.ConfigValue<List<? extends String>> femaleNames;

        Common(ModConfigSpec.Builder builder) {
            builder.comment("Spawning configuration").push("spawning");
            this.chocoboSpawnWeight = builder.comment("Controls Chocobo Spawn Weight [Default: 10]").defineInRange("chocoboSpawnWeight", 10, 0, Integer.MAX_VALUE);
            this.chocoboPackSizeMin = builder.comment("Controls Chocobo Pack Size Min [Default: 1]").defineInRange("chocoboPackSizeMin", 1, 0, Integer.MAX_VALUE);
            this.chocoboPackSizeMax = builder.comment("Controls Chocobo Pack Size Max [Default: 3]").defineInRange("chocoboPackSizeMax", 3, 0, Integer.MAX_VALUE);
            builder.pop();
            builder.comment("Chocobo configuration").push("Chocobo");
            this.tameChance = builder.comment("This multiplier controls the tame chance per gysahl used, so .15 results in 15% chance to tame [Default: 0.15]").defineInRange("tameChance", 0.15, 0.0, 1.0);
            this.canChocobosFly = builder.comment("If certain chocobos are allowed to fly [Default: true]").define("canChocobosFly", true);
            this.kwehIntervalLimit = builder.comment("Determines the maximum interval duration for the Chocobo's ambient sound [Default: 100]").defineInRange("kwehIntervalLimit", 100, 1, Integer.MAX_VALUE);
            builder.pop();
            builder.comment("Naming configuration").push("Naming");
            this.nameTamedChocobos = builder.comment("If taming a chocobo will provide them with a name (unless already named) [Default: true]").define("nameTamedChocobos", true);
            this.maleNames = builder.comment("The list of male names it can choose from if 'nameTamedChocobos' is enabled").defineList("maleNames", List.of(ChocoConfig.maleNames), o -> o instanceof String);
            this.femaleNames = builder.comment("The list of female names it can choose from if 'nameTamedChocobos' is enabled").defineList("femaleNames", List.of(ChocoConfig.femaleNames), o -> o instanceof String);
            builder.pop();
        }
    }
}

